/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.pahimar.ee3.api.event.EnergyValueEvent;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.exchange.IEnergyValueProvider;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.handler.ConfigurationHandler;
import com.pahimar.ee3.recipe.RecipeRegistry;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.LoaderHelper;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class EnergyValueRegistry {
    public static final EnergyValueRegistry INSTANCE = new EnergyValueRegistry();
    private ImmutableSortedMap<WrappedStack, EnergyValue> stackValueMap;
    private ImmutableSortedMap<EnergyValue, Set<WrappedStack>> valueStackMap;
    private final Map<WrappedStack, EnergyValue> preCalculationStackValueMap;
    private final Map<WrappedStack, EnergyValue> postCalculationStackValueMap;
    private transient SortedSet<WrappedStack> uncomputedStacks;
    private transient boolean shouldSave;
    private transient boolean valuesNeedRegeneration;
    public static File energyValuesDirectory;
    public static File energyValuesFile;
    public static File preCalculationValuesFile;
    public static File postCalculationValuesFile;
    public static final Marker ENERGY_VALUE_MARKER;

    private EnergyValueRegistry() {
        ImmutableSortedMap.Builder stackMapBuilder = ImmutableSortedMap.naturalOrder();
        this.stackValueMap = stackMapBuilder.build();
        this.preCalculationStackValueMap = new TreeMap<WrappedStack, EnergyValue>();
        this.postCalculationStackValueMap = new TreeMap<WrappedStack, EnergyValue>();
        this.uncomputedStacks = new TreeSet<WrappedStack>();
        this.shouldSave = true;
    }

    public static EnergyValue getEnergyValue(Map<WrappedStack, EnergyValue> valueMap, Object object, boolean strict) {
        if (WrappedStack.canBeWrapped(object)) {
            EnergyValue energyValue;
            WrappedStack wrappedStack = WrappedStack.wrap(object, 1);
            Object wrappedObject = wrappedStack.getWrappedObject();
            if (wrappedObject instanceof ItemStack && ((ItemStack)wrappedObject).func_77973_b() instanceof IEnergyValueProvider && !strict && (energyValue = ((IEnergyValueProvider)((ItemStack)wrappedObject).func_77973_b()).getEnergyValue((ItemStack)wrappedObject)) != null && Float.compare(energyValue.getValue(), 0.0f) > 0) {
                return energyValue;
            }
            if (valueMap != null && !valueMap.isEmpty()) {
                if (wrappedObject instanceof ItemStack && ((ItemStack)wrappedObject).func_77960_j() == Short.MAX_VALUE) {
                    Set equivalentStacks = valueMap.keySet().stream().filter(wrappedStack::equals).filter(wrappedStack1 -> wrappedStack1.getWrappedObject() instanceof ItemStack).filter(wrappedStack1 -> ((ItemStack)wrappedStack1.getWrappedObject()).func_77960_j() != Short.MAX_VALUE).collect(Collectors.toCollection(TreeSet::new));
                    if (equivalentStacks.size() >= 1) {
                        EnergyValue lowestValue = null;
                        for (WrappedStack wrappedStack12 : equivalentStacks) {
                            EnergyValue currentValue = EnergyValueRegistry.getEnergyValue(valueMap, wrappedStack12, strict);
                            if (lowestValue == null) {
                                lowestValue = currentValue;
                                continue;
                            }
                            if (currentValue.compareTo(lowestValue) >= 0) continue;
                            lowestValue = currentValue;
                        }
                        return lowestValue;
                    }
                }
                if (valueMap.containsKey(wrappedStack)) {
                    return valueMap.get(wrappedStack);
                }
                if (!strict) {
                    if (wrappedObject instanceof ItemStack) {
                        ItemStack unValuedItemStack = ItemStack.func_77944_b((ItemStack)((ItemStack)wrappedObject));
                        EnergyValue minEnergyValue = null;
                        int[] oreIds = OreDictionary.getOreIDs((ItemStack)unValuedItemStack);
                        if (oreIds.length > 0) {
                            EnergyValue energyValue2 = null;
                            boolean allHaveSameValue = true;
                            for (int oreId : oreIds) {
                                String oreName = OreDictionary.getOreName((int)oreId);
                                if (!"Unknown".equalsIgnoreCase(oreName)) {
                                    WrappedStack oreStack = WrappedStack.wrap(new OreStack(oreName));
                                    if (oreStack != null && valueMap.containsKey(oreStack)) {
                                        if (energyValue2 == null) {
                                            energyValue2 = valueMap.get(oreStack);
                                            continue;
                                        }
                                        if (energyValue2.equals(valueMap.get(oreStack))) continue;
                                        allHaveSameValue = false;
                                        continue;
                                    }
                                    allHaveSameValue = false;
                                    continue;
                                }
                                allHaveSameValue = false;
                            }
                            if (allHaveSameValue) {
                                return energyValue2;
                            }
                        } else {
                            for (WrappedStack valuedWrappedStack : valueMap.keySet()) {
                                EnergyValue energyValue3;
                                ItemStack valuedItemStack;
                                if (!(valuedWrappedStack.getWrappedObject() instanceof ItemStack) || Item.func_150891_b((Item)((ItemStack)valuedWrappedStack.getWrappedObject()).func_77973_b()) != Item.func_150891_b((Item)unValuedItemStack.func_77973_b()) || (valuedItemStack = (ItemStack)valuedWrappedStack.getWrappedObject()).func_77960_j() != Short.MAX_VALUE && unValuedItemStack.func_77960_j() != Short.MAX_VALUE || (energyValue3 = valueMap.get(valuedWrappedStack)).compareTo(minEnergyValue) >= 0) continue;
                                minEnergyValue = energyValue3;
                            }
                        }
                    } else if (wrappedObject instanceof OreStack) {
                        OreStack oreStack = (OreStack)wrappedObject;
                        ArrayList itemStacks = OreDictionary.getOres((String)oreStack.oreName);
                        if (!itemStacks.isEmpty()) {
                            EnergyValue energyValue4 = null;
                            boolean allHaveSameValue = true;
                            for (ItemStack itemStack : itemStacks) {
                                WrappedStack wrappedItemStack = WrappedStack.wrap(itemStack, 1);
                                if (wrappedItemStack != null && valueMap.containsKey(wrappedItemStack)) {
                                    if (energyValue4 == null) {
                                        energyValue4 = valueMap.get(wrappedItemStack);
                                        continue;
                                    }
                                    if (energyValue4.equals(valueMap.get(wrappedItemStack))) continue;
                                    allHaveSameValue = false;
                                    continue;
                                }
                                allHaveSameValue = false;
                            }
                            if (allHaveSameValue) {
                                return energyValue4;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private static EnergyValue computeFromInputs(Map<WrappedStack, EnergyValue> valueMap, WrappedStack wrappedOutput, Collection<WrappedStack> wrappedInputs) {
        float sumOfValues = 0.0f;
        for (WrappedStack wrappedInput : wrappedInputs) {
            EnergyValue inputValue;
            int stackSize = Integer.MIN_VALUE;
            if (wrappedInput.getWrappedObject() instanceof ItemStack) {
                ItemStack inputItemStack = (ItemStack)wrappedInput.getWrappedObject();
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)inputItemStack) != null) {
                    if (inputItemStack.func_77973_b().getContainerItem(inputItemStack) != null) {
                        stackSize = FluidContainerRegistry.getFluidForFilledItem((ItemStack)inputItemStack).amount * wrappedInput.getStackSize();
                        inputValue = EnergyValueRegistry.getEnergyValue(valueMap, FluidContainerRegistry.getFluidForFilledItem((ItemStack)inputItemStack), false);
                    } else {
                        inputValue = EnergyValueRegistry.getEnergyValue(valueMap, wrappedInput, false);
                    }
                } else if (inputItemStack.func_77973_b().getContainerItem(inputItemStack) != null) {
                    ItemStack inputContainerItemStack = inputItemStack.func_77973_b().getContainerItem(inputItemStack);
                    if (EnergyValueRegistry.getEnergyValue(valueMap, inputItemStack, false) != null && EnergyValueRegistry.getEnergyValue(valueMap, inputContainerItemStack, false) != null) {
                        float itemStackValue = EnergyValueRegistry.getEnergyValue(valueMap, inputItemStack, false).getValue();
                        float containerStackValue = EnergyValueRegistry.getEnergyValue(valueMap, inputContainerItemStack, false).getValue();
                        inputValue = new EnergyValue(Float.valueOf(itemStackValue - containerStackValue));
                    } else {
                        inputValue = new EnergyValue(0);
                    }
                } else {
                    inputValue = !inputItemStack.func_77973_b().func_77630_h(inputItemStack) ? new EnergyValue(0) : (OreDictionary.getOreIDs((ItemStack)inputItemStack).length > 0 ? EnergyValueRegistry.getEnergyValue(valueMap, wrappedInput, true) : EnergyValueRegistry.getEnergyValue(valueMap, wrappedInput, false));
                }
            } else if (wrappedInput.getWrappedObject() instanceof OreStack) {
                OreStack inputOreStack = (OreStack)wrappedInput.getWrappedObject();
                inputValue = EnergyValueRegistry.getEnergyValue(valueMap, wrappedInput, false);
                for (ItemStack itemStack : OreDictionary.getOres((String)inputOreStack.oreName)) {
                    if (itemStack.func_77973_b().func_77630_h(itemStack)) continue;
                    inputValue = new EnergyValue(0);
                }
            } else {
                inputValue = EnergyValueRegistry.getEnergyValue(valueMap, wrappedInput, false);
            }
            if (inputValue != null) {
                if (stackSize == Integer.MIN_VALUE) {
                    stackSize = wrappedInput.getStackSize();
                }
                sumOfValues += inputValue.getValue() * (float)stackSize;
                continue;
            }
            return null;
        }
        return EnergyValue.factor(new EnergyValue(Float.valueOf(sumOfValues)), wrappedOutput.getStackSize());
    }

    public ImmutableMap<WrappedStack, EnergyValue> getEnergyValues() {
        return this.stackValueMap;
    }

    public Map<WrappedStack, EnergyValue> getPreCalculationStackValueMap() {
        return this.preCalculationStackValueMap;
    }

    public Map<WrappedStack, EnergyValue> getPostCalculationStackValueMap() {
        return this.postCalculationStackValueMap;
    }

    public boolean hasEnergyValue(Object object) {
        return this.hasEnergyValue(object, false);
    }

    public boolean hasEnergyValue(Object object, boolean strict) {
        return this.getEnergyValue(object, strict) != null;
    }

    public EnergyValue getEnergyValue(Object object) {
        return this.getEnergyValue(object, false);
    }

    public EnergyValue getEnergyValue(Object object, boolean strict) {
        return EnergyValueRegistry.getEnergyValue(this.stackValueMap, object, strict);
    }

    public EnergyValue getEnergyValueForStack(Object object, boolean strict) {
        WrappedStack wrappedObject = WrappedStack.wrap(object);
        EnergyValue energyValue = this.getEnergyValue(object, strict);
        if (wrappedObject != null && energyValue != null) {
            return new EnergyValue(Float.valueOf(energyValue.getValue() * (float)wrappedObject.getStackSize()));
        }
        return null;
    }

    public Set<ItemStack> getStacksInRange(Number start, Number finish) {
        return this.getStacksInRange(new EnergyValue(start), new EnergyValue(finish));
    }

    public Set<ItemStack> getStacksInRange(EnergyValue lowerBound, EnergyValue upperBound) {
        TreeSet<ItemStack> filteredItemStacks = new TreeSet<ItemStack>(Comparators.ENERGY_VALUE_ITEM_STACK_COMPARATOR);
        Set<ItemStack> greaterThanLowerBound = EnergyValueRegistry.getStacksInRange(this.getEnergyValues(), lowerBound, false);
        Set<ItemStack> lesserThanUpperBound = EnergyValueRegistry.getStacksInRange(this.getEnergyValues(), upperBound, true);
        if (!greaterThanLowerBound.isEmpty() && !lesserThanUpperBound.isEmpty()) {
            for (ItemStack itemStack : greaterThanLowerBound) {
                if (!lesserThanUpperBound.contains(itemStack)) continue;
                filteredItemStacks.add(itemStack);
            }
        } else {
            if (!greaterThanLowerBound.isEmpty()) {
                return greaterThanLowerBound;
            }
            if (!lesserThanUpperBound.isEmpty()) {
                return lesserThanUpperBound;
            }
        }
        return filteredItemStacks;
    }

    private static Set<ItemStack> getStacksInRange(Map<WrappedStack, EnergyValue> valueMap, EnergyValue energyValueBound, boolean isUpperBound) {
        Set<ItemStack> itemStacks = EnergyValueRegistry.filterForItemStacks(valueMap.keySet());
        if (valueMap != null && energyValueBound != null) {
            if (isUpperBound) {
                return FilterUtils.filterByEnergyValue(valueMap, itemStacks, energyValueBound, FilterUtils.ValueFilterType.VALUE_LOWER_THAN_BOUND, Comparators.ENERGY_VALUE_ITEM_STACK_COMPARATOR);
            }
            return FilterUtils.filterByEnergyValue(valueMap, itemStacks, energyValueBound, FilterUtils.ValueFilterType.VALUE_GREATER_THAN_BOUND, Comparators.ENERGY_VALUE_ITEM_STACK_COMPARATOR);
        }
        return new TreeSet<ItemStack>(Collections.EMPTY_SET);
    }

    public void setEnergyValue(Object object, EnergyValue energyValue, EnergyValueRegistryProxy.Phase phase) {
        this.setEnergyValue(object, energyValue, phase, false);
    }

    public void setEnergyValue(Object object, EnergyValue energyValue, EnergyValueRegistryProxy.Phase phase, boolean doRegenValues) {
        if (WrappedStack.canBeWrapped(object) && energyValue != null && Float.compare(energyValue.getValue(), 0.0f) > 0) {
            WrappedStack wrappedStack = WrappedStack.wrap(object, 1);
            EnergyValue factoredEnergyValue = EnergyValue.factor(energyValue, wrappedStack.getStackSize());
            if (phase == EnergyValueRegistryProxy.Phase.PRE_CALCULATION) {
                if (!FMLCommonHandler.instance().bus().post((Event)new EnergyValueEvent.SetEnergyValueEvent(wrappedStack, factoredEnergyValue, EnergyValueRegistryProxy.Phase.PRE_CALCULATION))) {
                    this.preCalculationStackValueMap.put(wrappedStack, factoredEnergyValue);
                    if (doRegenValues) {
                        this.compute();
                    } else {
                        this.valuesNeedRegeneration = true;
                    }
                }
            } else if (!FMLCommonHandler.instance().bus().post((Event)new EnergyValueEvent.SetEnergyValueEvent(wrappedStack, factoredEnergyValue, EnergyValueRegistryProxy.Phase.POST_CALCULATION))) {
                TreeMap<WrappedStack, EnergyValue> valueMap = new TreeMap<WrappedStack, EnergyValue>((SortedMap<WrappedStack, EnergyValue>)this.stackValueMap);
                valueMap.put(wrappedStack, energyValue);
                ImmutableSortedMap.Builder stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
                this.stackValueMap = stackMappingsBuilder.putAll(valueMap).build();
                this.postCalculationStackValueMap.put(wrappedStack, factoredEnergyValue);
            }
            if (ConfigurationHandler.Settings.energyValueDebugLoggingEnabled) {
                LogHelper.info(ENERGY_VALUE_MARKER, "[{}] Mod '{}' set a {} value of {} on object '{}' with doRegen = {}", new Object[]{LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), phase, energyValue, wrappedStack, doRegenValues});
            }
        }
    }

    public void setShouldSave(boolean shouldSave) {
        this.shouldSave = shouldSave;
    }

    public void compute() {
        this.valuesNeedRegeneration = false;
        TreeMap<WrappedStack, EnergyValue> stackValueMap = new TreeMap<WrappedStack, EnergyValue>();
        this.uncomputedStacks = new TreeSet<WrappedStack>();
        Map<WrappedStack, EnergyValue> fileValueMap = null;
        try {
            fileValueMap = SerializationHelper.readMapFromFile(preCalculationValuesFile);
        }
        catch (FileNotFoundException e) {
            LogHelper.warn(ENERGY_VALUE_MARKER, "No pre calculation energy values were loaded from file - could not find {}", preCalculationValuesFile.getAbsolutePath());
        }
        if (fileValueMap != null) {
            for (WrappedStack wrappedStack2 : fileValueMap.keySet()) {
                if (wrappedStack2 == null || wrappedStack2.getWrappedObject() == null || fileValueMap.get(wrappedStack2) == null) continue;
                this.preCalculationStackValueMap.put(wrappedStack2, fileValueMap.get(wrappedStack2));
            }
        }
        this.preCalculationStackValueMap.keySet().stream().filter(wrappedStack -> wrappedStack != null && wrappedStack.getWrappedObject() != null && this.preCalculationStackValueMap.get(wrappedStack) != null).forEach(wrappedStack -> stackValueMap.put((WrappedStack)wrappedStack, this.preCalculationStackValueMap.get(wrappedStack)));
        Map<WrappedStack, EnergyValue> computedStackValueMap = this.calculateStackValueMap(stackValueMap);
        for (WrappedStack wrappedStack3 : computedStackValueMap.keySet()) {
            stackValueMap.put(wrappedStack3, computedStackValueMap.get(wrappedStack3));
        }
        fileValueMap = null;
        try {
            fileValueMap = SerializationHelper.readMapFromFile(postCalculationValuesFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogHelper.warn(ENERGY_VALUE_MARKER, "No post calculation energy values were loaded from file - could not find {}", postCalculationValuesFile.getAbsolutePath());
        }
        if (fileValueMap != null) {
            for (WrappedStack wrappedStack3 : fileValueMap.keySet()) {
                if (wrappedStack3 == null || wrappedStack3.getWrappedObject() == null || fileValueMap.get(wrappedStack3) == null) continue;
                this.postCalculationStackValueMap.put(wrappedStack3, fileValueMap.get(wrappedStack3));
            }
        }
        this.postCalculationStackValueMap.keySet().stream().filter(wrappedStack -> wrappedStack != null && wrappedStack.getWrappedObject() != null && this.postCalculationStackValueMap.get(wrappedStack) != null).forEach(wrappedStack -> stackValueMap.put((WrappedStack)wrappedStack, this.postCalculationStackValueMap.get(wrappedStack)));
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        builder.putAll(stackValueMap);
        this.stackValueMap = builder.build();
        this.calculateValueStackMap();
        this.save();
        if (ConfigurationHandler.Settings.energyValueDebugLoggingEnabled) {
            this.uncomputedStacks.stream().filter(wrappedStack -> EnergyValueRegistry.getEnergyValue(stackValueMap, wrappedStack, false) == null).forEach(wrappedStack -> LogHelper.info(ENERGY_VALUE_MARKER, "Unable to compute an energy value for {}", wrappedStack));
        }
    }

    private Map<WrappedStack, EnergyValue> calculateStackValueMap(Map<WrappedStack, EnergyValue> stackValueMap) {
        LogHelper.info(ENERGY_VALUE_MARKER, "Beginning energy value calculation");
        long startingTime = System.nanoTime();
        TreeMap<WrappedStack, EnergyValue> computedMap = new TreeMap<WrappedStack, EnergyValue>(stackValueMap);
        TreeMap<Object, Object> tempComputedMap = new TreeMap();
        int passNumber = 0;
        while ((passNumber == 0 || tempComputedMap.size() != computedMap.size()) && passNumber < 16) {
            long passStartTime = System.nanoTime();
            ++passNumber;
            computedMap.putAll(tempComputedMap);
            tempComputedMap = new TreeMap<WrappedStack, EnergyValue>((Map<WrappedStack, EnergyValue>)computedMap);
            for (WrappedStack recipeOutput : RecipeRegistry.INSTANCE.getRecipeMappings().keySet()) {
                WrappedStack unitWrappedStack = WrappedStack.wrap(recipeOutput, 1);
                if (stackValueMap.containsKey(unitWrappedStack)) continue;
                for (Set recipeInputs : RecipeRegistry.INSTANCE.getRecipeMappings().get((Object)recipeOutput)) {
                    EnergyValue currentOutputValue = EnergyValueRegistry.getEnergyValue(tempComputedMap, unitWrappedStack, false);
                    EnergyValue computedOutputValue = EnergyValueRegistry.computeFromInputs(tempComputedMap, recipeOutput, recipeInputs);
                    if (computedOutputValue != null && computedOutputValue.compareTo(currentOutputValue) < 0) {
                        this.uncomputedStacks.remove(unitWrappedStack);
                        if (ConfigurationHandler.Settings.energyValueDebugLoggingEnabled) {
                            LogHelper.info(ENERGY_VALUE_MARKER, "Pass {}: Calculated value {} for object {} with recipe inputs {} and output {}", passNumber, computedOutputValue, unitWrappedStack, recipeInputs, recipeOutput);
                        }
                        tempComputedMap.put(unitWrappedStack, computedOutputValue);
                        continue;
                    }
                    if (computedOutputValue == null) continue;
                    this.uncomputedStacks.add(unitWrappedStack);
                }
            }
            long passDuration = System.nanoTime() - passStartTime;
            if (!ConfigurationHandler.Settings.energyValueDebugLoggingEnabled) continue;
            LogHelper.info(ENERGY_VALUE_MARKER, "Pass {}: Calculated {} different values for objects in {} ms", passNumber, tempComputedMap.size(), passDuration / 100000L);
        }
        long endingTime = System.nanoTime() - startingTime;
        LogHelper.info(ENERGY_VALUE_MARKER, "Finished energy value calculation - calculated {} new values for objects in {} ms", computedMap.size() - stackValueMap.size(), endingTime / 100000L);
        return computedMap;
    }

    private void calculateValueStackMap() {
        TreeMap<EnergyValue, TreeSet<WrappedStack>> tempValueMap = new TreeMap<EnergyValue, TreeSet<WrappedStack>>();
        for (WrappedStack wrappedStack : this.getEnergyValues().keySet()) {
            EnergyValue energyValue;
            if (wrappedStack == null || (energyValue = (EnergyValue)this.getEnergyValues().get((Object)wrappedStack)) == null) continue;
            if (tempValueMap.containsKey(energyValue)) {
                if (((Set)tempValueMap.get(energyValue)).contains(wrappedStack)) continue;
                ((Set)tempValueMap.get(energyValue)).add(wrappedStack);
                continue;
            }
            tempValueMap.put(energyValue, new TreeSet<WrappedStack>(Arrays.asList(wrappedStack)));
        }
        this.valueStackMap = ImmutableSortedMap.copyOf(tempValueMap);
    }

    private static Set<ItemStack> filterForItemStacks(Set<WrappedStack> wrappedStacks) {
        TreeSet<ItemStack> itemStacks = new TreeSet<ItemStack>(Comparators.ID_COMPARATOR);
        for (WrappedStack wrappedStack : wrappedStacks) {
            if (wrappedStack.getWrappedObject() instanceof ItemStack) {
                itemStacks.add((ItemStack)wrappedStack.getWrappedObject());
                continue;
            }
            if (!(wrappedStack.getWrappedObject() instanceof OreStack)) continue;
            itemStacks.addAll(OreDictionary.getOres((String)((OreStack)wrappedStack.getWrappedObject()).oreName));
        }
        return itemStacks;
    }

    public void save() {
        if (this.shouldSave) {
            if (this.valuesNeedRegeneration) {
                if (energyValuesFile.exists()) {
                    energyValuesFile.delete();
                }
            } else {
                SerializationHelper.writeMapToFile(this.stackValueMap, energyValuesFile);
            }
        }
        SerializationHelper.writeMapToFile(this.preCalculationStackValueMap, preCalculationValuesFile);
        SerializationHelper.writeMapToFile(this.postCalculationStackValueMap, postCalculationValuesFile);
    }

    public void load() {
        Map<WrappedStack, EnergyValue> fileValueMap = null;
        try {
            fileValueMap = SerializationHelper.readMapFromFile(preCalculationValuesFile);
        }
        catch (FileNotFoundException e) {
            LogHelper.warn(ENERGY_VALUE_MARKER, "No pre calculation energy values were loaded from file - could not find {}", preCalculationValuesFile.getAbsolutePath());
        }
        if (fileValueMap != null) {
            for (WrappedStack wrappedStack : fileValueMap.keySet()) {
                if (wrappedStack == null || wrappedStack.getWrappedObject() == null || fileValueMap.get(wrappedStack) == null) continue;
                this.preCalculationStackValueMap.put(wrappedStack, fileValueMap.get(wrappedStack));
            }
        }
        fileValueMap = null;
        try {
            fileValueMap = SerializationHelper.readMapFromFile(postCalculationValuesFile);
        }
        catch (FileNotFoundException e) {
            LogHelper.warn(ENERGY_VALUE_MARKER, "No post calculation energy values were loaded from file - could not find {}", postCalculationValuesFile.getAbsolutePath());
        }
        if (fileValueMap != null) {
            for (WrappedStack wrappedStack : fileValueMap.keySet()) {
                if (wrappedStack == null || wrappedStack.getWrappedObject() == null || fileValueMap.get(wrappedStack) == null) continue;
                this.postCalculationStackValueMap.put(wrappedStack, fileValueMap.get(wrappedStack));
            }
        }
        fileValueMap = null;
        try {
            fileValueMap = SerializationHelper.readMapFromFile(energyValuesFile);
        }
        catch (FileNotFoundException e) {
            LogHelper.warn("No calculated energy values were loaded from file - could not find {}", energyValuesFile.getAbsolutePath());
            LogHelper.info("Recomputing energy values", energyValuesFile.getAbsolutePath());
            this.compute();
        }
        if (fileValueMap != null) {
            ImmutableSortedMap.Builder stackMapBuilder = ImmutableSortedMap.naturalOrder();
            for (WrappedStack wrappedStack : fileValueMap.keySet()) {
                if (wrappedStack == null || wrappedStack.getWrappedObject() == null || fileValueMap.get(wrappedStack) == null) continue;
                stackMapBuilder.put((Object)wrappedStack, (Object)fileValueMap.get(wrappedStack));
            }
            this.stackValueMap = stackMapBuilder.build();
            this.calculateValueStackMap();
        }
    }

    public void load(Map<WrappedStack, EnergyValue> valueMap) {
        if (valueMap != null) {
            this.setShouldSave(false);
            ImmutableSortedMap.Builder stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
            valueMap.keySet().stream().filter(wrappedStack -> wrappedStack != null && wrappedStack.getWrappedObject() != null && valueMap.get(wrappedStack) != null).forEach(wrappedStack -> stackMappingsBuilder.put(wrappedStack, valueMap.get(wrappedStack)));
            this.stackValueMap = stackMappingsBuilder.build();
            this.calculateValueStackMap();
        }
    }

    static {
        ENERGY_VALUE_MARKER = MarkerManager.getMarker((String)"EE3_ENERGY_VALUE", (Marker)LogHelper.MOD_MARKER);
    }
}

