/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.command;

import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.handler.ConfigurationHandler;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageSyncEnergyValues;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandRegenEnergyValues
extends CommandBase {
    private static Map<UUID, Long> requesterMap = new HashMap<UUID, Long>();

    public String func_71517_b() {
        return "regen-energy-values";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "commands.ee3.sync-energy-values.usage";
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        boolean shouldRegen = true;
        float coolDown = 0.0f;
        UUID commandSenderUUID = ((EntityPlayer)commandSender).func_110124_au();
        if (requesterMap.containsKey(commandSenderUUID)) {
            long timeDifference = (System.nanoTime() - requesterMap.get(commandSenderUUID)) / 100000L;
            if (timeDifference >= (long)(ConfigurationHandler.Settings.serverSyncThreshold * 1000)) {
                requesterMap.remove(commandSenderUUID);
            } else {
                coolDown = (long)(ConfigurationHandler.Settings.serverSyncThreshold * 1000) - timeDifference;
                shouldRegen = false;
            }
        } else {
            requesterMap.put(commandSenderUUID, System.nanoTime() / 100000L);
        }
        if (!shouldRegen) {
            throw new WrongUsageException("commands.ee3.regen-energy-values.denied", new Object[]{Float.valueOf(coolDown / 1000.0f)});
        }
        LogHelper.info(EnergyValueRegistry.ENERGY_VALUE_MARKER, "Regenerating energy values at {}'s request", commandSender.func_70005_c_());
        EnergyValueRegistry.INSTANCE.compute();
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncEnergyValues());
        commandSender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.ee3.regen-energy-values.success", new Object[0]));
    }
}

