/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.gui;

import com.pahimar.ee3.client.gui.component.GuiComponent;
import com.pahimar.ee3.client.util.RenderUtils;
import com.pahimar.repackage.cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiBase
extends GuiContainer {
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation texture;
    protected Map<String, GuiComponent> guiComponentMap = new TreeMap<String, GuiComponent>();
    protected String title;
    private boolean shouldDrawTitle = true;
    private String activeGuiComponentId = null;
    private int adjustedMouseX = 0;
    private int adjustedMouseY = 0;

    public GuiBase(Container container) {
        this(null, container);
    }

    public GuiBase(String title, Container container) {
        this(title, container, null);
    }

    public GuiBase(Container container, ResourceLocation texture) {
        this(null, container, texture);
    }

    public GuiBase(String title, Container container, ResourceLocation texture) {
        super(container);
        this.title = title;
        this.texture = texture;
    }

    public String getActiveGuiComponentId() {
        return this.activeGuiComponentId;
    }

    public String getTitle() {
        return this.title;
    }

    public GuiBase setTitle(String title) {
        this.title = title;
        return this;
    }

    public boolean shouldDrawTitle() {
        return this.shouldDrawTitle;
    }

    public GuiBase setShouldDrawTitle(boolean shouldDrawTitle) {
        this.shouldDrawTitle = shouldDrawTitle;
        return this;
    }

    public int getAdjustedMouseX() {
        return this.adjustedMouseX;
    }

    protected GuiBase updateAdjustedMouseX(int rawMouseX) {
        this.adjustedMouseX = rawMouseX - this.getGuiPositionX();
        return this;
    }

    public int getAdjustedMouseY() {
        return this.adjustedMouseY;
    }

    protected GuiBase updateAdjustedMouseY(int rawMouseY) {
        this.adjustedMouseY = rawMouseY - this.getGuiPositionY();
        return this;
    }

    public GuiBase updateAdjustedMousePosition(int rawMouseX, int rawMouseY) {
        return this.updateAdjustedMouseX(rawMouseX).updateAdjustedMouseY(rawMouseY);
    }

    public int getScreenWidth() {
        return this.field_146294_l;
    }

    public int getScreenHeight() {
        return this.field_146295_m;
    }

    public int getGuiPositionX() {
        return this.field_147003_i;
    }

    public GuiBase setGuiPositionX(int positionX) {
        this.field_147003_i = positionX;
        return this;
    }

    public int getGuiPositionY() {
        return this.field_147009_r;
    }

    public GuiBase setGuiPositionY(int positionY) {
        this.field_147009_r = positionY;
        return this;
    }

    public int getGuiWidth() {
        return this.field_146999_f;
    }

    public GuiBase setGuiWidth(int width) {
        this.field_146999_f = width;
        return this;
    }

    public int getGuiHeight() {
        return this.field_147000_g;
    }

    public GuiBase setGuiHeight(int height) {
        this.field_147000_g = height;
        return this;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public GuiComponent getGuiComponent(String id) {
        return this.guiComponentMap.get(id);
    }

    public GuiComponent getFirstGuiComponentAt(int positionX, int positionY) {
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            if (!guiComponent.intersectsWith(positionX, positionY)) continue;
            return guiComponent;
        }
        return null;
    }

    public GuiComponent getTopGuiComponentAt(int positionX, int positionY) {
        TreeSet<GuiComponent> guiComponents = new TreeSet<GuiComponent>(GuiComponent.zIndexComparator);
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            if (!guiComponent.intersectsWith(positionX, positionY)) continue;
            guiComponents.add(guiComponent);
        }
        if (!guiComponents.isEmpty()) {
            return guiComponents.first();
        }
        return null;
    }

    public Collection<GuiComponent> getGuiComponents() {
        return this.guiComponentMap.values();
    }

    public Collection<GuiComponent> getGuiComponentsAt(int positionX, int positionY) {
        ArrayList<GuiComponent> intersectingGuiComponents = new ArrayList<GuiComponent>();
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            if (!guiComponent.intersectsWith(positionX, positionY)) continue;
            intersectingGuiComponents.add(guiComponent);
        }
        return intersectingGuiComponents;
    }

    public Collection<GuiComponent> getGuiComponentsAt(int positionX, int positionY, int zIndex) {
        ArrayList<GuiComponent> intersectingGuiComponents = new ArrayList<GuiComponent>();
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            if (!guiComponent.intersectsWith(positionX, positionY, zIndex)) continue;
            intersectingGuiComponents.add(guiComponent);
        }
        return intersectingGuiComponents;
    }

    public GuiBase addGuiComponent(GuiComponent guiComponent) {
        this.guiComponentMap.put(guiComponent.getId(), guiComponent);
        return this;
    }

    public GuiBase addGuiComponents(Collection<GuiComponent> guiComponents) {
        for (GuiComponent guiComponent : guiComponents) {
            this.guiComponentMap.put(guiComponent.getId(), guiComponent);
        }
        return this;
    }

    public void clearGuiComponents() {
        this.guiComponentMap.clear();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            guiComponent.onInit();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            guiComponent.onClose();
        }
    }

    protected void func_73869_a(char characterTyped, int keyPressed) {
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            if (!guiComponent.onKeyPress(characterTyped, keyPressed)) continue;
            return;
        }
        super.func_73869_a(characterTyped, keyPressed);
    }

    public void func_146274_d() {
        super.func_146274_d();
    }

    protected void func_73864_a(int rawMouseX, int rawMouseY, int mouseButton) {
        super.func_73864_a(rawMouseX, rawMouseY, mouseButton);
    }

    protected void func_146286_b(int rawMouseX, int rawMouseY, int mouseButton) {
        super.func_146286_b(rawMouseX, rawMouseY, mouseButton);
    }

    protected void func_146273_a(int rawMouseX, int rawMouseY, int mouseButton, long duration) {
    }

    public Slot func_146975_c(int rawMouseX, int rawMouseY) {
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!this.func_146981_a(slot, rawMouseX, rawMouseY)) continue;
            return slot;
        }
        return null;
    }

    public boolean func_146981_a(Slot slot, int rawMouseX, int rawMouseY) {
        return this.isMouseOverSlot(slot.field_75223_e, slot.field_75221_f, 16, 16, rawMouseX, rawMouseY);
    }

    protected boolean isMouseOverSlot(int slotPositionX, int slotPositionY, int slotWidth, int slotHeight, int rawMouseX, int rawMouseY) {
        return (rawMouseX -= this.getGuiPositionX()) >= slotPositionX - 1 && rawMouseX < slotPositionX + slotWidth + 1 && (rawMouseY -= this.getGuiPositionX()) >= slotPositionY - 1 && rawMouseY < slotPositionY + slotHeight + 1;
    }

    public void func_73863_a(int rawMouseX, int rawMouseY, float partialTicks) {
        super.func_73863_a(rawMouseX, rawMouseY, partialTicks);
        this.updateAdjustedMousePosition(rawMouseX, rawMouseY);
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            if (!guiComponent.intersectsWith(this.getAdjustedMouseX(), this.getAdjustedMouseY())) continue;
            guiComponent.onMouseOver(this.getAdjustedMouseX(), this.getAdjustedMouseY(), partialTicks);
        }
    }

    protected void func_146979_b(int rawMouseX, int rawMouseY) {
        if (this.shouldDrawTitle && this.title != null) {
            this.getFontRenderer().func_78276_b(StringHelper.localize(this.title), RenderUtils.getCenteredTextOffset(this.getFontRenderer(), StringHelper.localize(this.title), this.getGuiWidth()), 6, 0x404040);
        }
        this.drawComponents(true, rawMouseX, rawMouseY, 0.0f);
    }

    protected void func_146976_a(float partialTicks, int rawMouseX, int rawMouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.texture != null) {
            RenderUtils.bindTexture(this.texture);
            int xStart = (this.getScreenWidth() - this.getGuiWidth()) / 2;
            int yStart = (this.getScreenHeight() - this.getGuiHeight()) / 2;
            this.func_73729_b(xStart, yStart, 0, 0, this.getGuiWidth(), this.getGuiHeight());
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.getGuiPositionX(), (float)this.getGuiPositionY(), (float)0.0f);
        this.drawComponents(false, rawMouseX, rawMouseY, partialTicks);
        GL11.glPopMatrix();
    }

    protected void drawComponents(boolean drawForeground, int rawMouseX, int rawMouseY, float partialTicks) {
        for (GuiComponent guiComponent : this.getGuiComponents()) {
            if (!guiComponent.isVisible()) continue;
            if (drawForeground) {
                guiComponent.drawForeground(rawMouseX, rawMouseY, partialTicks);
                continue;
            }
            guiComponent.drawBackground(rawMouseX, rawMouseY, partialTicks);
        }
    }
}

