/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api.exchange;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public final class EnergyValue
implements Comparable<EnergyValue> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###,###,###,###.###");
    private float energyValue;

    public EnergyValue() {
        this(0);
    }

    public EnergyValue(Number energyValue) {
        this.energyValue = energyValue.floatValue();
    }

    public float getValue() {
        return this.energyValue;
    }

    public IChatComponent getChatComponent() {
        return new ChatComponentText("" + this.getValue());
    }

    public String toString() {
        return DECIMAL_FORMAT.format(this.energyValue);
    }

    public boolean equals(Object object) {
        return object instanceof EnergyValue && this.compareTo((EnergyValue)object) == 0;
    }

    @Override
    public int compareTo(EnergyValue energyValue) {
        if (energyValue != null) {
            return Float.compare(this.energyValue, energyValue.getValue());
        }
        return -1;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74776_a("energyValue", this.energyValue);
        return nbtTagCompound;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("energyValue")) {
            this.energyValue = nbtTagCompound.func_74760_g("energyValue");
        }
    }

    public static NBTTagCompound writeEnergyValueToNBT(EnergyValue energyValue) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        energyValue.writeToNBT(nbtTagCompound);
        return nbtTagCompound;
    }

    public static EnergyValue loadEnergyValueFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("energyValue")) {
            float energyValue = nbtTagCompound.func_74760_g("energyValue");
            return new EnergyValue(Float.valueOf(energyValue));
        }
        return null;
    }

    public static EnergyValue factor(EnergyValue energyValue, Number factor) {
        if (Float.compare(factor.floatValue(), 0.0f) != 0 && energyValue != null) {
            return new EnergyValue(Float.valueOf(new BigDecimal(energyValue.getValue() * 1.0f / factor.floatValue()).setScale(3, 6).floatValue()));
        }
        return null;
    }
}

