/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import cofh.api.inventory.IInventoryConnection;
import com.yogpc.qp.InvUtils;
import com.yogpc.qp.WorkbenchRecipe;
import com.yogpc.qp.tile.APowerTile;
import cpw.mods.fml.common.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.inventory.IInventoryConnection", modid="CoFHAPI|inventory")
public class TileWorkbench
extends APowerTile
implements IInventory,
IInventoryConnection {
    public final ItemStack[] inv = new ItemStack[45];
    final WorkbenchRecipe[] recipies = new WorkbenchRecipe[45];
    public int cur_recipe = -1;
    public short cpower = 0;

    private static final ItemStack loadItemStackFromNBT(NBTTagCompound nbt) {
        Item i = Item.func_150899_d((int)nbt.func_74765_d("id"));
        if (i == null) {
            return null;
        }
        int a = nbt.func_74762_e("Count");
        short d = nbt.func_74765_d("Damage");
        if (d < 0) {
            d = 0;
        }
        ItemStack r = new ItemStack(i, a, (int)d);
        if (nbt.func_150297_b("tag", 10)) {
            r.func_77982_d(nbt.func_74775_l("tag"));
        }
        return r;
    }

    private static final void writeItemStackToNBT(ItemStack is, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)is.func_77973_b()));
        nbt.func_74768_a("Count", is.field_77994_a);
        nbt.func_74777_a("Damage", (short)is.func_77960_j());
        if (is.field_77990_d != null) {
            nbt.func_74782_a("tag", (NBTBase)is.field_77990_d);
        }
    }

    public TileWorkbench() {
        this.configure(250.0, 0.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cur_recipe >= 0) {
            this.cpower = (short)(160.0 * this.getStoredEnergy() / this.recipies[this.cur_recipe].power);
            if (this.recipies[this.cur_recipe].power <= this.getStoredEnergy()) {
                this.useEnergy(this.recipies[this.cur_recipe].power, this.recipies[this.cur_recipe].power, true);
                this.recipies[this.cur_recipe].check(this.inv);
                for (int i = 0; i < 27; ++i) {
                    if (this.inv[i] == null || this.inv[i].field_77994_a > 0) continue;
                    this.inv[i] = null;
                }
                ItemStack is = this.inv[this.cur_recipe].func_77946_l();
                InvUtils.injectToNearTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, is);
                if (is.field_77994_a > 0) {
                    float f = 0.7f;
                    double d0 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                    double d1 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                    double d2 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                    EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + d0, (double)this.field_145848_d + d1, (double)this.field_145849_e + d2, is);
                    entityitem.field_145804_b = 10;
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                }
                this.func_70296_d();
            }
        } else {
            this.cpower = 0;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound roottag) {
        super.func_145839_a(roottag);
        NBTTagList islist = roottag.func_150295_c("Items", 10);
        for (int i = 0; i < islist.func_74745_c(); ++i) {
            NBTTagCompound istag = islist.func_150305_b(i);
            int j = istag.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= 27) continue;
            this.inv[j] = TileWorkbench.loadItemStackFromNBT(istag);
        }
        WorkbenchRecipe.getRecipes(this.inv, this.recipies, -1);
        this.cur_recipe = roottag.func_74762_e("Recipe");
        if (this.cur_recipe >= 0 && this.recipies[this.cur_recipe] == null) {
            this.cur_recipe = -1;
        }
        if (this.cur_recipe >= 0) {
            this.configure(250.0, this.recipies[this.cur_recipe].power * 2.0);
        } else {
            this.configure(250.0, 0.0);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound roottag) {
        super.func_145841_b(roottag);
        NBTTagList islist = new NBTTagList();
        for (int i = 0; i < 27; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound istag = new NBTTagCompound();
            istag.func_74774_a("Slot", (byte)i);
            TileWorkbench.writeItemStackToNBT(this.inv[i], istag);
            islist.func_74742_a((NBTBase)istag);
        }
        roottag.func_74782_a("Items", (NBTBase)islist);
        roottag.func_74768_a("Recipe", this.cur_recipe);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.cur_recipe = WorkbenchRecipe.getRecipes(this.inv, this.recipies, this.cur_recipe);
        if (this.cur_recipe >= 0) {
            this.configure(250.0, this.recipies[this.cur_recipe].power * 2.0);
        } else {
            this.configure(250.0, 0.0);
        }
    }

    @Override
    public void S_recievePacket(byte id, byte[] data, EntityPlayer ep) {
    }

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70304_b(int i) {
        ItemStack is = this.inv[i];
        this.inv[i] = null;
        this.func_70296_d();
        return is;
    }

    public ItemStack func_70298_a(int i, int _a) {
        if (this.inv[i] != null) {
            int a = Math.min(_a, this.inv[i].func_77976_d());
            if (this.inv[i].field_77994_a <= a) {
                ItemStack itemstack = this.inv[i];
                this.inv[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inv[i].func_77979_a(a);
            if (this.inv[i].field_77994_a == 0) {
                this.inv[i] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack is) {
        this.inv[i] = is;
        this.func_70296_d();
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public String func_145825_b() {
        return "tile.WorkbenchPlus.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public boolean func_70300_a(EntityPlayer ep) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : ep.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Optional.Method(modid="CoFHAPI|inventory")
    public IInventoryConnection.ConnectionType canConnectInventory(ForgeDirection arg0) {
        return IInventoryConnection.ConnectionType.FORCE;
    }
}

