/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.compat.RefineryRecipeHelper;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.IEnchantableTile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileRefinery
extends APowerTile
implements IFluidHandler,
IEnchantableTile {
    public FluidStack res;
    public final FluidStack[] src = new FluidStack[2];
    public double rem_energy;
    public long rem_time;
    public FluidStack cached;
    public float animationSpeed = 1.0f;
    private int animationStage = 0;
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    protected byte efficiency;
    public int buf;

    @Override
    public void G_reinit() {
        PowerManager.configureR(this, this.efficiency, this.unbreaking);
        this.buf = (int)(4000.0 * Math.pow(1.3, this.fortune));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.silktouch = nbttc.func_74767_n("silktouch");
        this.fortune = nbttc.func_74771_c("fortune");
        this.efficiency = nbttc.func_74771_c("efficiency");
        this.unbreaking = nbttc.func_74771_c("unbreaking");
        NBTTagList srcl = nbttc.func_150295_c("src", 10);
        for (int i = 0; i < srcl.func_74745_c(); ++i) {
            NBTTagCompound srct = srcl.func_150305_b(i);
            int j = srct.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.src.length) continue;
            this.src[j] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)srct);
        }
        this.res = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttc.func_74775_l("res"));
        this.cached = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttc.func_74775_l("cached"));
        this.rem_energy = nbttc.func_74769_h("rem_energy");
        this.rem_time = nbttc.func_74763_f("rem_time");
        this.animationSpeed = nbttc.func_74760_g("animationSpeed");
        this.animationStage = nbttc.func_74762_e("animationStage");
        this.buf = (int)(4000.0 * Math.pow(1.3, this.fortune));
        PowerManager.configureR(this, this.efficiency, this.unbreaking);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttc) {
        super.func_145841_b(nbttc);
        nbttc.func_74757_a("silktouch", this.silktouch);
        nbttc.func_74774_a("fortune", this.fortune);
        nbttc.func_74774_a("efficiency", this.efficiency);
        nbttc.func_74774_a("unbreaking", this.unbreaking);
        NBTTagList srcl = new NBTTagList();
        for (int i = 0; i < this.src.length; ++i) {
            if (this.src[i] == null) continue;
            NBTTagCompound srct = new NBTTagCompound();
            srct.func_74774_a("Slot", (byte)i);
            this.src[i].writeToNBT(srct);
            srcl.func_74742_a((NBTBase)srct);
        }
        nbttc.func_74782_a("src", (NBTBase)srcl);
        if (this.res != null) {
            nbttc.func_74782_a("res", (NBTBase)this.res.writeToNBT(new NBTTagCompound()));
        }
        if (this.cached != null) {
            nbttc.func_74782_a("cached", (NBTBase)this.cached.writeToNBT(new NBTTagCompound()));
        }
        nbttc.func_74780_a("rem_energy", this.rem_energy);
        nbttc.func_74772_a("rem_time", this.rem_time);
        nbttc.func_74776_a("animationSpeed", this.animationSpeed);
        nbttc.func_74768_a("animationStage", this.animationStage);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.simpleAnimationIterate();
            return;
        }
        if (this.field_145850_b.func_72820_D() % 20L == 7L) {
            PacketHandler.sendPacketToAround(new YogpstopPacket(this), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.cached == null) {
            this.decreaseAnimation();
            return;
        }
        if (this.rem_time > 0L) {
            --this.rem_time;
        }
        if (this.rem_time > 0L || !PowerManager.useEnergyR(this, this.rem_energy, this.unbreaking, this.efficiency)) {
            this.decreaseAnimation();
            return;
        }
        this.increaseAnimation();
        if (this.res == null) {
            this.res = this.cached.copy();
        } else {
            this.res.amount += this.cached.amount;
        }
        this.cached = null;
        this.decreaseAnimation();
        RefineryRecipeHelper.get(this);
    }

    public int getAnimationStage() {
        return this.animationStage;
    }

    private void simpleAnimationIterate() {
        if (this.animationSpeed > 1.0f) {
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    private void sendNowPacket() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeFloat(this.animationSpeed);
            PacketHandler.sendPacketToAround(new YogpstopPacket(bos.toByteArray(), this, 4), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void increaseAnimation() {
        float prev = this.animationSpeed;
        if (this.animationSpeed < 2.0f) {
            this.animationSpeed = 2.0f;
        } else if (this.animationSpeed <= 5.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed + 0.1);
        }
        this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
        if (this.animationStage > 300) {
            this.animationStage = 100;
        }
        if (this.animationSpeed != prev) {
            this.sendNowPacket();
        }
    }

    private void decreaseAnimation() {
        float prev = this.animationSpeed;
        if (this.animationSpeed >= 1.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed - 0.1);
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
        if (this.animationSpeed != prev) {
            this.sendNowPacket();
        }
    }

    @Override
    public void S_recievePacket(byte id, byte[] data, EntityPlayer ep) {
    }

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        ByteArrayDataInput badi = ByteStreams.newDataInput((byte[])data);
        switch (id) {
            case 4: {
                this.animationSpeed = badi.readFloat();
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        for (FluidStack s : this.src) {
            if (!resource.isFluidEqual(s)) continue;
            int ret = Math.min(this.buf - s.amount, resource.amount);
            if (doFill) {
                s.amount += ret;
            }
            RefineryRecipeHelper.get(this);
            return ret;
        }
        for (int i = this.src.length - 1; i >= 0; --i) {
            if (this.src[i] != null) continue;
            int ret = Math.min(this.buf, resource.amount);
            if (doFill) {
                this.src[i] = resource.copy();
                this.src[i].amount = ret;
            }
            RefineryRecipeHelper.get(this);
            return ret;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.isFluidEqual(this.res)) {
            return this.drain(from, resource.amount, doDrain);
        }
        for (int i = this.src.length - 1; i >= 0; --i) {
            if (!resource.isFluidEqual(this.src[i])) continue;
            FluidStack ret = this.src[i].copy();
            ret.amount = Math.min(resource.amount, ret.amount);
            if (doDrain) {
                this.src[i].amount -= ret.amount;
                if (this.src[i].amount == 0) {
                    this.src[i] = null;
                }
            }
            RefineryRecipeHelper.get(this);
            return ret;
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.res == null) {
            return null;
        }
        FluidStack ret = this.res.copy();
        ret.amount = Math.min(maxDrain, ret.amount);
        if (doDrain) {
            this.res.amount -= ret.amount;
            if (this.res.amount == 0) {
                this.res = null;
            }
        }
        RefineryRecipeHelper.get(this);
        return ret;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] ret = new FluidTankInfo[this.src.length + 1];
        ret[0] = new FluidTankInfo(this.res, this.buf);
        for (int i = this.src.length - 1; i >= 0; --i) {
            ret[i + 1] = new FluidTankInfo(this.src[i], this.buf);
        }
        return ret;
    }

    @Override
    public Map<Integer, Byte> get() {
        HashMap<Integer, Byte> ret = new HashMap<Integer, Byte>();
        if (this.efficiency > 0) {
            ret.put(Enchantment.field_77349_p.field_77352_x, this.efficiency);
        }
        if (this.fortune > 0) {
            ret.put(Enchantment.field_77346_s.field_77352_x, this.fortune);
        }
        if (this.unbreaking > 0) {
            ret.put(Enchantment.field_77347_r.field_77352_x, this.unbreaking);
        }
        if (this.silktouch) {
            ret.put(Enchantment.field_77348_q.field_77352_x, (byte)1);
        }
        return ret;
    }

    @Override
    public void set(int id, byte val) {
        if (id == Enchantment.field_77349_p.field_77352_x) {
            this.efficiency = val;
        } else if (id == Enchantment.field_77346_s.field_77352_x) {
            this.fortune = val;
        } else if (id == Enchantment.field_77347_r.field_77352_x) {
            this.unbreaking = val;
        } else if (id == Enchantment.field_77348_q.field_77352_x && val > 0) {
            this.silktouch = true;
        }
    }
}

