/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TilePump;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMiningWell
extends TileBasic {
    public boolean working;

    @Override
    public void C_recievePacket(byte id, byte[] data, EntityPlayer ep) {
        super.C_recievePacket(id, data, ep);
        switch (id) {
            case 4: {
                this.working = data[0] != 0;
                this.G_renew_powerConfigure();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public void G_renew_powerConfigure() {
        byte pmp = 0;
        if (this.field_145850_b != null && this.pump != ForgeDirection.UNKNOWN) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.pump.offsetX, this.field_145848_d + this.pump.offsetY, this.field_145849_e + this.pump.offsetZ);
            if (te instanceof TilePump) {
                pmp = ((TilePump)te).unbreaking;
            } else {
                this.pump = ForgeDirection.UNKNOWN;
            }
        }
        if (this.working) {
            PowerManager.configureW(this, this.efficiency, this.unbreaking, pmp);
        } else {
            PowerManager.configure0(this);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int depth = this.field_145848_d - 1;
        while (!this.S_checkTarget(depth)) {
            if (this.working) {
                this.field_145850_b.func_147449_b(this.field_145851_c, depth, this.field_145849_e, QuarryPlusI.blockPlainPipe);
            }
            --depth;
        }
        if (this.working) {
            this.S_breakBlock(this.field_145851_c, depth, this.field_145849_e);
        }
        this.S_pollItems();
    }

    private boolean S_checkTarget(int depth) {
        float h;
        if (depth < 1) {
            this.G_destroy();
            return true;
        }
        Block b = this.field_145850_b.func_72863_F().func_73158_c(this.field_145851_c >> 4, this.field_145849_e >> 4).func_150810_a(this.field_145851_c & 0xF, depth, this.field_145849_e & 0xF);
        float f = h = b == null ? -1.0f : b.func_149712_f(this.field_145850_b, this.field_145851_c, depth, this.field_145849_e);
        if (b == null || h < 0.0f || b == QuarryPlusI.blockPlainPipe || b.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, depth, this.field_145849_e)) {
            return false;
        }
        if (this.pump == ForgeDirection.UNKNOWN && b.func_149688_o().func_76224_d()) {
            return false;
        }
        if (!this.working) {
            this.working = true;
            this.G_renew_powerConfigure();
            PacketHandler.sendNowPacket(this, (byte)1);
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.working = nbttc.func_74767_n("working");
        this.G_renew_powerConfigure();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttc) {
        super.func_145841_b(nbttc);
        nbttc.func_74757_a("working", this.working);
    }

    @Override
    public void G_reinit() {
        this.working = true;
        this.G_renew_powerConfigure();
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendNowPacket(this, (byte)1);
        }
    }

    @Override
    protected void G_destroy() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.working = false;
        this.G_renew_powerConfigure();
        PacketHandler.sendNowPacket(this, (byte)0);
        for (int depth = this.field_145848_d - 1; depth > 0 && this.field_145850_b.func_147439_a(this.field_145851_c, depth, this.field_145849_e) == QuarryPlusI.blockPlainPipe; --depth) {
            this.field_145850_b.func_147468_f(this.field_145851_c, depth, this.field_145849_e);
        }
    }
}

