/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.container;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.yogpc.qp.PacketHandler;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.YogpstopPacket;
import com.yogpc.qp.container.IPacketContainer;
import com.yogpc.qp.tile.TileBasic;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class ContainerEnchList
extends Container
implements IPacketContainer {
    private final TileBasic tile;
    private final List<QuarryPlusI.BlockData> fl = new ArrayList<QuarryPlusI.BlockData>();
    private final List<QuarryPlusI.BlockData> sl = new ArrayList<QuarryPlusI.BlockData>();
    private byte inc;
    private static final byte ADD_FORTUNE = 0;
    private static final byte ADD_SILKTOUCH = 1;
    private static final byte DEL_FORTUNE = 2;
    private static final byte DEL_SILKTOUCH = 3;
    private static final byte CLEAR_ALL = 4;

    public ContainerEnchList(TileBasic tq) {
        this.tile = tq;
    }

    public boolean func_75145_c(EntityPlayer ep) {
        return ep.func_70092_e((double)this.tile.field_145851_c + 0.5, (double)this.tile.field_145848_d + 0.5, (double)this.tile.field_145849_e + 0.5) <= 64.0;
    }

    private static void writeList(List<QuarryPlusI.BlockData> l, byte d, DataOutputStream o) throws IOException {
        for (QuarryPlusI.BlockData i : l) {
            o.writeByte(d);
            o.writeUTF(i.name);
            o.writeInt(i.meta);
        }
    }

    private static void writeDiff(List<QuarryPlusI.BlockData> a, List<QuarryPlusI.BlockData> b, byte d1, byte d2, DataOutputStream o) throws IOException {
        ArrayList<QuarryPlusI.BlockData> c = new ArrayList<QuarryPlusI.BlockData>(a);
        c.removeAll(b);
        ContainerEnchList.writeList(c, d1, o);
        c = new ArrayList<QuarryPlusI.BlockData>(b);
        c.removeAll(a);
        ContainerEnchList.writeList(c, d2, o);
    }

    private byte getInclude() {
        return (byte)((this.tile.fortuneInclude ? 2 : 0) | (this.tile.silktouchInclude ? 1 : 0));
    }

    public void func_75142_b() {
        super.func_75142_b();
        byte ninc = this.getInclude();
        if (this.inc != ninc) {
            this.inc = ninc;
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ((ICrafting)this.field_75149_d.get(j)).func_71112_a((Container)this, 0, (int)this.inc);
            }
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            ContainerEnchList.writeDiff(this.fl, this.tile.fortuneList, (byte)2, (byte)0, dos);
            ContainerEnchList.writeDiff(this.sl, this.tile.silktouchList, (byte)3, (byte)1, dos);
            this.fl.clear();
            this.sl.clear();
            this.fl.addAll(this.tile.fortuneList);
            this.sl.addAll(this.tile.silktouchList);
            if (dos.size() > 0) {
                dos.writeByte(-1);
                for (int j = 0; j < this.field_75149_d.size(); ++j) {
                    PacketHandler.sendPacketToPlayer(new YogpstopPacket(this, bos.toByteArray()), (EntityPlayer)this.field_75149_d.get(j));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void func_75132_a(ICrafting p) {
        super.func_75132_a(p);
        p.func_71112_a((Container)this, 0, (int)this.getInclude());
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(4);
            ContainerEnchList.writeList(this.fl, (byte)0, dos);
            ContainerEnchList.writeList(this.sl, (byte)1, dos);
            dos.writeByte(-1);
            PacketHandler.sendPacketToPlayer(new YogpstopPacket(this, bos.toByteArray()), (EntityPlayer)p);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int i, int j) {
        if (i == 0) {
            this.tile.fortuneInclude = (j & 2) != 0;
            this.tile.silktouchInclude = (j & 1) != 0;
        }
    }

    @Override
    public void receivePacket(byte[] ba) {
        byte slot;
        ByteArrayDataInput bb = ByteStreams.newDataInput((byte[])ba);
        while ((slot = bb.readByte()) >= 0) {
            if (slot == 0) {
                this.tile.fortuneList.add(new QuarryPlusI.BlockData(bb.readUTF(), bb.readInt()));
                continue;
            }
            if (slot == 1) {
                this.tile.silktouchList.add(new QuarryPlusI.BlockData(bb.readUTF(), bb.readInt()));
                continue;
            }
            if (slot == 2) {
                this.tile.fortuneList.remove(new QuarryPlusI.BlockData(bb.readUTF(), bb.readInt()));
                continue;
            }
            if (slot == 3) {
                this.tile.silktouchList.remove(new QuarryPlusI.BlockData(bb.readUTF(), bb.readInt()));
                continue;
            }
            if (slot != 4) continue;
            this.tile.silktouchList.clear();
            this.tile.fortuneList.clear();
        }
    }
}

