/*
 * Decompiled with CFR 0.152.
 */
package portablejim.fognerf;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="fognerf", name="FogNerf", guiFactory="portablejim.fognerf.client.FogNerfGuiFactory")
public class FogNerf {
    public static Configuration configFile;
    @Mod.Instance(value="fognerf")
    public static FogNerf instance;
    public static boolean lavaFogNerf;
    public static boolean voidFogNerf;
    public static boolean waterFogNerf;
    public static boolean netherFogNerf;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        FogNerf.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("fognerf")) {
            FogNerf.syncConfig();
        }
    }

    public static void syncConfig() {
        lavaFogNerf = configFile.getBoolean("Nerf lava fog", "general", lavaFogNerf, "Nerf the fog in lava (i.e. enable clear lava)");
        voidFogNerf = configFile.getBoolean("Nerf void fog", "general", voidFogNerf, "Nerf the void fog when at low map levels");
        waterFogNerf = configFile.getBoolean("Nerf water fog", "general", waterFogNerf, "Nerf the fog in water (i.e. enable clear water)");
        netherFogNerf = configFile.getBoolean("Nerf nether fog", "general", netherFogNerf, "Nerf the fog in nether");
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    public float lavaFog() {
        return lavaFogNerf ? 0.3f : 2.0f;
    }

    public float voidFog(float nerfedValue, float regularValue) {
        return voidFogNerf ? nerfedValue : regularValue;
    }

    public float waterFog() {
        return waterFogNerf ? 0.01f : 0.1f;
    }

    public static boolean enableNetherFog() {
        FMLLog.getLogger().debug("FogNerf: " + netherFogNerf);
        return netherFogNerf;
    }

    public static float getNetherFogStart() {
        return 300.0f;
    }

    public static float getNetherFogEnd() {
        return 500.0f;
    }

    static {
        lavaFogNerf = true;
        voidFogNerf = true;
        waterFogNerf = true;
        netherFogNerf = true;
    }
}

