/*
 * Decompiled with CFR 0.152.
 */
package portablejim.fognerf;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.util.HashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityRendererTransformer
implements IClassTransformer {
    boolean obfuscated;
    HashMap<String, String> srgMap = new HashMap();

    public static MethodInsnNode methodInstruction(MethodNode method, int i) {
        return (MethodInsnNode)method.instructions.get(i);
    }

    public static boolean methodIsNot(MethodNode methodNode, int number, int type, String className, String methodName) {
        AbstractInsnNode abstractMethod = methodNode.instructions.get(number);
        if (!(abstractMethod instanceof MethodInsnNode)) {
            return true;
        }
        MethodInsnNode method = (MethodInsnNode)abstractMethod;
        boolean isMethod = method.getOpcode() == type && (className.isEmpty() || method.owner.equals(className)) && method.name.equals(methodName);
        return !isMethod;
    }

    public EntityRendererTransformer() {
        this.srgMap.put("setupFog", "func_78468_a");
        this.srgMap.put("getRespiration", "func_77501_a");
        this.srgMap.put("getWorldHasVoidParticles", "func_76564_j");
        this.srgMap.put("farPlaneDistance", "field_78530_s");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.client.renderer.EntityRenderer".equals(transformedName)) {
            this.obfuscated = !transformedName.equals(name);
            FMLLog.getLogger().debug("FogNerf: Transforming net.minecraft.client.renderer.EntityRenderer");
            basicClass = this.transformSetupFog(name, basicClass);
            FMLLog.getLogger().debug("FogNerf: Finished transforming net.minecraft.client.renderer.EntityRenderer");
        }
        return basicClass;
    }

    private byte[] transformSetupFog(String name, byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        try {
            for (MethodNode methodNode : classNode.methods) {
                String srgFunctionName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(name, methodNode.name, methodNode.desc);
                if (!this.getCorrectName("setupFog").equals(srgFunctionName)) continue;
                this.doTransformSetupFog(name, methodNode);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void doTransformSetupFog(String name, MethodNode methodNode) {
        FMLLog.getLogger().debug("FogNerf: Transforming net.minecraft.client.renderer.EntityRenderer.setupFog()");
        int i = 0;
        while (!this.isMethodWithName(methodNode.instructions.get(i), "getRespiration")) {
            ++i;
        }
        VarInsnNode variableCall = (VarInsnNode)methodNode.instructions.get(i - 1);
        MethodInsnNode getRespirationCall = (MethodInsnNode)methodNode.instructions.get(i);
        ++i;
        while (methodNode.instructions.get(i).getType() != 5) {
            ++i;
        }
        if (methodNode.instructions.get(++i).getType() != 7) {
            return;
        }
        JumpInsnNode jump = (JumpInsnNode)methodNode.instructions.get(i);
        InsnList testIfZero = new InsnList();
        testIfZero.add((AbstractInsnNode)new VarInsnNode(variableCall.getOpcode(), variableCall.var));
        testIfZero.add((AbstractInsnNode)new MethodInsnNode(getRespirationCall.getOpcode(), getRespirationCall.owner, getRespirationCall.name, getRespirationCall.desc));
        testIfZero.add((AbstractInsnNode)new JumpInsnNode(154, jump.label));
        testIfZero.add((AbstractInsnNode)new IntInsnNode(17, 2914));
        testIfZero.add((AbstractInsnNode)new FieldInsnNode(178, "portablejim/fognerf/FogNerf", "instance", "Lportablejim/fognerf/FogNerf;"));
        testIfZero.add((AbstractInsnNode)new MethodInsnNode(182, "portablejim/fognerf/FogNerf", "waterFog", "()F"));
        testIfZero.add((AbstractInsnNode)new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glFogf", "(IF)V"));
        methodNode.instructions.insertBefore(methodNode.instructions.get(i), testIfZero);
        i += 8;
        while (methodNode.instructions.get(i).getOpcode() != 17 || ((IntInsnNode)methodNode.instructions.get((int)i)).operand != 2914) {
            ++i;
        }
        if (methodNode.instructions.get(i + 1).getOpcode() != 13) {
            return;
        }
        methodNode.instructions.remove(methodNode.instructions.get(i + 1));
        InsnList lava = new InsnList();
        lava.add((AbstractInsnNode)new FieldInsnNode(178, "portablejim/fognerf/FogNerf", "instance", "Lportablejim/fognerf/FogNerf;"));
        lava.add((AbstractInsnNode)new MethodInsnNode(182, "portablejim/fognerf/FogNerf", "lavaFog", "()F"));
        methodNode.instructions.insert(methodNode.instructions.get(i), lava);
        ++i;
        while (methodNode.instructions.get(i).getOpcode() != 180 || !this.isFieldWithName(methodNode.instructions.get(i), "farPlaneDistance")) {
            ++i;
        }
        FieldInsnNode fieldCall = (FieldInsnNode)methodNode.instructions.get(i);
        VarInsnNode fieldStore = (VarInsnNode)methodNode.instructions.get(i + 1);
        while (methodNode.instructions.get(i).getOpcode() != 184 || !((MethodInsnNode)methodNode.instructions.get((int)i)).name.equals("glFogi")) {
            ++i;
        }
        InsnList setF1Value = new InsnList();
        setF1Value.add((AbstractInsnNode)new FieldInsnNode(178, "portablejim/fognerf/FogNerf", "instance", "Lportablejim/fognerf/FogNerf;"));
        setF1Value.add((AbstractInsnNode)new VarInsnNode(25, 0));
        setF1Value.add((AbstractInsnNode)new FieldInsnNode(fieldCall.getOpcode(), fieldCall.owner, fieldCall.name, fieldCall.desc));
        setF1Value.add((AbstractInsnNode)new VarInsnNode(23, fieldStore.var));
        setF1Value.add((AbstractInsnNode)new MethodInsnNode(182, "portablejim/fognerf/FogNerf", "voidFog", "(FF)F"));
        setF1Value.add((AbstractInsnNode)new VarInsnNode(fieldStore.getOpcode(), fieldStore.var));
        methodNode.instructions.insert(methodNode.instructions.get(i), setF1Value);
        while (EntityRendererTransformer.methodIsNot(methodNode, i, 182, "net/minecraft/world/WorldProvider", "doesXZShowFog")) {
            ++i;
        }
        JumpInsnNode netherJump = (JumpInsnNode)methodNode.instructions.get(++i);
        while (EntityRendererTransformer.methodIsNot(methodNode, i, 184, "java/lang/Math", "min")) {
            ++i;
        }
        while (EntityRendererTransformer.methodIsNot(methodNode, i, 184, "org/lwjgl/opengl/GL11", "glFogf")) {
            ++i;
        }
        InsnList setNetherFog = new InsnList();
        setNetherFog.add((AbstractInsnNode)new MethodInsnNode(184, "portablejim/fognerf/FogNerf", "enableNetherFog", "()Z"));
        setNetherFog.add((AbstractInsnNode)new JumpInsnNode(153, netherJump.label));
        setNetherFog.add((AbstractInsnNode)new IntInsnNode(17, 2915));
        setNetherFog.add((AbstractInsnNode)new MethodInsnNode(184, "portablejim/fognerf/FogNerf", "getNetherFogStart", "()F"));
        setNetherFog.add((AbstractInsnNode)new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glFogf", "(IF)V"));
        setNetherFog.add((AbstractInsnNode)new IntInsnNode(17, 2916));
        setNetherFog.add((AbstractInsnNode)new MethodInsnNode(184, "portablejim/fognerf/FogNerf", "getNetherFogEnd", "()F"));
        setNetherFog.add((AbstractInsnNode)new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glFogf", "(IF)V"));
        methodNode.instructions.insert(methodNode.instructions.get(i), setNetherFog);
        FMLLog.getLogger().debug("FogNerf: Finished transforming net.minecraft.client.renderer.EntityRenderer.setupFog()");
    }

    private String getCorrectName(String name) {
        return this.obfuscated ? this.srgMap.get(name) : name;
    }

    public boolean isMethodWithName(AbstractInsnNode instruction, String name) {
        if (instruction.getType() == 5) {
            MethodInsnNode methodNode = (MethodInsnNode)instruction;
            String srgName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(methodNode.owner, methodNode.name, methodNode.desc);
            return srgName.equals(this.getCorrectName(name));
        }
        return false;
    }

    public boolean isFieldWithName(AbstractInsnNode instruction, String name) {
        if (instruction.getType() == 4) {
            FieldInsnNode fieldNode = (FieldInsnNode)instruction;
            String srgName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(fieldNode.owner, fieldNode.name, fieldNode.desc);
            return srgName.equals(this.getCorrectName(name));
        }
        return false;
    }
}

