/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class JsonToNBTConverter {
    private final String jsonString;

    public JsonToNBTConverter(String jsonString) {
        this.jsonString = jsonString;
    }

    public NBTTagCompound convert() {
        JsonParser parser = new JsonParser();
        JsonElement el = parser.parse(this.jsonString);
        return this.getTag((JsonObject)el);
    }

    private NBTTagCompound getTag(JsonObject object) {
        NBTTagCompound nbt = new NBTTagCompound();
        block12: for (Map.Entry entry : object.entrySet()) {
            JsonObject keyObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            int type = keyObject.get("type").getAsInt();
            JsonElement element = keyObject.get("value");
            switch (type) {
                case 1: {
                    nbt.func_74774_a((String)entry.getKey(), (byte)element.getAsDouble());
                    continue block12;
                }
                case 2: {
                    nbt.func_74777_a((String)entry.getKey(), (short)element.getAsDouble());
                }
                case 3: {
                    nbt.func_74768_a((String)entry.getKey(), (int)element.getAsDouble());
                    continue block12;
                }
                case 4: {
                    nbt.func_74772_a((String)entry.getKey(), (long)element.getAsDouble());
                    continue block12;
                }
                case 5: {
                    nbt.func_74776_a((String)entry.getKey(), (float)element.getAsDouble());
                    continue block12;
                }
                case 6: {
                    nbt.func_74780_a((String)entry.getKey(), element.getAsDouble());
                    continue block12;
                }
                case 8: {
                    nbt.func_74778_a((String)entry.getKey(), element.getAsString());
                    continue block12;
                }
                case 9: {
                    JsonArray array = element.getAsJsonArray();
                    NBTTagList tagList = new NBTTagList();
                    for (JsonElement e : array) {
                        tagList.func_74742_a((NBTBase)this.getTag(e.getAsJsonObject()));
                    }
                    nbt.func_74782_a((String)entry.getKey(), (NBTBase)tagList);
                    continue block12;
                }
                case 10: {
                    nbt.func_74782_a((String)entry.getKey(), (NBTBase)this.getTag(element.getAsJsonObject()));
                    continue block12;
                }
                case 11: {
                    JsonArray array = element.getAsJsonArray();
                    int[] intArray = new int[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        intArray[i] = array.get(i).getAsInt();
                    }
                    nbt.func_74782_a((String)entry.getKey(), (NBTBase)new NBTTagIntArray(intArray));
                    continue block12;
                }
            }
            throw new IllegalArgumentException("NBT type no " + type + " is not supported by the Json to NBT converter!");
        }
        return nbt;
    }
}

