/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.IRedstoneControl;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityUVLightBox
extends TileEntityPneumaticBase
implements ISidedInventory,
IMinWorkingPressure,
IRedstoneControl {
    @DescSynced
    public boolean leftConnected;
    @DescSynced
    public boolean rightConnected;
    @DescSynced
    public boolean areLightsOn;
    @GuiSynced
    public int redstoneMode;
    @DescSynced
    public ItemStack[] inventory = new ItemStack[5];
    public int ticksExisted;
    public static final int INVENTORY_SIZE = 5;
    public static final int PCB_INDEX = 0;
    public static final int UPGRADE_SLOT_START = 1;
    public static final int UPGRADE_SLOT_END = 4;
    private boolean oldRedstoneStatus;

    public TileEntityUVLightBox() {
        super(5.0f, 7.0f, 2000);
        this.setUpgradeSlots(1, 2, 3, 4);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.redstoneMode = nbt.func_74762_e("redstoneMode");
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("redstoneMode", this.redstoneMode);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbt.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticksExisted;
            if (this.getPressure(ForgeDirection.UNKNOWN) >= 1.0f && this.inventory[0] != null && this.inventory[0].func_77973_b() == Itemss.emptyPCB && this.inventory[0].func_77960_j() > 0) {
                this.addAir((int)(-2.0f * this.getSpeedUsageMultiplierFromUpgrades(this.getUpgradeSlots())), ForgeDirection.UNKNOWN);
                if (this.ticksExisted % Math.max(1, (int)(600.0f / (5.0f * this.getSpeedMultiplierFromUpgrades(this.getUpgradeSlots())))) == 0) {
                    if (!this.areLightsOn) {
                        this.areLightsOn = true;
                        this.updateNeighbours();
                    }
                    this.inventory[0].func_77964_b(Math.max(0, this.inventory[0].func_77960_j() - 1));
                }
            } else if (this.areLightsOn) {
                this.areLightsOn = false;
                this.updateNeighbours();
            }
            if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
                this.oldRedstoneStatus = !this.oldRedstoneStatus;
                this.updateNeighbours();
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.updateConnections();
    }

    public int getLightLevel() {
        return this.areLightsOn ? Math.min(5, this.getUpgrades(5) * 2) + 10 : 0;
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        return side != ForgeDirection.UP && side != ForgeDirection.getOrientation((int)this.func_145832_p()) && side != ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
    }

    public void updateConnections() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isConnectedTo(direction)) continue;
            boolean checkingLeft = ForgeDirection.getOrientation((int)this.func_145832_p()).getRotation(ForgeDirection.UP) == direction;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (te instanceof IPneumaticMachine) {
                boolean isConnected = ((IPneumaticMachine)te).isConnectedTo(direction.getOpposite());
                if (checkingLeft) {
                    this.leftConnected = isConnected;
                    continue;
                }
                this.rightConnected = isConnected;
                continue;
            }
            if (checkingLeft) {
                this.leftConnected = false;
                continue;
            }
            this.rightConnected = false;
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return Blockss.uvLightBox.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 || itemstack != null && itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 4) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        }
    }

    public boolean shouldEmitRedstone() {
        if (this.redstoneMode == 0 || this.inventory[0] == null || this.inventory[0].func_77973_b() != Itemss.emptyPCB) {
            return false;
        }
        switch (this.redstoneMode) {
            case 1: {
                return this.inventory[0].func_77960_j() < 30;
            }
            case 2: {
                return this.inventory[0].func_77960_j() < 20;
            }
            case 3: {
                return this.inventory[0].func_77960_j() < 10;
            }
            case 4: {
                return this.inventory[0].func_77960_j() == 0;
            }
        }
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public float getMinWorkingPressure() {
        return 1.0f;
    }
}

