/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import pneumaticCraft.common.ai.StringFilterEntitySelector;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.minigun.Minigun;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IGUITextFieldSensitive;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.tileentity.TileEntitySecurityStation;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntitySentryTurret
extends TileEntityBase
implements IRedstoneControlled,
ISidedInventory,
IGUITextFieldSensitive {
    private final ItemStack[] inventory = new ItemStack[8];
    @GuiSynced
    private String entityFilter = "";
    @GuiSynced
    private int redstoneMode;
    @DescSynced
    private int range;
    @DescSynced
    private boolean activated;
    @DescSynced
    private ItemStack minigunColorStack;
    private Minigun minigun;
    @DescSynced
    private int targetEntityId = -1;
    @DescSynced
    private boolean sweeping;
    private final SentryTurretEntitySelector entitySelector = new SentryTurretEntitySelector();

    public TileEntitySentryTurret() {
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            EntityLivingBase target;
            this.range = 16 + Math.min(16, this.getUpgrades(8));
            if (this.getMinigun().getAttackTarget() == null && this.redstoneAllows()) {
                List entities;
                this.getMinigun().setSweeping(true);
                if (this.field_145850_b.func_82737_E() % 20L == 0L && (entities = this.field_145850_b.func_82733_a(EntityLivingBase.class, this.getTargetingBoundingBox(), (IEntitySelector)this.entitySelector)).size() > 0) {
                    Collections.sort(entities, new TargetSorter());
                    this.getMinigun().setAttackTarget((EntityLivingBase)entities.get(0));
                    this.targetEntityId = ((EntityLivingBase)entities.get(0)).func_145782_y();
                }
            } else {
                this.getMinigun().setSweeping(false);
            }
            if ((target = this.getMinigun().getAttackTarget()) != null) {
                if (!this.redstoneAllows() || !this.entitySelector.func_82704_a((Entity)target)) {
                    this.getMinigun().setAttackTarget(null);
                    this.targetEntityId = -1;
                } else if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                    this.getFakePlayer().func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    boolean usedAmmo = this.getMinigun().tryFireMinigun(target);
                    if (usedAmmo) {
                        for (int i = 4; i < this.inventory.length; ++i) {
                            if (this.inventory[i] == null) continue;
                            this.func_70299_a(i, null);
                            break;
                        }
                    }
                }
            }
        }
        this.getMinigun().update((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
    }

    private boolean canSeeEntity(Entity entity) {
        Vec3 tileVec;
        Vec3 entityVec = Vec3.func_72443_a((double)(entity.field_70165_t + (double)(entity.field_70130_N / 2.0f)), (double)(entity.field_70163_u + (double)(entity.field_70131_O / 2.0f)), (double)(entity.field_70161_v + (double)(entity.field_70130_N / 2.0f)));
        MovingObjectPosition trace = this.field_145850_b.func_72933_a(entityVec, tileVec = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)));
        return trace != null && trace.field_72311_b == this.field_145851_c && trace.field_72312_c == this.field_145848_d && trace.field_72309_d == this.field_145849_e;
    }

    private AxisAlignedBB getTargetingBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.range), (double)(this.field_145848_d - this.range), (double)(this.field_145849_e - this.range), (double)(this.field_145851_c + this.range + 1), (double)(this.field_145848_d + this.range + 1), (double)(this.field_145849_e + this.range + 1));
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        this.updateAmmo();
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        Entity entity = this.field_145850_b.func_73045_a(this.targetEntityId);
        if (entity instanceof EntityLivingBase) {
            this.getMinigun().setAttackTarget((EntityLivingBase)entity);
        } else {
            this.getMinigun().setAttackTarget(null);
        }
    }

    public Minigun getMinigun() {
        if (this.minigun == null) {
            this.minigun = new MinigunSentryTurret();
            this.minigun.setWorld(this.field_145850_b);
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.minigun.setPlayer(this.getFakePlayer());
            }
        }
        return this.minigun;
    }

    private EntityPlayer getFakePlayer() {
        return FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(null, "Sentry Turret"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        TileEntitySentryTurret.writeInventoryToNBT(tag, this.inventory);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74778_a("entityFilter", this.entityFilter);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        TileEntitySentryTurret.readInventoryFromNBT(tag, this.inventory);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.setText(0, tag.func_74779_i("entityFilter"));
    }

    @Override
    public boolean redstoneAllows() {
        if (this.redstoneMode == 3) {
            return true;
        }
        return super.redstoneAllows();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    public String func_145825_b() {
        return Blockss.sentryTurret.func_149739_a();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (slot >= 4) {
            this.updateAmmo();
        }
    }

    private void updateAmmo() {
        ItemStack ammo = null;
        for (int i = 4; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            ammo = this.inventory[i];
            break;
        }
        this.getMinigun().setAmmo(ammo);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 4) {
            return stack != null && stack.func_77973_b() == Itemss.machineUpgrade;
        }
        return stack != null && stack.func_77973_b() == Itemss.gunAmmo;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.isGuiUseableByPlayer(p_70300_1_);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.entityFilter = text;
        this.entitySelector.setFilter(text);
        if (this.minigun != null) {
            this.minigun.setAttackTarget(null);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.entityFilter;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getTargetingBoundingBox();
    }

    private class SentryTurretEntitySelector
    extends StringFilterEntitySelector {
        private SentryTurretEntitySelector() {
        }

        @Override
        public boolean func_82704_a(Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71075_bZ.field_75098_d || this.isExcludedBySecurityStations(player)) {
                    return false;
                }
            }
            return super.func_82704_a(entity) && this.inRange(entity) && TileEntitySentryTurret.this.canSeeEntity(entity);
        }

        private boolean inRange(Entity entity) {
            return PneumaticCraftUtils.distBetween(new ChunkPosition(TileEntitySentryTurret.this.field_145851_c, TileEntitySentryTurret.this.field_145848_d, TileEntitySentryTurret.this.field_145849_e), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) <= (double)TileEntitySentryTurret.this.range;
        }

        private boolean isExcludedBySecurityStations(EntityPlayer player) {
            Iterator<TileEntitySecurityStation> iterator = PneumaticCraftUtils.getSecurityStations(TileEntitySentryTurret.this.field_145850_b, TileEntitySentryTurret.this.field_145851_c, TileEntitySentryTurret.this.field_145848_d, TileEntitySentryTurret.this.field_145849_e, false).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (iterator.next().doesAllowPlayer(player)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class TargetSorter
    implements Comparator<Entity> {
        private final ChunkPosition pos;

        public TargetSorter() {
            this.pos = new ChunkPosition(TileEntitySentryTurret.this.field_145851_c, TileEntitySentryTurret.this.field_145848_d, TileEntitySentryTurret.this.field_145849_e);
        }

        @Override
        public int compare(Entity arg0, Entity arg1) {
            double dist1 = PneumaticCraftUtils.distBetween(this.pos, arg0.field_70165_t, arg0.field_70163_u, arg0.field_70161_v);
            double dist2 = PneumaticCraftUtils.distBetween(this.pos, arg1.field_70165_t, arg1.field_70163_u, arg1.field_70161_v);
            return Double.compare(dist1, dist2);
        }
    }

    private class MinigunSentryTurret
    extends Minigun {
        public MinigunSentryTurret() {
            super(true);
        }

        @Override
        public boolean isMinigunActivated() {
            return TileEntitySentryTurret.this.activated;
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            TileEntitySentryTurret.this.activated = activated;
        }

        @Override
        public void setAmmoColorStack(ItemStack ammo) {
            TileEntitySentryTurret.this.minigunColorStack = ammo;
        }

        @Override
        public int getAmmoColor() {
            return this.getAmmoColor(TileEntitySentryTurret.this.minigunColorStack);
        }

        @Override
        public void playSound(String soundName, float volume, float pitch) {
            TileEntitySentryTurret.this.field_145850_b.func_72908_a((double)TileEntitySentryTurret.this.field_145851_c + 0.5, (double)TileEntitySentryTurret.this.field_145848_d + 0.5, (double)TileEntitySentryTurret.this.field_145849_e + 0.5, soundName, volume, pitch);
        }

        @Override
        public void setSweeping(boolean sweeping) {
            TileEntitySentryTurret.this.sweeping = sweeping;
        }

        @Override
        public boolean isSweeping() {
            return TileEntitySentryTurret.this.sweeping;
        }
    }
}

