/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import pneumaticCraft.api.drone.DroneConstructingEvent;
import pneumaticCraft.api.drone.IPathNavigator;
import pneumaticCraft.api.item.IProgrammable;
import pneumaticCraft.common.ai.DroneAIManager;
import pneumaticCraft.common.ai.FakePlayerItemInWorldManager;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.entity.EntityProgrammableController;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSpawnParticle;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetDroneConditionEntity;
import pneumaticCraft.common.progwidgets.ProgWidgetEntityAttack;
import pneumaticCraft.common.progwidgets.ProgWidgetEntityExport;
import pneumaticCraft.common.progwidgets.ProgWidgetEntityImport;
import pneumaticCraft.common.progwidgets.ProgWidgetStandby;
import pneumaticCraft.common.progwidgets.ProgWidgetSuicide;
import pneumaticCraft.common.progwidgets.ProgWidgetTeleport;
import pneumaticCraft.common.thirdparty.computercraft.ProgWidgetCC;
import pneumaticCraft.common.tileentity.IMinWorkingPressure;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;

public class TileEntityProgrammableController
extends TileEntityPneumaticBase
implements ISidedInventory,
IFluidHandler,
IMinWorkingPressure,
IDroneBase {
    private ItemStack[] inventory;
    private final int INVENTORY_SIZE = 5;
    private final FluidTank tank = new FluidTank(16000);
    private DroneAIManager aiManager;
    private EntityDrone.DroneFakePlayer fakePlayer;
    private ItemStack[] droneItems;
    private final Map<String, IExtendedEntityProperties> properties = new HashMap<String, IExtendedEntityProperties>();
    private List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final int[] redstoneLevels = new int[6];
    private String droneName = "";
    @DescSynced
    private double targetX;
    @DescSynced
    private double targetY;
    @DescSynced
    private double targetZ;
    @DescSynced
    @LazySynced
    private double curX;
    @DescSynced
    @LazySynced
    private double curY;
    @DescSynced
    @LazySynced
    private double curZ;
    public double oldCurX;
    public double oldCurY;
    public double oldCurZ;
    private EntityProgrammableController drone;
    @DescSynced
    private int diggingX;
    @DescSynced
    private int diggingY;
    @DescSynced
    private int diggingZ;
    private int dispenserUpgrades;
    private int speedUpgrades;
    private static final Set<Class<? extends IProgWidget>> WIDGET_BLACKLIST = new HashSet<Class<? extends IProgWidget>>();

    public TileEntityProgrammableController() {
        super(5.0f, 7.0f, 5000);
        this.inventory = new ItemStack[5];
        this.setUpgradeSlots(1, 2, 3, 4);
        MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent(this));
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.oldCurX = this.curX;
        this.oldCurY = this.curY;
        this.oldCurZ = this.curZ;
        if (PneumaticCraftUtils.distBetween(this.getPosition(), this.targetX, this.targetY, this.targetZ) <= this.getSpeed()) {
            this.curX = this.targetX;
            this.curY = this.targetY;
            this.curZ = this.targetZ;
        } else {
            Vec3 vec = Vec3.func_72443_a((double)(this.targetX - this.curX), (double)(this.targetY - this.curY), (double)(this.targetZ - this.curZ)).func_72432_b();
            this.curX += vec.field_72450_a * this.getSpeed();
            this.curY += vec.field_72448_b * this.getSpeed();
            this.curZ += vec.field_72449_c * this.getSpeed();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.getAIManager();
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.dispenserUpgrades = this.getUpgrades(1);
                this.speedUpgrades = this.getUpgrades(5);
                for (int i = this.getDroneSlots(); i < 36; ++i) {
                    ItemStack stack = this.getFakePlayer().field_71071_by.func_70301_a(i);
                    if (stack == null) continue;
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, stack));
                    this.getFakePlayer().field_71071_by.func_70299_a(i, null);
                }
                this.tank.setCapacity((this.dispenserUpgrades + 1) * 16000);
                if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
                    this.tank.getFluid().amount = this.tank.getCapacity();
                }
            }
            for (int i = 0; i < 4; ++i) {
                this.getFakePlayer().field_71134_c.func_73075_a();
            }
            if (this.getPressure(ForgeDirection.UNKNOWN) >= this.getMinWorkingPressure()) {
                if (!this.aiManager.isIdling()) {
                    this.addAir(-10, ForgeDirection.UNKNOWN);
                }
                this.aiManager.onUpdateTasks();
            }
        } else {
            if (this.drone == null || this.drone.field_70128_L) {
                this.drone = new EntityProgrammableController(this.field_145850_b, this);
                this.drone.field_70165_t = this.curX;
                this.drone.field_70163_u = this.curY;
                this.drone.field_70161_v = this.curZ;
                this.field_145850_b.func_72838_d((Entity)this.drone);
            }
            this.drone.func_70107_b(this.curX, this.curY, this.curZ);
        }
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        if (this.drone != null) {
            this.drone.func_70106_y();
        }
    }

    private double getSpeed() {
        return (double)Math.min(10, this.speedUpgrades) * 0.1 + 0.1;
    }

    private void initializeFakePlayer() {
        String playerUUID = null;
        String playerName = "Drone";
        this.fakePlayer = new EntityDrone.DroneFakePlayer((WorldServer)this.field_145850_b, new GameProfile(playerUUID != null ? UUID.fromString(playerUUID) : null, playerName), new FakePlayerItemInWorldManager(this.field_145850_b, this.fakePlayer, this), this);
        this.fakePlayer.field_71135_a = new NetHandlerPlayServer(MinecraftServer.func_71276_C(), new NetworkManager(false), (EntityPlayerMP)this.fakePlayer);
        this.fakePlayer.field_71071_by = new InventoryPlayer((EntityPlayer)this.fakePlayer){
            private ItemStack oldStack;

            public int func_70302_i_() {
                return TileEntityProgrammableController.this.getDroneSlots();
            }

            public void func_70299_a(int slot, ItemStack stack) {
                super.func_70299_a(slot, stack);
                if (slot == 0) {
                    if (this.oldStack != null) {
                        TileEntityProgrammableController.this.getFakePlayer().func_110140_aT().func_111148_a(this.oldStack.func_111283_C());
                    }
                    if (stack != null) {
                        TileEntityProgrammableController.this.getFakePlayer().func_110140_aT().func_111147_b(stack.func_111283_C());
                    }
                    this.oldStack = stack;
                }
            }
        };
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length + this.getDroneSlots();
    }

    public ItemStack func_70301_a(int slot) {
        return slot < 5 ? this.inventory[slot] : this.getFakePlayer().field_71071_by.func_70301_a(slot - 5);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot < 5) {
            this.inventory[slot] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
            if (slot == 0) {
                if (itemStack != null && TileEntityProgrammableController.isProgrammableAndValidForDrone(this, itemStack)) {
                    this.progWidgets = TileEntityProgrammer.getProgWidgets(itemStack);
                    if (!this.field_145850_b.field_72995_K) {
                        this.getAIManager().setWidgets(this.progWidgets);
                    }
                } else {
                    this.progWidgets.clear();
                    this.targetX = (double)this.field_145851_c + 0.5;
                    this.targetY = (double)this.field_145848_d + 0.6;
                    this.targetZ = (double)this.field_145849_e + 0.5;
                    boolean updateNeighbours = false;
                    for (int i = 0; i < this.redstoneLevels.length; ++i) {
                        if (this.redstoneLevels[i] <= 0) continue;
                        this.redstoneLevels[i] = 0;
                        updateNeighbours = true;
                    }
                    if (updateNeighbours) {
                        this.updateNeighbours();
                    }
                }
                this.getAIManager();
            }
        } else {
            this.getFakePlayer().field_71071_by.func_70299_a(slot - 5, itemStack);
        }
    }

    public String func_145825_b() {
        return Blockss.programmableController.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[5];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        NBTTagList droneItemTag = tag.func_150295_c("droneItems", 10);
        this.droneItems = new ItemStack[this.getDroneSlots()];
        for (int i = 0; i < droneItemTag.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = droneItemTag.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.droneItems.length) continue;
            this.droneItems[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        NBTTagList extendedList = tag.func_150295_c("extendedProperties", 10);
        for (int i = 0; i < extendedList.func_74745_c(); ++i) {
            NBTTagCompound propertyTag = extendedList.func_150305_b(i);
            String key = propertyTag.func_74779_i("key");
            IExtendedEntityProperties property = this.properties.get(key);
            if (property != null) {
                property.loadNBTData(propertyTag);
                continue;
            }
            Log.warning("Extended entity property \"" + key + "\" doesn't exist in a Programmable Controller");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        NBTTagList droneItems = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.getDroneSlots(); ++currentIndex) {
            if (this.getFakePlayer().field_71071_by.func_70301_a(currentIndex) == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.getFakePlayer().field_71071_by.func_70301_a(currentIndex).func_77955_b(tagCompound);
            droneItems.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("droneItems", (NBTBase)droneItems);
        NBTTagList extendedList = new NBTTagList();
        for (Map.Entry<String, IExtendedEntityProperties> entry : this.properties.entrySet()) {
            NBTTagCompound propertyTag = new NBTTagCompound();
            propertyTag.func_74778_a("key", entry.getKey());
            entry.getValue().saveNBTData(propertyTag);
            extendedList.func_74742_a((NBTBase)propertyTag);
        }
        tag.func_74782_a("extendedProperties", (NBTBase)extendedList);
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        this.func_70299_a(0, this.func_70301_a(0));
    }

    private int getDroneSlots() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K ? 0 : Math.min(36, 1 + this.dispenserUpgrades);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i != 0 || TileEntityProgrammableController.isProgrammableAndValidForDrone(this, itemstack);
    }

    public static boolean isProgrammableAndValidForDrone(IDroneBase drone, ItemStack programmable) {
        if (programmable != null && programmable.func_77973_b() instanceof IProgrammable && ((IProgrammable)programmable.func_77973_b()).canProgram(programmable) && ((IProgrammable)programmable.func_77973_b()).usesPieces(programmable)) {
            List<IProgWidget> widgets = TileEntityProgrammer.getProgWidgets(programmable);
            for (IProgWidget widget : widgets) {
                if (drone.isProgramApplicable(widget)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int var1) {
        if (ForgeDirection.getOrientation((int)var1) == ForgeDirection.UP) {
            return new int[]{0};
        }
        if (this.field_145850_b.field_72995_K) {
            return new int[0];
        }
        int[] mainInv = new int[this.func_70302_i_()];
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            mainInv[i] = i + 5;
        }
        return mainInv;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int p_102007_3_) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public float getPressure(ItemStack iStack) {
        return this.getPressure(ForgeDirection.UNKNOWN);
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        this.addAir(amount, ForgeDirection.UNKNOWN);
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 7.0f;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public IInventory getInventory() {
        return this.getFakePlayer().field_71071_by;
    }

    @Override
    public Vec3 getPosition() {
        if (this.curX == 0.0 && this.curY == 0.0 && this.curZ == 0.0) {
            this.curX = (double)this.field_145851_c + 0.5;
            this.curY = (double)this.field_145848_d + 0.6;
            this.curZ = (double)this.field_145849_e + 0.5;
            this.targetX = this.curX;
            this.targetY = this.curY;
            this.targetZ = this.curZ;
        }
        return Vec3.func_72443_a((double)this.curX, (double)this.curY, (double)this.curZ);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return new IPathNavigator(){

            @Override
            public boolean moveToXYZ(double x, double y, double z) {
                int blockZ;
                int blockY;
                int blockX = (int)Math.floor(x);
                if (TileEntityProgrammableController.this.isBlockValidPathfindBlock(blockX, blockY = (int)Math.floor(y), blockZ = (int)Math.floor(z))) {
                    TileEntityProgrammableController.this.targetX = x + 0.5;
                    TileEntityProgrammableController.this.targetY = y - 0.3;
                    TileEntityProgrammableController.this.targetZ = z + 0.5;
                    return true;
                }
                return false;
            }

            @Override
            public boolean moveToEntity(Entity entity) {
                return this.moveToXYZ(entity.field_70165_t, entity.field_70163_u + 0.3, entity.field_70161_v);
            }

            @Override
            public boolean hasNoPath() {
                return TileEntityProgrammableController.this.targetX == TileEntityProgrammableController.this.curX && TileEntityProgrammableController.this.targetY == TileEntityProgrammableController.this.curY && TileEntityProgrammableController.this.targetZ == TileEntityProgrammableController.this.curZ;
            }

            @Override
            public boolean isGoingToTeleport() {
                return false;
            }
        };
    }

    @Override
    public void sendWireframeToClient(int x, int y, int z) {
    }

    @Override
    public EntityPlayerMP getFakePlayer() {
        if (this.fakePlayer == null) {
            this.initializeFakePlayer();
        }
        if (this.droneItems != null) {
            ItemStack[] copyDroneItems = this.droneItems;
            this.droneItems = null;
            for (int i = 0; i < copyDroneItems.length; ++i) {
                this.fakePlayer.field_71071_by.func_70299_a(i, copyDroneItems[i]);
            }
        }
        return this.fakePlayer;
    }

    @Override
    public boolean isBlockValidPathfindBlock(int x, int y, int z) {
        return this.field_145850_b.func_147437_c(x, y, z);
    }

    @Override
    public void dropItem(ItemStack stack) {
        Vec3 pos = this.getPosition();
        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack));
    }

    @Override
    public void setDugBlock(int x, int y, int z) {
        this.diggingX = x;
        this.diggingY = y;
        this.diggingZ = z;
    }

    public ChunkPosition getDugPosition() {
        return this.diggingX != 0 || this.diggingY != 0 || this.diggingZ != 0 ? new ChunkPosition(this.diggingX, this.diggingY, this.diggingZ) : null;
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
    }

    @Override
    public boolean isProgramApplicable(IProgWidget widget) {
        return !WIDGET_BLACKLIST.contains(widget.getClass());
    }

    @Override
    public EntityAITasks getTargetAI() {
        return null;
    }

    @Override
    public IExtendedEntityProperties getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, IExtendedEntityProperties property) {
        this.properties.put(key, property);
    }

    @Override
    public void setEmittingRedstone(ForgeDirection orientation, int emittingRedstone) {
        this.redstoneLevels[orientation.ordinal()] = emittingRedstone;
        this.updateNeighbours();
    }

    public int getEmittingRedstone(int direction) {
        return this.redstoneLevels[direction];
    }

    @Override
    public void setName(String string) {
        this.droneName = string;
        if (this.drone != null) {
            this.drone.func_94058_c(this.droneName);
        }
        if (this.inventory[0] != null) {
            this.inventory[0].func_151001_c(string);
        }
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        Log.warning("Drone AI setting carrying entity. However a Programmable Controller can't carry entities!");
        new Throwable().printStackTrace();
    }

    @Override
    public Entity getCarryingEntity() {
        return null;
    }

    @Override
    public boolean isAIOverriden() {
        return false;
    }

    @Override
    public void onItemPickupEvent(EntityItem curPickingUpEntity, int stackSize) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(resource) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    @Override
    public void overload() {
        for (int i = 0; i < 10; ++i) {
            NetworkHandler.sendToAllAround(new PacketSpawnParticle("largesmoke", (double)this.field_145851_c + this.field_145850_b.field_73012_v.nextDouble(), this.field_145848_d + 1, (double)this.field_145849_e + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0), this.field_145850_b);
        }
    }

    @Override
    public DroneAIManager getAIManager() {
        if (this.aiManager == null && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.aiManager = new DroneAIManager(this, new ArrayList<IProgWidget>());
            this.aiManager.setWidgets(this.getProgWidgets());
            this.aiManager.dontStopWhenEndReached();
        }
        return this.aiManager;
    }

    @Override
    public void updateLabel() {
    }

    @Override
    public void addDebugEntry(String message) {
    }

    @Override
    public void addDebugEntry(String message, ChunkPosition pos) {
    }

    static {
        WIDGET_BLACKLIST.add(ProgWidgetCC.class);
        WIDGET_BLACKLIST.add(ProgWidgetEntityAttack.class);
        WIDGET_BLACKLIST.add(ProgWidgetDroneConditionEntity.class);
        WIDGET_BLACKLIST.add(ProgWidgetStandby.class);
        WIDGET_BLACKLIST.add(ProgWidgetSuicide.class);
        WIDGET_BLACKLIST.add(ProgWidgetTeleport.class);
        WIDGET_BLACKLIST.add(ProgWidgetEntityExport.class);
        WIDGET_BLACKLIST.add(ProgWidgetEntityImport.class);
    }
}

