/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.tileentity.TileEntityOmnidirectionalHopper;
import pneumaticCraft.common.util.FluidUtils;
import pneumaticCraft.common.util.IOHelper;

public class TileEntityLiquidHopper
extends TileEntityOmnidirectionalHopper
implements IFluidHandler {
    @DescSynced
    private final FluidTank tank = new FluidTank(16000);

    public TileEntityLiquidHopper() {
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    @Override
    protected int getInvSize() {
        return 4;
    }

    @Override
    public String func_145825_b() {
        return Blockss.liquidHopper.func_149739_a();
    }

    @Override
    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    protected boolean exportItem(int maxItems) {
        Block fluidBlock;
        FluidStack extractedFluid;
        IFluidHandler fluidHandler;
        TileEntity neighbor;
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
        if (this.tank.getFluid() != null && (neighbor = IOHelper.getNeighbor(this, dir)) instanceof IFluidHandler && (fluidHandler = (IFluidHandler)neighbor).canFill(dir.getOpposite(), this.tank.getFluid().getFluid())) {
            FluidStack fluid = this.tank.getFluid().copy();
            fluid.amount = Math.min(maxItems * 100, this.tank.getFluid().amount - (this.leaveMaterial ? 1000 : 0));
            if (fluid.amount > 0) {
                this.tank.getFluid().amount -= fluidHandler.fill(dir.getOpposite(), fluid, true);
                if (this.tank.getFluidAmount() <= 0) {
                    this.tank.setFluid(null);
                }
                return true;
            }
        }
        if (this.field_145850_b.func_147437_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ)) {
            for (EntityItem entity : TileEntityLiquidHopper.getNeighborItems(this, dir)) {
                if (entity.field_70128_L) continue;
                ArrayList<ItemStack> returnedItems = new ArrayList<ItemStack>();
                if (!FluidUtils.tryExtractingLiquid(this, entity.func_92059_d(), returnedItems)) continue;
                if (entity.func_92059_d().field_77994_a <= 0) {
                    entity.func_70106_y();
                }
                for (ItemStack stack : returnedItems) {
                    EntityItem item = new EntityItem(this.field_145850_b, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                    item.field_70159_w = entity.field_70159_w;
                    item.field_70181_x = entity.field_70181_x;
                    item.field_70179_y = entity.field_70179_y;
                    this.field_145850_b.func_72838_d((Entity)item);
                }
                return true;
            }
        }
        if (this.getUpgrades(1) > 0 && this.field_145850_b.func_147437_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) && (extractedFluid = this.drain(ForgeDirection.UNKNOWN, 1000, false)) != null && extractedFluid.amount == 1000 && (fluidBlock = extractedFluid.getFluid().getBlock()) != null) {
            this.drain(ForgeDirection.UNKNOWN, 1000, true);
            this.field_145850_b.func_147449_b(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, fluidBlock);
        }
        return false;
    }

    @Override
    protected boolean suckInItem(int maxItems) {
        Fluid fluid;
        int filledFluid;
        IFluidHandler fluidHandler;
        FluidStack fluid2;
        TileEntity inputInv = IOHelper.getNeighbor(this, this.inputDir);
        if (inputInv instanceof IFluidHandler && (fluid2 = (fluidHandler = (IFluidHandler)inputInv).drain(this.inputDir.getOpposite(), maxItems * 100, false)) != null && fluidHandler.canDrain(this.inputDir.getOpposite(), fluid2.getFluid()) && (filledFluid = this.fill(this.inputDir, fluid2, true)) > 0) {
            fluidHandler.drain(this.inputDir.getOpposite(), filledFluid, true);
            return true;
        }
        if (this.field_145850_b.func_147437_c(this.field_145851_c + this.inputDir.offsetX, this.field_145848_d + this.inputDir.offsetY, this.field_145849_e + this.inputDir.offsetZ)) {
            for (EntityItem entity : TileEntityLiquidHopper.getNeighborItems(this, this.inputDir)) {
                if (entity.field_70128_L) continue;
                ArrayList<ItemStack> returnedItems = new ArrayList<ItemStack>();
                if (!FluidUtils.tryInsertingLiquid(this, entity.func_92059_d(), false, returnedItems)) continue;
                if (entity.func_92059_d().field_77994_a <= 0) {
                    entity.func_70106_y();
                }
                for (ItemStack stack : returnedItems) {
                    EntityItem item = new EntityItem(this.field_145850_b, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                    item.field_70159_w = entity.field_70159_w;
                    item.field_70181_x = entity.field_70181_x;
                    item.field_70179_y = entity.field_70179_y;
                    this.field_145850_b.func_72838_d((Entity)item);
                }
                return true;
            }
        }
        if (this.getUpgrades(1) > 0 && this.field_145850_b.func_72805_g(this.field_145851_c + this.inputDir.offsetX, this.field_145848_d + this.inputDir.offsetY, this.field_145849_e + this.inputDir.offsetZ) == 0 && (fluid = FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_147439_a(this.field_145851_c + this.inputDir.offsetX, this.field_145848_d + this.inputDir.offsetY, this.field_145849_e + this.inputDir.offsetZ))) != null && this.fill(ForgeDirection.UNKNOWN, new FluidStack(fluid, 1000), false) == 1000) {
            this.fill(ForgeDirection.UNKNOWN, new FluidStack(fluid, 1000), true);
            this.field_145850_b.func_147468_f(this.field_145851_c + this.inputDir.offsetX, this.field_145848_d + this.inputDir.offsetY, this.field_145849_e + this.inputDir.offsetZ);
            return true;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(resource) ? this.drain(ForgeDirection.UNKNOWN, resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(this.leaveMaterial ? Math.min(maxDrain, this.tank.getFluidAmount() - 1000) : maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
    }
}

