/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.tileentity.IComparatorSupport;
import pneumaticCraft.common.tileentity.TileEntityBase;

public class TileEntityCompressedIronBlock
extends TileEntityBase
implements IHeatExchanger,
IComparatorSupport {
    protected final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    @DescSynced
    private int heatLevel = 10;
    private int oldComparatorOutput = 0;
    private static final int MIN_HEAT_LEVEL_TEMPERATURE = 73;
    private static final int MAX_HEAT_LEVEL_TEMPERATURE = 473;

    public TileEntityCompressedIronBlock() {
        this.heatExchanger.setThermalResistance(0.01);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.heatExchanger;
    }

    public int getHeatLevel() {
        return this.heatLevel;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.heatLevel = TileEntityCompressedIronBlock.getHeatLevelForTemperature(this.heatExchanger.getTemperature());
            int comparatorOutput = TileEntityCompressedIronBlock.getComparatorOutput((int)this.heatExchanger.getTemperature());
            if (this.oldComparatorOutput != comparatorOutput) {
                this.oldComparatorOutput = comparatorOutput;
                this.updateNeighbours();
            }
        }
    }

    public static int getHeatLevelForTemperature(double temperature) {
        if (temperature < 73.0) {
            return 0;
        }
        if (temperature > 473.0) {
            return 19;
        }
        return (int)((temperature - 73.0) * 20.0 / 400.0);
    }

    public static double[] getColorForHeatLevel(int heatLevel) {
        if (heatLevel > 9) {
            double greenAndBlue = 1.0 - (double)(heatLevel - 10) / 10.0;
            return new double[]{1.0, greenAndBlue, greenAndBlue};
        }
        double redAndGreen = (double)heatLevel / 10.0;
        return new double[]{redAndGreen, redAndGreen, 1.0};
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    public static int getComparatorOutput(int temperature) {
        if ((temperature -= 200) < 73) {
            return 0;
        }
        if (temperature > 473) {
            return 15;
        }
        return (temperature - 73) * 16 / 400;
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        return TileEntityCompressedIronBlock.getComparatorOutput((int)this.heatExchanger.getTemperature());
    }
}

