/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.recipe.AssemblyRecipe;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.recipes.programs.AssemblyProgram;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;
import pneumaticCraft.common.tileentity.TileEntityAssemblyRobot;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityAssemblyDrill
extends TileEntityAssemblyRobot {
    @DescSynced
    public boolean isDrillOn;
    @DescSynced
    @LazySynced
    private float drillSpeed;
    public float drillRotation;
    public float oldDrillRotation;
    private int drillStep;

    @Override
    public void func_145845_h() {
        this.oldDrillRotation = this.drillRotation;
        super.func_145845_h();
        this.drillSpeed = this.isDrillOn ? Math.min(this.drillSpeed + 1.0f * this.speed, 100.0f) : Math.max(this.drillSpeed - 1.0f, 0.0f);
        this.drillRotation += this.drillSpeed;
        while (this.drillRotation >= 360.0f) {
            this.drillRotation -= 360.0f;
        }
        if (!this.field_145850_b.field_72995_K && this.drillStep > 0) {
            ForgeDirection[] platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.drillStep = 1;
            }
            switch (this.drillStep) {
                case 1: {
                    this.slowMode = false;
                    this.gotoHomePosition();
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 3: {
                    this.isDrillOn = true;
                    break;
                }
                case 4: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 5: {
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    this.isDrillOn = false;
                    TileEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof TileEntityAssemblyPlatform)) break;
                    TileEntityAssemblyPlatform platform = (TileEntityAssemblyPlatform)te;
                    platform.hasDrilledStack = true;
                    ItemStack output = TileEntityAssemblyDrill.getDrilledOutputForItem(platform.getHeldStack());
                    if (output == null) break;
                    platform.setHeldStack(output);
                    break;
                }
                case 6: {
                    this.slowMode = false;
                    this.gotoHomePosition();
                }
            }
            if (this.isDoneInternal()) {
                ++this.drillStep;
                if (this.drillStep > 6) {
                    this.drillStep = 0;
                }
            }
        }
    }

    public void goDrilling() {
        if (this.drillStep == 0) {
            this.drillStep = 1;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("drill", this.isDrillOn);
        tag.func_74776_a("drillSpeed", this.drillSpeed);
        tag.func_74768_a("drillStep", this.drillStep);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isDrillOn = tag.func_74767_n("drill");
        this.drillSpeed = tag.func_74760_g("drillSpeed");
        this.drillStep = tag.func_74762_e("drillStep");
    }

    @Override
    public boolean isIdle() {
        return this.drillStep == 0 && this.isDoneInternal();
    }

    private boolean isDoneInternal() {
        if (super.isDoneMoving()) {
            return this.isDrillOn ? this.drillSpeed > 99.0f : PneumaticCraftUtils.areFloatsEqual(this.drillSpeed, 0.0f);
        }
        return false;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    public static ItemStack getDrilledOutputForItem(ItemStack input) {
        for (AssemblyRecipe recipe : AssemblyRecipe.drillRecipes) {
            if (!AssemblyProgram.isValidInput(recipe, input)) continue;
            return recipe.getOutput().func_77946_l();
        }
        return null;
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isDrillOn = false;
        this.drillStep = 6;
        return false;
    }
}

