/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.sensor.pollSensors;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.util.Rectangle;
import pneumaticCraft.api.universalSensor.IPollSensorSetting;

public class WorldTicktimeSensor
implements IPollSensorSetting {
    @Override
    public String getSensorPath() {
        return "dispenser/World/Tick time (lag)";
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.BLACK + "Emits a redstone level dependant on the time used by the server to update the world this Universal Sensor is in. This time is calculated in the same way as Forge's /tps command. With the textbox you can select a resolution as follows:");
        text.add(EnumChatFormatting.RED + "Strength = Ticktime(mS) * TextboxValue");
        text.add(EnumChatFormatting.GREEN + "Example:  Ticktime = 20mS ; Textbox text = '0.5'");
        text.add(EnumChatFormatting.GREEN + "Strength = 20 * 0.5 = 10");
        return text;
    }

    @Override
    public int getPollFrequency(TileEntity te) {
        return 40;
    }

    @Override
    public int getRedstoneValue(World world, int x, int y, int z, int sensorRange, String textBoxText) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        double worldTickTime = (double)WorldTicktimeSensor.mean((long[])server.worldTickTimes.get(world.field_73011_w.field_76574_g)) * 1.0E-6;
        try {
            int redstoneStrength = (int)(worldTickTime * Double.parseDouble(textBoxText));
            return Math.min(15, redstoneStrength);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
    }

    @Override
    public Rectangle needsSlot() {
        return null;
    }
}

