/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.sensor;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import org.lwjgl.util.Rectangle;
import pneumaticCraft.api.universalSensor.IBlockAndCoordinateEventSensor;
import pneumaticCraft.api.universalSensor.IBlockAndCoordinatePollSensor;
import pneumaticCraft.api.universalSensor.IEventSensorSetting;
import pneumaticCraft.api.universalSensor.IPollSensorSetting;
import pneumaticCraft.api.universalSensor.ISensorSetting;
import pneumaticCraft.api.universalSensor.SensorRegistrator;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.sensor.eventSensors.BlockInteractSensor;
import pneumaticCraft.common.sensor.eventSensors.PlayerAttackSensor;
import pneumaticCraft.common.sensor.eventSensors.PlayerItemPickupSensor;
import pneumaticCraft.common.sensor.pollSensors.BlockComparatorSensor;
import pneumaticCraft.common.sensor.pollSensors.BlockHeatSensor;
import pneumaticCraft.common.sensor.pollSensors.BlockLightLevelSensor;
import pneumaticCraft.common.sensor.pollSensors.BlockMetadataSensor;
import pneumaticCraft.common.sensor.pollSensors.BlockPresenceSensor;
import pneumaticCraft.common.sensor.pollSensors.BlockRedstoneSensor;
import pneumaticCraft.common.sensor.pollSensors.PlayerHealthSensor;
import pneumaticCraft.common.sensor.pollSensors.TwitchStreamerSensor;
import pneumaticCraft.common.sensor.pollSensors.UserSetSensor;
import pneumaticCraft.common.sensor.pollSensors.WorldDayLightSensor;
import pneumaticCraft.common.sensor.pollSensors.WorldGlobalVariableSensor;
import pneumaticCraft.common.sensor.pollSensors.WorldPlayersInServerSensor;
import pneumaticCraft.common.sensor.pollSensors.WorldRainingSensor;
import pneumaticCraft.common.sensor.pollSensors.WorldTicktimeSensor;
import pneumaticCraft.common.sensor.pollSensors.WorldTimeSensor;
import pneumaticCraft.common.sensor.pollSensors.WorldWeatherForecaster;
import pneumaticCraft.common.sensor.pollSensors.entity.EntityInRangeSensor;
import pneumaticCraft.common.tileentity.TileEntityUniversalSensor;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class SensorHandler
implements SensorRegistrator.ISensorRegistrator {
    private final List<ISensorSetting> sensors = new ArrayList<ISensorSetting>();
    private final List<String> sensorPaths = new ArrayList<String>();

    public static SensorHandler instance() {
        return (SensorHandler)SensorRegistrator.sensorRegistrator;
    }

    public static void init() {
        SensorRegistrator.sensorRegistrator = new SensorHandler();
        SensorRegistrator.sensorRegistrator.registerSensor(new EntityInRangeSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new PlayerAttackSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new PlayerItemPickupSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new BlockInteractSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new WorldDayLightSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new WorldRainingSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new WorldTimeSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new WorldWeatherForecaster());
        SensorRegistrator.sensorRegistrator.registerSensor(new WorldPlayersInServerSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new WorldTicktimeSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new WorldGlobalVariableSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new BlockPresenceSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new BlockMetadataSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new BlockComparatorSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new BlockRedstoneSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new BlockLightLevelSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new BlockHeatSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new UserSetSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new TwitchStreamerSensor());
        SensorRegistrator.sensorRegistrator.registerSensor(new PlayerHealthSensor());
    }

    public ISensorSetting getSensorFromPath(String buttonPath) {
        for (int i = 0; i < this.sensorPaths.size(); ++i) {
            if (!this.sensorPaths.get(i).equals(buttonPath)) continue;
            return this.sensors.get(i);
        }
        return null;
    }

    public ISensorSetting getSensorByIndex(int index) {
        return this.sensors.get(index);
    }

    public String[] getSensorNames() {
        String[] sensorNames = new String[this.sensorPaths.size()];
        for (int i = 0; i < sensorNames.length; ++i) {
            sensorNames[i] = this.sensorPaths.get(i).substring(this.sensorPaths.get(i).lastIndexOf(47) + 1);
        }
        return sensorNames;
    }

    public ISensorSetting getSensorForName(String name) {
        String[] sensorNames = this.getSensorNames();
        for (int i = 0; i < sensorNames.length; ++i) {
            if (!sensorNames[i].equals(name)) continue;
            return this.sensors.get(i);
        }
        return null;
    }

    public List<String> getUpgradeInfo() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.GRAY + "The following combinations of upgrades are used in sensors to work:");
        for (String sensorPath : this.sensorPaths) {
            ItemStack[] requiredStacks = this.getRequiredStacksFromText(sensorPath.split("/")[0]);
            String upgradeTitle = "";
            for (ItemStack stack : requiredStacks) {
                upgradeTitle = upgradeTitle + stack.func_82833_r() + " + ";
            }
            upgradeTitle = EnumChatFormatting.BLACK + "-" + upgradeTitle.substring(0, upgradeTitle.length() - 3).replace("Machine Upgrade: ", "");
            if (text.contains(upgradeTitle)) continue;
            text.add(upgradeTitle);
        }
        return text;
    }

    public void addMachineUpgradeInfo(List tooltip, int upgradeMeta) {
        for (String sensorPath : this.sensorPaths) {
            ItemStack[] requiredStacks;
            for (ItemStack stack : requiredStacks = this.getRequiredStacksFromText(sensorPath)) {
                if (stack.func_77973_b() != Itemss.machineUpgrade || stack.func_77960_j() != upgradeMeta) continue;
                tooltip.add(Blockss.universalSensor.func_149739_a());
                return;
            }
        }
    }

    private String sortRequiredUpgrades(String path) {
        String[] requiredUpgrades = path.split("/")[0].split("_");
        PneumaticCraftUtils.sortStringArrayAlphabetically(requiredUpgrades);
        String newPath = "";
        for (String upgrade : requiredUpgrades) {
            newPath = newPath + upgrade + "_";
        }
        return newPath.substring(0, newPath.length() - 1) + path.replace(path.split("/")[0], "");
    }

    public String[] getDirectoriesAtLocation(String path) {
        ArrayList<String> directories = new ArrayList<String>();
        for (String sensorPath : this.sensorPaths) {
            if (!sensorPath.startsWith(path) || sensorPath.equals(path)) continue;
            String[] folders = sensorPath.substring(path.length()).split("/");
            if (folders[0].equals("") && folders.length > 1) {
                if (directories.contains(folders[1])) continue;
                directories.add(folders[1]);
                continue;
            }
            if (directories.contains(folders[0])) continue;
            directories.add(folders[0]);
        }
        String[] directoryArray = directories.toArray(new String[directories.size()]);
        PneumaticCraftUtils.sortStringArrayAlphabetically(directoryArray);
        return directoryArray;
    }

    public ItemStack[] getRequiredStacksFromText(String buttonText) {
        String[] stacks = buttonText.split("/")[0].split("_");
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (String stack : stacks) {
            if (stack.equals("entityTracker")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 3));
                continue;
            }
            if (stack.equals("blockTracker")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 4));
                continue;
            }
            if (stack.equals("volume")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 0));
                continue;
            }
            if (stack.equals("dispenser")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 1));
                continue;
            }
            if (stack.equals("speed")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 5));
                continue;
            }
            if (stack.equals("itemLife")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 2));
                continue;
            }
            if (stack.equals("itemSearch")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 6));
                continue;
            }
            if (stack.equals("coordinateTracker")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 7));
                continue;
            }
            if (stack.equals("range")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 8));
                continue;
            }
            if (stack.equals("security")) {
                itemStacks.add(new ItemStack(Itemss.machineUpgrade, 1, 9));
                continue;
            }
            if (!stack.equals("gpsTool")) continue;
            itemStacks.add(new ItemStack(Itemss.GPSTool));
        }
        return itemStacks.toArray(new ItemStack[itemStacks.size()]);
    }

    @Override
    public void registerSensor(ISensorSetting sensor) {
        this.sensors.add(sensor);
        this.sensorPaths.add(this.sortRequiredUpgrades(sensor.getSensorPath()));
    }

    @Override
    public void registerSensor(IBlockAndCoordinateEventSensor sensor) {
        this.registerSensor(new BlockAndCoordinateEventSensor(sensor));
    }

    @Override
    public void registerSensor(IBlockAndCoordinatePollSensor sensor) {
        this.registerSensor(new BlockAndCoordinatePollSensor(sensor));
    }

    private class BlockAndCoordinatePollSensor
    implements IPollSensorSetting {
        private final IBlockAndCoordinatePollSensor coordinateSensor;

        public BlockAndCoordinatePollSensor(IBlockAndCoordinatePollSensor sensor) {
            this.coordinateSensor = sensor;
        }

        @Override
        public String getSensorPath() {
            return this.coordinateSensor.getSensorPath();
        }

        @Override
        public boolean needsTextBox() {
            return this.coordinateSensor.needsTextBox();
        }

        @Override
        public List<String> getDescription() {
            return this.coordinateSensor.getDescription();
        }

        @Override
        public int getPollFrequency(TileEntity te) {
            TileEntityUniversalSensor us = (TileEntityUniversalSensor)te;
            Set<ChunkPosition> positions = us.getGPSPositions();
            int mult = positions == null ? 1 : positions.size();
            return this.coordinateSensor.getPollFrequency() * mult;
        }

        @Override
        public int getRedstoneValue(World world, int x, int y, int z, int sensorRange, String textBoxText) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityUniversalSensor) {
                TileEntityUniversalSensor teUs = (TileEntityUniversalSensor)te;
                Set<ChunkPosition> positions = teUs.getGPSPositions();
                return positions == null ? 0 : this.coordinateSensor.getRedstoneValue(world, x, y, z, sensorRange, textBoxText, positions);
            }
            return 0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void drawAdditionalInfo(FontRenderer fontRenderer) {
            this.coordinateSensor.drawAdditionalInfo(fontRenderer);
        }

        @Override
        public Rectangle needsSlot() {
            return this.coordinateSensor.needsSlot();
        }
    }

    private class BlockAndCoordinateEventSensor
    implements IEventSensorSetting {
        private final IBlockAndCoordinateEventSensor coordinateSensor;

        public BlockAndCoordinateEventSensor(IBlockAndCoordinateEventSensor sensor) {
            this.coordinateSensor = sensor;
        }

        @Override
        public String getSensorPath() {
            return this.coordinateSensor.getSensorPath();
        }

        @Override
        public boolean needsTextBox() {
            return this.coordinateSensor.needsTextBox();
        }

        @Override
        public List<String> getDescription() {
            return this.coordinateSensor.getDescription();
        }

        @Override
        public int emitRedstoneOnEvent(Event event, TileEntity tile, int sensorRange, String textboxText) {
            TileEntityUniversalSensor teUs = (TileEntityUniversalSensor)tile;
            Set<ChunkPosition> positions = teUs.getGPSPositions();
            return positions == null ? 0 : this.coordinateSensor.emitRedstoneOnEvent(event, teUs, sensorRange, positions);
        }

        @Override
        public int getRedstonePulseLength() {
            return this.coordinateSensor.getRedstonePulseLength();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void drawAdditionalInfo(FontRenderer fontRenderer) {
            this.coordinateSensor.drawAdditionalInfo(fontRenderer);
        }

        @Override
        public Rectangle needsSlot() {
            return this.coordinateSensor.needsSlot();
        }
    }
}

