/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.semiblock;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.recipes.PneumaticRecipeRegistry;
import pneumaticCraft.common.semiblock.SemiBlockBasic;
import pneumaticCraft.common.tileentity.TileEntityCompressedIronBlock;
import pneumaticCraft.common.util.IOHelper;

public class SemiBlockHeatFrame
extends SemiBlockBasic
implements IHeatExchanger {
    private final IHeatExchangerLogic logic = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    private int lastValidSlot;
    private int cookingProgress;
    private int coolingProgress;
    @DescSynced
    private int heatLevel = 10;

    @Override
    public boolean canPlace() {
        return this.getTileEntity() instanceof IInventory;
    }

    public int getHeatLevel() {
        return this.heatLevel;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.heatLevel = TileEntityCompressedIronBlock.getHeatLevelForTemperature(this.logic.getTemperature());
            if (this.logic.getTemperature() > 374.0) {
                IInventory inv;
                if (this.cookingProgress < 100) {
                    int progress = Math.max(0, ((int)this.logic.getTemperature() - 343) / 30);
                    progress = Math.min(5, progress);
                    this.logic.addHeat(-progress * 1);
                    this.cookingProgress += progress;
                }
                if (this.cookingProgress >= 100 && (inv = IOHelper.getInventoryForTE(this.getTileEntity())) != null) {
                    if (!this.tryCookSlot(inv, this.lastValidSlot)) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            if (!this.tryCookSlot(inv, i)) continue;
                            this.cookingProgress -= 100;
                            break;
                        }
                    } else {
                        this.cookingProgress -= 100;
                    }
                }
            } else if (this.logic.getTemperature() < 273.0) {
                IInventory inv;
                if (this.coolingProgress < 100) {
                    int progress = Math.max(0, ((int)this.logic.getTemperature() - 243) / 30);
                    progress = 6 - Math.min(5, progress);
                    this.logic.addHeat(progress * 1);
                    this.coolingProgress += progress;
                }
                if (this.coolingProgress >= 100 && (inv = IOHelper.getInventoryForTE(this.getTileEntity())) != null) {
                    if (!this.tryCoolSlot(inv, this.lastValidSlot)) {
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            if (!this.tryCoolSlot(inv, i)) continue;
                            this.coolingProgress -= 100;
                            break;
                        }
                    } else {
                        this.coolingProgress -= 100;
                    }
                }
            }
        }
    }

    private boolean tryCookSlot(IInventory inv, int slot) {
        ItemStack remainder;
        ItemStack result;
        ItemStack stack = inv.func_70301_a(slot);
        if (stack != null && (result = FurnaceRecipes.func_77602_a().func_151395_a(stack)) != null && (remainder = IOHelper.insert(this.getTileEntity(), result, true)) == null) {
            IOHelper.insert(this.getTileEntity(), result, false);
            inv.func_70298_a(slot, 1);
            this.lastValidSlot = slot;
            return true;
        }
        return false;
    }

    private boolean tryCoolSlot(IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        if (stack != null) {
            for (Pair<Object, ItemStack> recipe : PneumaticRecipeRegistry.getInstance().heatFrameCoolingRecipes) {
                int amount;
                if (!PneumaticRecipeRegistry.isItemEqual(recipe.getKey(), stack) || stack.field_77994_a < (amount = PneumaticRecipeRegistry.getItemAmount(recipe.getKey()))) continue;
                ItemStack containerItem = stack.func_77973_b().getContainerItem(stack);
                boolean canStoreContainerItem = false;
                boolean canStoreOutput = false;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack s = inv.func_70301_a(i);
                    if (s == null) {
                        if (canStoreOutput) {
                            canStoreContainerItem = true;
                            continue;
                        }
                        canStoreOutput = true;
                        continue;
                    }
                    if (s.func_77969_a((ItemStack)recipe.getRight()) && ItemStack.func_77970_a((ItemStack)s, (ItemStack)((ItemStack)recipe.getRight())) && s.func_77976_d() >= s.field_77994_a + ((ItemStack)recipe.getRight()).field_77994_a) {
                        canStoreOutput = true;
                    }
                    if (containerItem == null || !s.func_77969_a(containerItem) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)containerItem) || s.func_77976_d() < s.field_77994_a + containerItem.field_77994_a) continue;
                    canStoreContainerItem = true;
                }
                if (!canStoreOutput || containerItem != null && !canStoreContainerItem) continue;
                inv.func_70298_a(slot, amount);
                IOHelper.insert(this.getTileEntity(), ((ItemStack)recipe.getValue()).func_77946_l(), false);
                if (containerItem != null) {
                    IOHelper.insert(this.getTileEntity(), containerItem.func_77946_l(), false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.logic.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.logic.readFromNBT(tag);
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack) {
        super.onPlaced(player, stack);
        this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), this.getBlock());
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.logic;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.getWorld().func_147459_d(this.getX(), this.getY(), this.getZ(), this.getBlock());
    }

    @Override
    public void addWailaInfoToTag(NBTTagCompound tag) {
        super.addWailaInfoToTag(tag);
        tag.func_74768_a("temp", (int)this.logic.getTemperature());
    }

    @Override
    public void addWailaTooltip(List<String> curInfo, NBTTagCompound tag) {
        super.addWailaTooltip(curInfo, tag);
        curInfo.add(StatCollector.func_74837_a((String)"waila.temperature", (Object[])new Object[]{tag.func_74762_e("temp") - 273}));
    }
}

