/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.common.ai.DroneAIBlockCondition;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICondition;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetArea;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetCondition;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.lib.Textures;

public class ProgWidgetPressureCondition
extends ProgWidgetCondition {
    @Override
    public String getWidgetString() {
        return "conditionPressure";
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class, ProgWidgetString.class};
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(ChunkPosition pos) {
                TileEntity te = this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
                if (te instanceof IPneumaticMachine) {
                    IAirHandler airHandler = ((IPneumaticMachine)te).getAirHandler();
                    float pressure = Float.MIN_VALUE;
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        if (!ProgWidgetPressureCondition.this.getSides()[d.ordinal()]) continue;
                        pressure = Math.max(airHandler.getPressure(d), pressure);
                    }
                    return ((ICondition)((Object)this.widget)).getOperator() == ICondition.Operator.EQUALS ? pressure == (float)((ICondition)((Object)this.widget)).getRequiredCount() : pressure >= (float)((ICondition)((Object)this.widget)).getRequiredCount();
                }
                return false;
            }
        };
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_PRESSURE;
    }
}

