/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.math.NumberUtils;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetEmitRedstone;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IRedstoneEmissionWidget;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetString;
import pneumaticCraft.lib.Textures;

public class ProgWidgetEmitRedstone
extends ProgWidget
implements IRedstoneEmissionWidget,
ISidedWidget {
    private boolean[] accessingSides = new boolean[]{true, true, true, true, true, true};

    @Override
    public int getEmittingRedstone() {
        if (this.getConnectedParameters()[0] != null) {
            return NumberUtils.toInt((String)((ProgWidgetString)this.getConnectedParameters()[0]).string);
        }
        return 0;
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add("gui.progWidget.general.error.noSideActive");
        }
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Affecting sides:");
        curTooltip.add(this.getExtraStringInfo());
    }

    @Override
    public String getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return "All sides";
        }
        if (noSides) {
            return "No Sides";
        }
        String tip = "";
        block9: for (int i = 0; i < 6; ++i) {
            if (!this.accessingSides[i]) continue;
            switch (ForgeDirection.getOrientation((int)i)) {
                case UP: {
                    tip = tip + "top, ";
                    continue block9;
                }
                case DOWN: {
                    tip = tip + "bottom, ";
                    continue block9;
                }
                case NORTH: {
                    tip = tip + "north, ";
                    continue block9;
                }
                case SOUTH: {
                    tip = tip + "south, ";
                    continue block9;
                }
                case EAST: {
                    tip = tip + "east, ";
                    continue block9;
                }
                case WEST: {
                    tip = tip + "west, ";
                }
            }
        }
        return tip.substring(0, tip.length() - 2);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a(ForgeDirection.getOrientation((int)i).name(), this.accessingSides[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.func_74767_n(ForgeDirection.getOrientation((int)i).name());
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetString.class};
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public String getWidgetString() {
        return "emitRedstone";
    }

    @Override
    public int getCraftingColorIndex() {
        return 1;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_EMIT_REDSTONE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetEmitRedstone(this, guiProgrammer);
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIEmitRedstone(drone, widget);
    }

    private static class DroneAIEmitRedstone
    extends EntityAIBase {
        private final IProgWidget widget;
        private final IDroneBase drone;

        public DroneAIEmitRedstone(IDroneBase drone, IProgWidget widget) {
            this.widget = widget;
            this.drone = drone;
        }

        public boolean func_75250_a() {
            boolean[] sides = ((ISidedWidget)((Object)this.widget)).getSides();
            for (int i = 0; i < 6; ++i) {
                if (!sides[i]) continue;
                this.drone.setEmittingRedstone(ForgeDirection.getOrientation((int)i), ((IRedstoneEmissionWidget)((Object)this.widget)).getEmittingRedstone());
            }
            return false;
        }
    }
}

