/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetDropItem;
import pneumaticCraft.common.ai.DroneAIImExBase;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IItemDropper;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetInventoryBase;
import pneumaticCraft.lib.Textures;

public class ProgWidgetDropItem
extends ProgWidgetInventoryBase
implements IItemDropper {
    private boolean dropStraight;

    @Override
    public String getWidgetString() {
        return "dropItem";
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_DROP_ITEM;
    }

    @Override
    public boolean dropStraight() {
        return this.dropStraight;
    }

    @Override
    public void setDropStraight(boolean dropStraight) {
        this.dropStraight = dropStraight;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("dropStraight", this.dropStraight);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.dropStraight = tag.func_74767_n("dropStraight");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetDropItem(this, guiProgrammer);
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIImExBase(drone, (ProgWidgetAreaItemBase)widget){
            private final Set<ChunkPosition> visitedPositions;
            {
                this.visitedPositions = new HashSet<ChunkPosition>();
            }

            @Override
            public boolean func_75250_a() {
                boolean shouldExecute = false;
                for (int i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
                    ItemStack stack = this.drone.getInventory().func_70301_a(i);
                    if (stack == null || !this.widget.isItemValidForFilters(stack)) continue;
                    shouldExecute = super.func_75250_a();
                    break;
                }
                return shouldExecute;
            }

            @Override
            protected boolean moveIntoBlock() {
                return true;
            }

            @Override
            protected boolean isValidPosition(ChunkPosition pos) {
                return !this.visitedPositions.contains(pos);
            }

            @Override
            protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
                this.visitedPositions.add(pos);
                for (int i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
                    ItemStack stack = this.drone.getInventory().func_70301_a(i);
                    if (stack == null || !this.widget.isItemValidForFilters(stack)) continue;
                    if (this.useCount() && this.getRemainingCount() < stack.field_77994_a) {
                        stack = stack.func_77979_a(this.getRemainingCount());
                        this.decreaseCount(this.getRemainingCount());
                    } else {
                        this.decreaseCount(stack.field_77994_a);
                        this.drone.getInventory().func_70299_a(i, null);
                    }
                    EntityItem item = new EntityItem(this.drone.getWorld(), (double)pos.field_151329_a + 0.5, (double)pos.field_151327_b + 0.5, (double)pos.field_151328_c + 0.5, stack);
                    if (((IItemDropper)((Object)this.widget)).dropStraight()) {
                        item.field_70159_w = 0.0;
                        item.field_70181_x = 0.0;
                        item.field_70179_y = 0.0;
                    }
                    this.drone.getWorld().func_72838_d((Entity)item);
                    if (this.useCount() && this.getRemainingCount() == 0) break;
                }
                return false;
            }
        };
    }

    @Override
    public int getCraftingColorIndex() {
        return 9;
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public String getExtraStringInfo() {
        return this.dropStraight() ? "Straight" : "Random";
    }
}

