/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.client.gui.programmer.GuiProgWidgetArea;
import pneumaticCraft.common.ai.DroneAIManager;
import pneumaticCraft.common.progwidgets.IAreaProvider;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IVariableWidget;
import pneumaticCraft.common.progwidgets.ProgWidget;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Textures;

public class ProgWidgetArea
extends ProgWidget
implements IAreaProvider,
IVariableWidget {
    public int x1;
    public int y1;
    public int z1;
    public int x2;
    public int y2;
    public int z2;
    private String coord1Variable = "";
    private String coord2Variable = "";
    private DroneAIManager aiManager;
    public EnumAreaType type = EnumAreaType.FILL;
    public int typeInfo;

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        String c1 = this.coord1Variable.equals("") ? (this.x1 != 0 || this.y1 != 0 || this.z1 != 0 ? "X%s: " + this.x1 + ", Y%s: " + this.y1 + ", Z%s: " + this.z1 : null) : "XYZ%s: \"" + this.coord1Variable + "\"";
        String c2 = this.coord2Variable.equals("") ? (this.x2 != 0 || this.y2 != 0 || this.z2 != 0 ? "X%s: " + this.x2 + ", Y%s: " + this.y2 + ", Z%s: " + this.z2 : null) : "XYZ%s: \"" + this.coord2Variable + "\"";
        if (c1 == null) {
            c1 = c2;
            c2 = null;
        }
        if (c1 != null) {
            if (c2 != null) {
                curTooltip.add("Contains the points:");
                curTooltip.add(c1.replace("%s", "1"));
                curTooltip.add(c2.replace("%s", "2"));
            } else {
                curTooltip.add("Contains the point:");
                curTooltip.add(c1.replace("%s", "1"));
            }
        }
        curTooltip.add("Area type: " + (Object)((Object)this.type));
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.coord1Variable.equals("") && this.coord2Variable.equals("") && this.x1 == 0 && this.y1 == 0 && this.z1 == 0 && this.x2 == 0 && this.y2 == 0 && this.z2 == 0) {
            curInfo.add("gui.progWidget.area.error.noArea");
        }
    }

    private ChunkPosition[] getAreaPoints() {
        ChunkPosition c2;
        ChunkPosition c1;
        if (this.coord1Variable.equals("")) {
            c1 = this.x1 != 0 || this.y1 != 0 || this.z1 != 0 ? new ChunkPosition(this.x1, this.y1, this.z1) : null;
        } else {
            ChunkPosition chunkPosition = c1 = this.aiManager != null ? this.aiManager.getCoordinate(this.coord1Variable) : null;
        }
        if (this.coord2Variable.equals("")) {
            c2 = this.x2 != 0 || this.y2 != 0 || this.z2 != 0 ? new ChunkPosition(this.x2, this.y2, this.z2) : null;
        } else {
            ChunkPosition chunkPosition = c2 = this.aiManager != null ? this.aiManager.getCoordinate(this.coord2Variable) : null;
        }
        if (c1 == null && c2 == null) {
            return new ChunkPosition[]{null, null};
        }
        if (c1 == null) {
            return new ChunkPosition[]{c2, null};
        }
        if (c2 == null) {
            return new ChunkPosition[]{c1, null};
        }
        return new ChunkPosition[]{c1, c2};
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return ProgWidgetArea.class;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetArea.class};
    }

    @Override
    public String getWidgetString() {
        return "area";
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_AREA;
    }

    @Override
    public void getArea(Set<ChunkPosition> area) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        ChunkPosition[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null && areaPoints[1] == null) {
            return;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].field_151329_a, areaPoints[1].field_151329_a);
            minY = Math.min(areaPoints[0].field_151327_b, areaPoints[1].field_151327_b);
            minZ = Math.min(areaPoints[0].field_151328_c, areaPoints[1].field_151328_c);
            maxX = Math.max(areaPoints[0].field_151329_a, areaPoints[1].field_151329_a);
            maxY = Math.max(areaPoints[0].field_151327_b, areaPoints[1].field_151327_b);
            maxZ = Math.max(areaPoints[0].field_151328_c, areaPoints[1].field_151328_c);
        } else {
            minX = maxX = areaPoints[0].field_151329_a;
            minY = maxY = areaPoints[0].field_151327_b;
            minZ = maxZ = areaPoints[0].field_151328_c;
        }
        int size = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
        if (size > 100000) {
            if (this.aiManager != null) {
                this.aiManager.getDrone().overload();
            }
            return;
        }
        switch (this.type) {
            case FILL: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = Math.min(255, maxY); y >= minY && y >= 0; --y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case FRAME: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            int axisRight = 0;
                            if (x == minX || x == maxX) {
                                ++axisRight;
                            }
                            if (y == minY || y == maxY) {
                                ++axisRight;
                            }
                            if (z == minZ || z == maxZ) {
                                ++axisRight;
                            }
                            if (axisRight <= 1) continue;
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case WALL: {
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case SPHERE: {
                double radius = areaPoints[1] != null ? PneumaticCraftUtils.distBetween(areaPoints[0], areaPoints[1]) : 0.0;
                minX = (int)((double)areaPoints[0].field_151329_a - radius - 1.0);
                minY = (int)((double)areaPoints[0].field_151327_b - radius - 1.0);
                minZ = (int)((double)areaPoints[0].field_151328_c - radius - 1.0);
                maxX = (int)((double)areaPoints[0].field_151329_a + radius + 1.0);
                maxY = (int)((double)areaPoints[0].field_151327_b + radius + 1.0);
                maxZ = (int)((double)areaPoints[0].field_151328_c + radius + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (!(PneumaticCraftUtils.distBetween(areaPoints[0], (double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= radius)) continue;
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case LINE: {
                if (areaPoints[1] == null) break;
                Vec3 lineVec = Vec3.func_72443_a((double)(areaPoints[1].field_151329_a - areaPoints[0].field_151329_a), (double)(areaPoints[1].field_151327_b - areaPoints[0].field_151327_b), (double)(areaPoints[1].field_151328_c - areaPoints[0].field_151328_c)).func_72432_b();
                lineVec.field_72450_a /= 10.0;
                lineVec.field_72448_b /= 10.0;
                lineVec.field_72449_c /= 10.0;
                double curX = (double)areaPoints[0].field_151329_a + 0.5;
                double curY = (double)areaPoints[0].field_151327_b + 0.5;
                double curZ = (double)areaPoints[0].field_151328_c + 0.5;
                double maxDistance = PneumaticCraftUtils.distBetween(areaPoints[0], areaPoints[1]);
                for (double totalDistance = 0.0; totalDistance <= maxDistance; totalDistance += 0.1) {
                    ChunkPosition pos;
                    if (!(curY >= 0.0) || !(curY < 256.0) || area.contains(pos = new ChunkPosition((int)(curX += lineVec.field_72450_a), (int)(curY += lineVec.field_72448_b), (int)(curZ += lineVec.field_72449_c)))) continue;
                    area.add(pos);
                }
                break;
            }
            case X_WALL: {
                if (areaPoints[1] == null) break;
                Vec3 lineVec = Vec3.func_72443_a((double)0.0, (double)(areaPoints[1].field_151327_b - areaPoints[0].field_151327_b), (double)(areaPoints[1].field_151328_c - areaPoints[0].field_151328_c)).func_72432_b();
                lineVec.field_72448_b /= 10.0;
                lineVec.field_72449_c /= 10.0;
                double curY = (double)areaPoints[0].field_151327_b + 0.5;
                double curZ = (double)areaPoints[0].field_151328_c + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(areaPoints[0].field_151327_b - areaPoints[1].field_151327_b, 2.0) + Math.pow(areaPoints[0].field_151328_c - areaPoints[1].field_151328_c, 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curY += lineVec.field_72448_b;
                    curZ += lineVec.field_72449_c;
                    for (int i = minX; i <= maxX; ++i) {
                        ChunkPosition pos;
                        if (!(curY >= 0.0) || !(curY < 256.0) || area.contains(pos = new ChunkPosition(i, (int)curY, (int)curZ))) continue;
                        area.add(pos);
                    }
                }
                break;
            }
            case Y_WALL: {
                if (areaPoints[1] == null) break;
                Vec3 lineVec = Vec3.func_72443_a((double)(areaPoints[1].field_151329_a - areaPoints[0].field_151329_a), (double)0.0, (double)(areaPoints[1].field_151328_c - areaPoints[0].field_151328_c)).func_72432_b();
                lineVec.field_72450_a /= 10.0;
                lineVec.field_72449_c /= 10.0;
                double curX = (double)areaPoints[0].field_151329_a + 0.5;
                double curZ = (double)areaPoints[0].field_151328_c + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(areaPoints[0].field_151329_a - areaPoints[1].field_151329_a, 2.0) + Math.pow(areaPoints[0].field_151328_c - areaPoints[1].field_151328_c, 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.field_72450_a;
                    curZ += lineVec.field_72449_c;
                    for (int i = Math.max(0, minY); i <= Math.min(maxY, 255); ++i) {
                        ChunkPosition pos = new ChunkPosition((int)curX, i, (int)curZ);
                        if (area.contains(pos)) continue;
                        area.add(pos);
                    }
                }
                break;
            }
            case Z_WALL: {
                if (areaPoints[1] == null) break;
                Vec3 lineVec = Vec3.func_72443_a((double)(areaPoints[1].field_151329_a - areaPoints[0].field_151329_a), (double)(areaPoints[1].field_151327_b - areaPoints[0].field_151327_b), (double)0.0).func_72432_b();
                lineVec.field_72450_a /= 10.0;
                lineVec.field_72448_b /= 10.0;
                double curX = (double)areaPoints[0].field_151329_a + 0.5;
                double curY = (double)areaPoints[0].field_151327_b + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(areaPoints[0].field_151329_a - areaPoints[1].field_151329_a, 2.0) + Math.pow(areaPoints[0].field_151327_b - areaPoints[1].field_151327_b, 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.field_72450_a;
                    curY += lineVec.field_72448_b;
                    for (int i = minZ; i <= maxZ; ++i) {
                        ChunkPosition pos;
                        if (!(curY >= 0.0) || !(curY < 256.0) || area.contains(pos = new ChunkPosition((int)curX, (int)curY, i))) continue;
                        area.add(pos);
                    }
                }
                break;
            }
            case X_CYLINDER: {
                if (areaPoints[1] == null) break;
                double rad = areaPoints[1] != null ? PneumaticCraftUtils.distBetween(areaPoints[0].field_151327_b, (double)areaPoints[0].field_151328_c, (double)areaPoints[1].field_151327_b, (double)areaPoints[1].field_151328_c) : 0.0;
                minY = (int)((double)areaPoints[0].field_151327_b - rad - 1.0);
                minZ = (int)((double)areaPoints[0].field_151328_c - rad - 1.0);
                maxY = (int)((double)areaPoints[0].field_151327_b + rad + 1.0);
                maxZ = (int)((double)areaPoints[0].field_151328_c + rad + 1.0);
                for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!(PneumaticCraftUtils.distBetween(areaPoints[0].field_151327_b, (double)areaPoints[0].field_151328_c, (double)y, (double)z) <= rad)) continue;
                        for (int x = minX; x <= maxX; ++x) {
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case Y_CYLINDER: {
                if (areaPoints[1] == null) break;
                double rad = areaPoints[1] != null ? PneumaticCraftUtils.distBetween(areaPoints[0].field_151329_a, (double)areaPoints[0].field_151328_c, (double)areaPoints[1].field_151329_a, (double)areaPoints[1].field_151328_c) : 0.0;
                minX = (int)((double)areaPoints[0].field_151329_a - rad - 1.0);
                minZ = (int)((double)areaPoints[0].field_151328_c - rad - 1.0);
                maxX = (int)((double)areaPoints[0].field_151329_a + rad + 1.0);
                maxZ = (int)((double)areaPoints[0].field_151328_c + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!(PneumaticCraftUtils.distBetween(areaPoints[0].field_151329_a, (double)areaPoints[0].field_151328_c, (double)x, (double)z) <= rad)) continue;
                        for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case Z_CYLINDER: {
                if (areaPoints[1] == null) break;
                double rad = areaPoints[1] != null ? PneumaticCraftUtils.distBetween(areaPoints[0].field_151329_a, (double)areaPoints[0].field_151327_b, (double)areaPoints[1].field_151329_a, (double)areaPoints[1].field_151327_b) : 0.0;
                minX = (int)((double)areaPoints[0].field_151329_a - rad - 1.0);
                minY = (int)((double)areaPoints[0].field_151327_b - rad - 1.0);
                maxX = (int)((double)areaPoints[0].field_151329_a + rad + 1.0);
                maxY = (int)((double)areaPoints[0].field_151327_b + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = Math.max(0, minY); y <= maxY && y < 256; ++y) {
                        if (!(PneumaticCraftUtils.distBetween(areaPoints[0].field_151329_a, (double)areaPoints[0].field_151327_b, (double)x, (double)y) <= rad)) continue;
                        for (int z = minZ; z <= maxZ; ++z) {
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case X_PYRAMID: {
                if (areaPoints[1] == null || areaPoints[1].field_151329_a == areaPoints[0].field_151329_a) break;
                Vec3 lineVec = Vec3.func_72443_a((double)(areaPoints[1].field_151329_a - areaPoints[0].field_151329_a), (double)(areaPoints[1].field_151327_b - areaPoints[0].field_151327_b), (double)(areaPoints[1].field_151328_c - areaPoints[0].field_151328_c)).func_72432_b();
                lineVec.field_72448_b /= lineVec.field_72450_a;
                lineVec.field_72449_c /= lineVec.field_72450_a;
                double curY = (double)areaPoints[0].field_151327_b - lineVec.field_72448_b;
                int x = areaPoints[0].field_151329_a + (areaPoints[1].field_151329_a > areaPoints[0].field_151329_a ? -1 : 1);
                double curZ = (double)areaPoints[0].field_151328_c - lineVec.field_72449_c;
                while (x != areaPoints[1].field_151329_a) {
                    x += areaPoints[1].field_151329_a > areaPoints[0].field_151329_a ? 1 : -1;
                    int dY = Math.abs((int)((curY += lineVec.field_72448_b) - (double)areaPoints[0].field_151327_b));
                    int dZ = Math.abs((int)((curZ += lineVec.field_72449_c) - (double)areaPoints[0].field_151328_c));
                    for (int y = areaPoints[0].field_151327_b - dY; y <= areaPoints[0].field_151327_b + dY; ++y) {
                        for (int z = areaPoints[0].field_151328_c - dZ; z <= areaPoints[0].field_151328_c + dZ; ++z) {
                            if (y <= 0 || y >= 256) continue;
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case Y_PYRAMID: {
                if (areaPoints[1] == null || areaPoints[1].field_151327_b == areaPoints[0].field_151327_b) break;
                Vec3 lineVec = Vec3.func_72443_a((double)(areaPoints[1].field_151329_a - areaPoints[0].field_151329_a), (double)(areaPoints[1].field_151327_b - areaPoints[0].field_151327_b), (double)(areaPoints[1].field_151328_c - areaPoints[0].field_151328_c)).func_72432_b();
                lineVec.field_72450_a /= lineVec.field_72448_b;
                lineVec.field_72449_c /= lineVec.field_72448_b;
                double curX = (double)areaPoints[0].field_151329_a - lineVec.field_72450_a;
                int y = areaPoints[0].field_151327_b + (areaPoints[1].field_151327_b > areaPoints[0].field_151327_b ? -1 : 1);
                double curZ = (double)areaPoints[0].field_151328_c - lineVec.field_72449_c;
                while (y != areaPoints[1].field_151327_b) {
                    y += areaPoints[1].field_151327_b > areaPoints[0].field_151327_b ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.field_72450_a) - (double)areaPoints[0].field_151329_a));
                    int dZ = Math.abs((int)((curZ += lineVec.field_72449_c) - (double)areaPoints[0].field_151328_c));
                    for (int x = areaPoints[0].field_151329_a - dX; x <= areaPoints[0].field_151329_a + dX; ++x) {
                        for (int z = areaPoints[0].field_151328_c - dZ; z <= areaPoints[0].field_151328_c + dZ; ++z) {
                            if (y <= 0 || y >= 256) continue;
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case Z_PYRAMID: {
                if (areaPoints[1] == null || areaPoints[1].field_151328_c == areaPoints[0].field_151328_c) break;
                Vec3 lineVec = Vec3.func_72443_a((double)(areaPoints[1].field_151329_a - areaPoints[0].field_151329_a), (double)(areaPoints[1].field_151327_b - areaPoints[0].field_151327_b), (double)(areaPoints[1].field_151328_c - areaPoints[0].field_151328_c)).func_72432_b();
                lineVec.field_72450_a /= lineVec.field_72449_c;
                lineVec.field_72448_b /= lineVec.field_72449_c;
                double curX = (double)areaPoints[0].field_151329_a - lineVec.field_72450_a;
                int z = areaPoints[0].field_151328_c + (areaPoints[1].field_151328_c > areaPoints[0].field_151328_c ? -1 : 1);
                double curY = (double)areaPoints[0].field_151327_b - lineVec.field_72448_b;
                while (z != areaPoints[1].field_151328_c) {
                    z += areaPoints[1].field_151328_c > areaPoints[0].field_151328_c ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.field_72450_a) - (double)areaPoints[0].field_151329_a));
                    int dY = Math.abs((int)((curY += lineVec.field_72448_b) - (double)areaPoints[0].field_151327_b));
                    for (int x = areaPoints[0].field_151329_a - dX; x <= areaPoints[0].field_151329_a + dX; ++x) {
                        for (int y = areaPoints[0].field_151327_b - dY; y <= areaPoints[0].field_151327_b + dY; ++y) {
                            if (y <= 0 || y >= 256) continue;
                            area.add(new ChunkPosition(x, y, z));
                        }
                    }
                }
                break;
            }
            case GRID: {
                if (areaPoints[1] == null || areaPoints[0].equals((Object)areaPoints[1]) || this.typeInfo <= 0) {
                    area.add(areaPoints[0]);
                    break;
                }
                int interval = this.typeInfo;
                int x = areaPoints[0].field_151329_a;
                while (areaPoints[0].field_151329_a < areaPoints[1].field_151329_a ? x <= areaPoints[1].field_151329_a : x >= areaPoints[1].field_151329_a) {
                    int y = areaPoints[0].field_151327_b;
                    while (areaPoints[0].field_151327_b < areaPoints[1].field_151327_b ? y <= areaPoints[1].field_151327_b : y >= areaPoints[1].field_151327_b) {
                        int z = areaPoints[0].field_151328_c;
                        while (areaPoints[0].field_151328_c < areaPoints[1].field_151328_c ? z <= areaPoints[1].field_151328_c : z >= areaPoints[1].field_151328_c) {
                            if (y > 0 && y < 256) {
                                area.add(new ChunkPosition(x, y, z));
                            }
                            z += (areaPoints[0].field_151328_c < areaPoints[1].field_151328_c ? 1 : -1) * interval;
                        }
                        y += (areaPoints[0].field_151327_b < areaPoints[1].field_151327_b ? 1 : -1) * interval;
                    }
                    x += (areaPoints[0].field_151329_a < areaPoints[1].field_151329_a ? 1 : -1) * interval;
                }
                break;
            }
            case RANDOM: {
                this.type = EnumAreaType.FILL;
                HashSet<ChunkPosition> filledArea = new HashSet<ChunkPosition>();
                this.getArea(filledArea);
                this.type = EnumAreaType.RANDOM;
                if (this.typeInfo >= filledArea.size()) {
                    area.addAll(filledArea);
                    return;
                }
                Random rand = new Random();
                HashSet<Integer> randomIndexes = new HashSet<Integer>();
                while (randomIndexes.size() < this.typeInfo) {
                    randomIndexes.add(rand.nextInt(filledArea.size()));
                }
                int curIndex = 0;
                for (ChunkPosition pos : filledArea) {
                    if (randomIndexes.contains(curIndex)) {
                        area.add(pos);
                    }
                    ++curIndex;
                }
                break;
            }
        }
    }

    private AxisAlignedBB getAABB() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        ChunkPosition[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return null;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].field_151329_a, areaPoints[1].field_151329_a);
            minY = Math.min(areaPoints[0].field_151327_b, areaPoints[1].field_151327_b);
            minZ = Math.min(areaPoints[0].field_151328_c, areaPoints[1].field_151328_c);
            maxX = Math.max(areaPoints[0].field_151329_a, areaPoints[1].field_151329_a);
            maxY = Math.max(areaPoints[0].field_151327_b, areaPoints[1].field_151327_b);
            maxZ = Math.max(areaPoints[0].field_151328_c, areaPoints[1].field_151328_c);
        } else {
            minX = maxX = areaPoints[0].field_151329_a;
            minY = maxY = areaPoints[0].field_151327_b;
            minZ = maxZ = areaPoints[0].field_151328_c;
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    public List<Entity> getEntitiesWithinArea(World world, IEntitySelector filter) {
        AxisAlignedBB aabb = this.getAABB();
        return aabb != null ? world.func_94576_a(null, aabb, filter) : new ArrayList<Entity>();
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("x1", this.x1);
        tag.func_74768_a("y1", this.y1);
        tag.func_74768_a("z1", this.z1);
        tag.func_74768_a("x2", this.x2);
        tag.func_74768_a("y2", this.y2);
        tag.func_74768_a("z2", this.z2);
        if (this.type != null) {
            tag.func_74768_a("type", this.type.ordinal());
        }
        tag.func_74768_a("typeInfo", this.typeInfo);
        tag.func_74778_a("coord1Variable", this.coord1Variable);
        tag.func_74778_a("coord2Variable", this.coord2Variable);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.x1 = tag.func_74762_e("x1");
        this.y1 = tag.func_74762_e("y1");
        this.z1 = tag.func_74762_e("z1");
        this.x2 = tag.func_74762_e("x2");
        this.y2 = tag.func_74762_e("y2");
        this.z2 = tag.func_74762_e("z2");
        this.type = EnumAreaType.values()[tag.func_74762_e("type")];
        this.typeInfo = tag.func_74762_e("typeInfo");
        this.coord1Variable = tag.func_74779_i("coord1Variable");
        this.coord2Variable = tag.func_74779_i("coord2Variable");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetArea(this, guiProgrammer);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public int getCraftingColorIndex() {
        return 2;
    }

    public String getCoord1Variable() {
        return this.coord1Variable;
    }

    public void setCoord1Variable(String coord1Variable) {
        this.coord1Variable = coord1Variable;
    }

    public String getCoord2Variable() {
        return this.coord2Variable;
    }

    public void setCoord2Variable(String coord2Variable) {
        this.coord2Variable = coord2Variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.coord1Variable);
        variables.add(this.coord2Variable);
    }

    public static enum EnumAreaType {
        FILL("Filled"),
        FRAME("Frame"),
        WALL("Walls"),
        SPHERE("Sphere"),
        LINE("Line"),
        X_WALL("X-Wall"),
        Y_WALL("Y-Wall"),
        Z_WALL("Z-Wall"),
        X_CYLINDER("X-Cylinder"),
        Y_CYLINDER("Y-Cylinder"),
        Z_CYLINDER("Z-Cylinder"),
        X_PYRAMID("X-Pyramid"),
        Y_PYRAMID("Y-Pyramid"),
        Z_PYRAMID("Z-Pyramid"),
        GRID("Grid", true),
        RANDOM("Random", true);

        private final String name;
        public final boolean utilizesTypeInfo;

        private EnumAreaType(String name) {
            this(name, false);
        }

        private EnumAreaType(String name, boolean utilizesTypeInfo) {
            this.name = name;
            this.utilizesTypeInfo = utilizesTypeInfo;
        }

        public String toString() {
            return this.name;
        }
    }
}

