/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.api.item.IProgrammable;
import pneumaticCraft.common.NBTUtil;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.item.IChargingStationGUIHolderItem;
import pneumaticCraft.common.item.ItemPneumatic;
import pneumaticCraft.common.item.ItemPneumaticArmor;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.tileentity.TileEntityProgrammer;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.lib.Log;
import pneumaticCraft.proxy.CommonProxy;

public class ItemDrone
extends ItemPneumatic
implements IPressurizable,
IChargingStationGUIHolderItem,
IProgrammable {
    public ItemDrone() {
        this.func_77625_d(1);
    }

    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    public boolean func_77648_a(ItemStack iStack, EntityPlayer player, World world, int x, int y, int z, int side, float vecX, float vecY, float vecZ) {
        if (!world.field_72995_K) {
            EntityDrone drone = new EntityDrone(world, player);
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            drone.func_70107_b((double)x + 0.5 + (double)dir.offsetX, (double)y + 0.5 + (double)dir.offsetY, (double)z + 0.5 + (double)dir.offsetZ);
            world.func_72838_d((Entity)drone);
            NBTTagCompound stackTag = iStack.func_77978_p();
            NBTTagCompound entityTag = new NBTTagCompound();
            drone.func_70014_b(entityTag);
            if (stackTag != null) {
                entityTag.func_74782_a("widgets", stackTag.func_150295_c("widgets", 10).func_74737_b());
                entityTag.func_74776_a("currentAir", stackTag.func_74760_g("currentAir"));
                entityTag.func_74768_a("color", stackTag.func_74762_e("color"));
                NBTTagCompound invTag = stackTag.func_74775_l("UpgradeInventory");
                if (invTag != null) {
                    entityTag.func_74782_a("Inventory", invTag.func_74737_b());
                }
            }
            drone.func_70037_a(entityTag);
            if (iStack.func_82837_s()) {
                drone.func_94058_c(iStack.func_82833_r());
            }
            drone.naturallySpawned = false;
            drone.func_110161_a(null);
            --iStack.field_77994_a;
        }
        return true;
    }

    public static void setProgWidgets(List<IProgWidget> widgets, ItemStack iStack) {
        NBTUtil.initNBTTagCompound(iStack);
        TileEntityProgrammer.setWidgetsToNBT(widgets, iStack.func_77978_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs tab, List subItems) {
        subItems.add(new ItemStack((Item)this));
        ItemStack chargedStack = new ItemStack((Item)this);
        this.addAir(chargedStack, 120000);
        subItems.add(chargedStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add("Pressure: " + PneumaticCraftUtils.roundNumberTo(this.getPressure(stack), 1) + " bar");
        super.func_77624_a(stack, player, list, par4);
    }

    @Override
    public float getPressure(ItemStack iStack) {
        float oldVolume;
        float volume = ItemPneumaticArmor.getUpgrades(0, iStack) * 5000 + 12000;
        if (volume < (oldVolume = NBTUtil.getFloat(iStack, "volume"))) {
            float currentAir = NBTUtil.getFloat(iStack, "currentAir");
            NBTUtil.setFloat(iStack, "currentAir", currentAir *= volume / oldVolume);
        }
        NBTUtil.setFloat(iStack, "volume", volume);
        return NBTUtil.getFloat(iStack, "currentAir") / volume;
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        NBTUtil.setFloat(iStack, "currentAir", NBTUtil.getFloat(iStack, "currentAir") + (float)amount);
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 10.0f;
    }

    @Override
    public CommonProxy.EnumGuiId getGuiID() {
        return CommonProxy.EnumGuiId.DRONE;
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return true;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return true;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    public void func_77663_a(ItemStack iStack, World world, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!world.field_72995_K && NBTUtil.hasTag(iStack, "Inventory") && iStack.func_77978_p().func_74781_a("Inventory") instanceof NBTTagCompound) {
            Log.info("Converting 'Inventory' tag to 'UpgradeInventory' in Pneumatic items");
            iStack.func_77978_p().func_74782_a("UpgradeInventory", iStack.func_77978_p().func_74781_a("Inventory"));
            iStack.func_77978_p().func_82580_o("Inventory");
        }
    }
}

