/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.client.ClientTickHandler;
import pneumaticCraft.client.model.BaseModel;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.client.util.RenderUtils;
import pneumaticCraft.common.block.tubes.IInfluenceDispersing;
import pneumaticCraft.common.block.tubes.TubeModuleRedstoneReceiving;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketDescriptionPacketRequest;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class ModuleRegulatorTube
extends TubeModuleRedstoneReceiving
implements IInfluenceDispersing {
    private boolean renderItem;
    public static boolean hasTicked;
    public static boolean inLine;
    public static boolean inverted;
    private IBaseModel model;

    @Override
    public void renderDynamic(double x, double y, double z, float partialTicks, int renderPass, boolean itemRender) {
        this.renderItem = itemRender;
        super.renderDynamic(x, y, z, partialTicks, renderPass, itemRender);
    }

    @Override
    protected void renderModule() {
        super.renderModule();
        if (this.isFake()) {
            if (!hasTicked) {
                TileEntityPneumaticBase tile = (TileEntityPneumaticBase)this.getTube();
                NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
                TileEntity neighbor = tile.func_145831_w().func_147438_o(tile.field_145851_c + this.dir.offsetX, tile.field_145848_d + this.dir.offsetY, tile.field_145849_e + this.dir.offsetZ);
                inLine = neighbor instanceof IPneumaticMachine;
                if (inLine) {
                    inverted = ((IPneumaticMachine)neighbor).getAirHandler().getPressure(this.dir) > tile.getPressure(ForgeDirection.UNKNOWN);
                    NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(neighbor.field_145851_c, neighbor.field_145848_d, neighbor.field_145849_e));
                }
                hasTicked = true;
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (inLine && !inverted) {
                GL11.glColor4d((double)0.0, (double)1.0, (double)0.0, (double)0.3);
            } else {
                GL11.glColor4d((double)1.0, (double)0.0, (double)0.0, (double)0.3);
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.0, (double)(0.2 + (double)(ClientTickHandler.TICKS % 20) * 0.015));
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            RenderUtils.render3DArrow();
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glPopMatrix();
            GL11.glDisable((int)3042);
        }
    }

    @Override
    public String getType() {
        return "regulatorTubeModule";
    }

    @Override
    public IBaseModel getModel() {
        if (this.model == null) {
            this.model = new BaseModel("regulatorTubeModule.obj"){

                @Override
                public void renderStatic(float size, TileEntity te) {
                    GL11.glPushMatrix();
                    GL11.glRotated((double)90.0, (double)0.0, (double)-1.0, (double)0.0);
                    GL11.glTranslated((double)0.625, (double)1.5, (double)0.0);
                    if (ModuleRegulatorTube.this.renderItem) {
                        GL11.glTranslated((double)0.0625, (double)-0.0625, (double)0.1875);
                    }
                    float scale = 0.0625f;
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    GL11.glEnable((int)32826);
                    super.renderStatic(size, te);
                    GL11.glPopMatrix();
                }
            };
        }
        return this.model;
    }

    @Override
    public int getMaxDispersion() {
        IAirHandler connectedHandler = null;
        for (Pair<ForgeDirection, IAirHandler> entry : this.pressureTube.getAirHandler().getConnectedPneumatics()) {
            if (!((ForgeDirection)entry.getKey()).equals((Object)this.dir)) continue;
            connectedHandler = (IAirHandler)entry.getValue();
            break;
        }
        if (connectedHandler == null) {
            return 0;
        }
        int maxDispersion = (int)((this.getThreshold() - connectedHandler.getPressure(ForgeDirection.UNKNOWN)) * (float)connectedHandler.getVolume());
        if (maxDispersion < 0) {
            return 0;
        }
        return maxDispersion;
    }

    @Override
    public void onAirDispersion(int amount) {
    }

    @Override
    public void addInfo(List<String> curInfo) {
        super.addInfo(curInfo);
        curInfo.add("Threshold: " + EnumChatFormatting.WHITE + PneumaticCraftUtils.roundNumberTo(this.getThreshold(), 1) + " bar");
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public void addItemDescription(List<String> curInfo) {
        curInfo.add(EnumChatFormatting.BLUE + "Formula: Threshold(bar) = 7.5 - Redstone x 0.5");
        curInfo.add("This module will stop pressurized air from");
        curInfo.add("travelling through this tube when a certain");
        curInfo.add("pressure threshold's reached.");
    }
}

