/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.client.model.tubemodules.ModelFlowDetector;
import pneumaticCraft.common.block.tubes.IInfluenceDispersing;
import pneumaticCraft.common.block.tubes.TubeModuleRedstoneEmitting;
import pneumaticCraft.proxy.CommonProxy;

public class ModuleFlowDetector
extends TubeModuleRedstoneEmitting
implements IInfluenceDispersing {
    private final IBaseModel model = new ModelFlowDetector(this);
    public float rotation;
    public float oldRotation;
    private int flow;
    private int oldFlow;

    @Override
    public void update() {
        super.update();
        this.oldRotation = this.rotation;
        this.rotation += (float)this.getRedstoneLevel() / 100.0f;
        if (!this.pressureTube.world().field_72995_K) {
            if (this.setRedstone(this.flow / 5)) {
                this.sendDescriptionPacket();
            }
            this.oldFlow = this.flow;
            this.flow = 0;
        }
    }

    @Override
    public String getType() {
        return "flowDetectorModule";
    }

    @Override
    public IBaseModel getModel() {
        return this.model;
    }

    @Override
    public int getMaxDispersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onAirDispersion(int amount) {
        this.flow += amount;
    }

    @Override
    public void addInfo(List<String> curInfo) {
        curInfo.add("Flow: " + EnumChatFormatting.WHITE + this.oldFlow + " mL/tick");
        super.addInfo(curInfo);
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.rotation = tag.func_74760_g("rotation");
        this.oldFlow = tag.func_74762_e("flow");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74776_a("rotation", this.rotation);
        tag.func_74768_a("flow", this.oldFlow);
    }

    @Override
    public void addItemDescription(List<String> curInfo) {
        curInfo.add(EnumChatFormatting.BLUE + "Formula: Redstone = 0.2 x flow(mL/tick)");
        curInfo.add("This module emits a redstone signal of which");
        curInfo.add("the strength is dependant on how much air");
        curInfo.add("is travelling through the tube.");
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }

    @Override
    protected CommonProxy.EnumGuiId getGuiId() {
        return null;
    }
}

