/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.client.model.tubemodules.ModelAirGrate;
import pneumaticCraft.client.render.RenderRangeLines;
import pneumaticCraft.common.ai.StringFilterEntitySelector;
import pneumaticCraft.common.block.pneumaticPlants.BlockPneumaticPlantBase;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketSpawnParticle;
import pneumaticCraft.common.tileentity.TileEntityHeatSink;
import pneumaticCraft.proxy.CommonProxy;

public class ModuleAirGrate
extends TubeModule {
    private final IBaseModel model = new ModelAirGrate();
    private int grateRange;
    private boolean vacuum;
    public String entityFilter = "";
    private final Set<TileEntityHeatSink> heatSinks = new HashSet<TileEntityHeatSink>();
    private final RenderRangeLines rangeLineRenderer = new RenderRangeLines(0x55FF0000);
    private int plantCheckX = Integer.MIN_VALUE;
    private int plantCheckZ = Integer.MIN_VALUE;

    public ModuleAirGrate() {
        this.rangeLineRenderer.resetRendering(1.0);
    }

    private int getRange() {
        float range = this.pressureTube.getAirHandler().getPressure(ForgeDirection.UNKNOWN) * 4.0f;
        boolean bl = this.vacuum = range < 0.0f;
        if (this.vacuum) {
            range = -range * 4.0f;
        }
        return (int)range;
    }

    @Override
    public double getWidth() {
        return 1.0;
    }

    @Override
    public void update() {
        super.update();
        World worldObj = this.pressureTube.world();
        int xCoord = this.pressureTube.x();
        int yCoord = this.pressureTube.y();
        int zCoord = this.pressureTube.z();
        Vec3 tileVec = Vec3.func_72443_a((double)((double)xCoord + 0.5), (double)((double)yCoord + 0.5), (double)((double)zCoord + 0.5));
        if (!worldObj.field_72995_K) {
            int oldGrateRange = this.grateRange;
            this.grateRange = this.getRange();
            this.pressureTube.getAirHandler().addAir((this.vacuum ? 1 : -1) * this.grateRange * 10, ForgeDirection.UNKNOWN);
            if (oldGrateRange != this.grateRange) {
                this.sendDescriptionPacket();
            }
            this.checkForPlantsAndFarm(worldObj, xCoord, yCoord, zCoord, this.grateRange);
            this.coolHeatSinks(worldObj, xCoord, yCoord, zCoord, this.grateRange);
        } else {
            this.rangeLineRenderer.update();
        }
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)(xCoord - this.grateRange), (double)(yCoord - this.grateRange), (double)(zCoord - this.grateRange), (double)(xCoord + this.grateRange + 1), (double)(yCoord + this.grateRange + 1), (double)(zCoord + this.grateRange + 1));
        List entities = worldObj.func_82733_a(Entity.class, bbBox, (IEntitySelector)new StringFilterEntitySelector().setFilter(this.entityFilter));
        double d0 = (double)this.grateRange + 0.5;
        for (Entity entity : entities) {
            double d3;
            double d2;
            double d1;
            double d4;
            double d5;
            Vec3 entityVec;
            MovingObjectPosition trace;
            if (!entity.field_70170_p.field_72995_K && entity.func_70092_e((double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5) < 0.6 && entity instanceof EntityItem && !entity.field_70128_L) {
                IInventory inventory;
                ArrayList<IInventory> inventories = new ArrayList<IInventory>();
                ArrayList<Integer> sides = new ArrayList<Integer>();
                for (int i = 0; i < 6; ++i) {
                    inventory = TileEntityHopper.func_145893_b((World)worldObj, (double)(xCoord + Facing.field_71586_b[i]), (double)(yCoord + Facing.field_71587_c[i]), (double)(zCoord + Facing.field_71585_d[i]));
                    if (inventory == null) continue;
                    inventories.add(inventory);
                    sides.add(i);
                }
                if (inventories.size() == 0) continue;
                int inventoryIndexSelected = new Random().nextInt(inventories.size());
                inventory = (IInventory)inventories.get(inventoryIndexSelected);
                int side = (Integer)sides.get(inventoryIndexSelected);
                side = Facing.field_71588_a[side];
                ItemStack leftoverStack = TileEntityHopper.func_145889_a((IInventory)inventory, (ItemStack)((EntityItem)entity).func_92059_d(), (int)side);
                if (leftoverStack != null && leftoverStack.field_77994_a != 0) continue;
                entity.func_70106_y();
                continue;
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || (trace = worldObj.func_72933_a(entityVec = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v), tileVec)) == null || trace.field_72311_b != xCoord || trace.field_72312_c != yCoord || trace.field_72309_d != zCoord || !((d5 = 1.0 - (d4 = Math.sqrt((d1 = (entity.field_70165_t - (double)xCoord - 0.5) / d0) * d1 + (d2 = (entity.field_70163_u - (double)yCoord - 0.5) / d0) * d2 + (d3 = (entity.field_70161_v - (double)zCoord - 0.5) / d0) * d3))) > 0.0)) continue;
            d5 *= d5;
            if (!this.vacuum) {
                d5 *= -1.0;
            }
            entity.field_70159_w -= d1 / d4 * d5 * 0.1;
            entity.field_70181_x -= d2 / d4 * d5 * 0.1;
            entity.field_70179_y -= d3 / d4 * d5 * 0.1;
        }
    }

    private void checkForPlantsAndFarm(World worldObj, int x, int y, int z, int plantCheckRange) {
        if (this.grateRange > 0 && worldObj.func_82737_E() % 5L == 0L) {
            if (this.plantCheckX < x - plantCheckRange || this.plantCheckZ < z - plantCheckRange) {
                this.plantCheckX = x - plantCheckRange;
                this.plantCheckZ = z - plantCheckRange;
            }
            if (this.plantCheckX != x || this.plantCheckZ != z) {
                Block b = worldObj.func_147439_a(this.plantCheckX, y, this.plantCheckZ);
                NetworkHandler.sendToAllAround(new PacketSpawnParticle("reddust", (double)this.plantCheckX + 0.5, (double)y + 0.5, (double)this.plantCheckZ + 0.5, 0.0, 0.0, 0.0), worldObj);
                if (b instanceof BlockPneumaticPlantBase) {
                    ((BlockPneumaticPlantBase)b).attemptFarmByAirGrate(worldObj, this.plantCheckX, y, this.plantCheckZ);
                }
            }
            if (this.plantCheckZ++ >= z + plantCheckRange) {
                this.plantCheckZ = z - plantCheckRange;
                if (this.plantCheckX++ >= x + plantCheckRange) {
                    this.plantCheckX = x - plantCheckRange;
                }
            }
        }
    }

    private void coolHeatSinks(World world, int x, int y, int z, int range) {
        if (this.grateRange > 2) {
            int curTeIndex = (int)(world.func_82737_E() % 27L);
            TileEntity te = world.func_147438_o((x += this.dir.offsetX * 2) - 1 + curTeIndex % 3, (y += this.dir.offsetY * 2) - 1 + curTeIndex / 3 % 3, (z += this.dir.offsetZ * 2) - 1 + curTeIndex / 9 % 3);
            if (te instanceof TileEntityHeatSink) {
                this.heatSinks.add((TileEntityHeatSink)te);
            }
            Iterator<TileEntityHeatSink> iterator = this.heatSinks.iterator();
            while (iterator.hasNext()) {
                TileEntityHeatSink heatSink = iterator.next();
                if (heatSink.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                for (int i = 0; i < 4; ++i) {
                    heatSink.onFannedByAirGrate();
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.vacuum = tag.func_74767_n("vacuum");
        this.grateRange = tag.func_74762_e("grateRange");
        this.entityFilter = tag.func_74779_i("entityFilter");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("vacuum", this.vacuum);
        tag.func_74768_a("grateRange", this.grateRange);
        tag.func_74778_a("entityFilter", this.entityFilter);
    }

    @Override
    public String getType() {
        return "airGrateModule";
    }

    @Override
    public IBaseModel getModel() {
        return this.model;
    }

    @Override
    protected void renderModule() {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)2.0);
        this.rangeLineRenderer.render();
        if (this.isFake()) {
            GL11.glEnable((int)3042);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)0.5);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void addInfo(List<String> curInfo) {
        curInfo.add("Status: " + EnumChatFormatting.WHITE + (this.grateRange == 0 ? "Idle" : (this.vacuum ? "Attracting" : "Repelling")));
        curInfo.add("Range: " + EnumChatFormatting.WHITE + this.grateRange + " blocks");
        if (!this.entityFilter.equals("")) {
            curInfo.add("Entity Filter: " + EnumChatFormatting.WHITE + "\"" + this.entityFilter + "\"");
        }
    }

    @Override
    public void addItemDescription(List<String> curInfo) {
        curInfo.add(EnumChatFormatting.BLUE + "Formula: Range(blocks) = 4.0 x pressure(bar),");
        curInfo.add(EnumChatFormatting.BLUE + "or -16 x pressure(bar), if vacuum");
        curInfo.add("This module will attract or repel any entity");
        curInfo.add("within range dependant on whether it is in");
        curInfo.add("vacuum or under pressure respectively.");
    }

    @Override
    protected CommonProxy.EnumGuiId getGuiId() {
        return CommonProxy.EnumGuiId.AIR_GRATE_MODULE;
    }
}

