/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.ai.DroneAIBlockInteraction;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.progwidgets.ProgWidgetPlace;

public class DroneAIPlace
extends DroneAIBlockInteraction {
    public DroneAIPlace(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        if (this.drone.getWorld().func_147437_c(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) {
            boolean failedOnPlacement = false;
            for (int i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
                ItemStack droneStack = this.drone.getInventory().func_70301_a(i);
                if (droneStack == null || !(droneStack.func_77973_b() instanceof ItemBlock) || !this.widget.isItemValidForFilters(droneStack)) continue;
                if (((ItemBlock)droneStack.func_77973_b()).field_150939_a.func_149707_d(this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides()).ordinal())) {
                    EntityDrone entity;
                    if (this.drone instanceof EntityDrone) {
                        entity = (EntityDrone)this.drone;
                        entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 200.0, entity.field_70161_v);
                    }
                    if (this.drone.getWorld().func_147472_a(((ItemBlock)droneStack.func_77973_b()).field_150939_a, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, false, 0, null, droneStack)) {
                        if (this.drone instanceof EntityDrone) {
                            entity = (EntityDrone)this.drone;
                            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u - 200.0, entity.field_70161_v);
                        }
                        return true;
                    }
                    if (this.drone instanceof EntityDrone) {
                        entity = (EntityDrone)this.drone;
                        entity.func_70107_b(entity.field_70165_t, entity.field_70163_u - 200.0, entity.field_70161_v);
                    }
                    this.drone.addDebugEntry("gui.progWidget.place.debug.entityInWay", pos);
                    failedOnPlacement = true;
                    continue;
                }
                failedOnPlacement = true;
                this.drone.addDebugEntry("gui.progWidget.place.debug.cantPlaceBlock", pos);
            }
            if (!failedOnPlacement) {
                this.abort();
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        if (this.drone.getPathNavigator().hasNoPath()) {
            ForgeDirection side = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides());
            for (int i = 0; i < this.drone.getInventory().func_70302_i_(); ++i) {
                EntityDrone entity;
                ItemStack droneStack = this.drone.getInventory().func_70301_a(i);
                if (droneStack == null || !(droneStack.func_77973_b() instanceof ItemBlock) || !((ItemBlock)droneStack.func_77973_b()).field_150939_a.func_149707_d(this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides()).ordinal()) || !this.widget.isItemValidForFilters(droneStack)) continue;
                if (this.drone instanceof EntityDrone) {
                    entity = (EntityDrone)this.drone;
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 200.0, entity.field_70161_v);
                }
                if (this.drone.getWorld().func_147472_a(((ItemBlock)droneStack.func_77973_b()).field_150939_a, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, false, 0, null, droneStack)) {
                    Block block = Block.func_149634_a((Item)droneStack.func_77973_b());
                    int meta = droneStack.func_77973_b().func_77647_b(droneStack.func_77960_j());
                    int newMeta = block.func_149660_a(this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, side.ordinal(), (float)side.offsetX, (float)side.offsetY, (float)side.offsetZ, meta);
                    this.setFakePlayerAccordingToDir();
                    if (this.placeBlockAt(droneStack, (EntityPlayer)this.drone.getFakePlayer(), this.drone.getWorld(), pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, side.ordinal(), 0.0f, 0.0f, 0.0f, newMeta)) {
                        this.drone.addAir(null, -100);
                        this.drone.getWorld().func_72908_a((double)((float)pos.field_151329_a + 0.5f), (double)((float)pos.field_151327_b + 0.5f), (double)((float)pos.field_151328_c + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                        if (--droneStack.field_77994_a <= 0) {
                            this.drone.getInventory().func_70299_a(i, null);
                        }
                    }
                    if (this.drone instanceof EntityDrone) {
                        EntityDrone entity2 = (EntityDrone)this.drone;
                        entity2.func_70107_b(entity2.field_70165_t, entity2.field_70163_u - 200.0, entity2.field_70161_v);
                    }
                    return false;
                }
                if (!(this.drone instanceof EntityDrone)) continue;
                entity = (EntityDrone)this.drone;
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u - 200.0, entity.field_70161_v);
            }
            return false;
        }
        return true;
    }

    private void setFakePlayerAccordingToDir() {
        EntityPlayerMP fakePlayer = this.drone.getFakePlayer();
        Vec3 pos = this.drone.getPosition();
        fakePlayer.field_70165_t = pos.field_72450_a;
        fakePlayer.field_70161_v = pos.field_72449_c;
        switch (ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.widget)).getSides())) {
            case UP: {
                fakePlayer.field_70125_A = -90.0f;
                fakePlayer.field_70163_u = pos.field_72448_b - 10.0;
                return;
            }
            case DOWN: {
                fakePlayer.field_70125_A = 90.0f;
                fakePlayer.field_70163_u = pos.field_72448_b + 10.0;
                return;
            }
            case NORTH: {
                fakePlayer.field_70177_z = 180.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
                break;
            }
            case EAST: {
                fakePlayer.field_70177_z = 270.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
                break;
            }
            case SOUTH: {
                fakePlayer.field_70177_z = 0.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
                break;
            }
            case WEST: {
                fakePlayer.field_70177_z = 90.0f;
                fakePlayer.field_70163_u = pos.field_72448_b;
            }
        }
    }

    private boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (!world.func_147465_d(x, y, z, block, metadata, 3)) {
            return false;
        }
        block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
        block.func_149714_e(world, x, y, z, metadata);
        return true;
    }
}

