/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.common.ai.DroneAILiquidExport;
import pneumaticCraft.common.ai.DroneAILiquidImport;
import pneumaticCraft.common.ai.DroneEntityAIInventoryExport;
import pneumaticCraft.common.ai.DroneEntityAIInventoryImport;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.ai.LogisticsManager;
import pneumaticCraft.common.progwidgets.ICountWidget;
import pneumaticCraft.common.progwidgets.ILiquidFiltered;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;
import pneumaticCraft.common.semiblock.ISemiBlock;
import pneumaticCraft.common.semiblock.SemiBlockLogistics;
import pneumaticCraft.common.semiblock.SemiBlockManager;

public class DroneAILogistics
extends EntityAIBase {
    private EntityAIBase curAI;
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase widget;
    private final LogisticsManager manager = new LogisticsManager();
    private LogisticsManager.LogisticsTask curTask;

    public DroneAILogistics(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        this.drone = drone;
        this.widget = widget;
    }

    public boolean func_75250_a() {
        this.manager.clearLogistics();
        Set<ChunkPosition> area = this.widget.getCachedAreaSet();
        if (area.size() == 0) {
            return false;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (ChunkPosition pos : area) {
            minX = Math.min(minX, pos.field_151329_a);
            maxX = Math.max(maxX, pos.field_151329_a);
            minZ = Math.min(minZ, pos.field_151328_c);
            maxZ = Math.max(maxZ, pos.field_151328_c);
        }
        for (int x = minX; x < maxX + 16; x += 16) {
            for (int z = minZ; z < maxZ + 16; z += 16) {
                Chunk chunk = this.drone.getWorld().func_72938_d(x, z);
                Map<ChunkPosition, ISemiBlock> map = SemiBlockManager.getInstance(this.drone.getWorld()).getSemiBlocks().get(chunk);
                if (map == null) continue;
                for (Map.Entry<ChunkPosition, ISemiBlock> entry : map.entrySet()) {
                    if (!(entry.getValue() instanceof SemiBlockLogistics) || !area.contains(entry.getKey())) continue;
                    SemiBlockLogistics logisticsBlock = (SemiBlockLogistics)entry.getValue();
                    this.manager.addLogisticFrame(logisticsBlock);
                }
            }
        }
        this.curTask = null;
        return this.doLogistics();
    }

    private boolean doLogistics() {
        ItemStack item = this.drone.getInventory().func_70301_a(0);
        FluidStack fluid = this.drone.getTank().getFluid();
        PriorityQueue<LogisticsManager.LogisticsTask> tasks = this.manager.getTasks(item != null ? item : fluid);
        if (tasks.size() > 0) {
            this.curTask = tasks.poll();
            return this.execute(this.curTask);
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.curTask == null) {
            return false;
        }
        if (!this.curAI.func_75253_b()) {
            if (this.curAI instanceof DroneEntityAIInventoryImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingItem);
                return this.clearAIAndProvideAgain();
            }
            if (this.curAI instanceof DroneAILiquidImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingFluid);
                return this.clearAIAndProvideAgain();
            }
            this.curAI = null;
            return false;
        }
        this.curTask.informRequester();
        return true;
    }

    private boolean clearAIAndProvideAgain() {
        this.curAI = null;
        if (this.curTask.isStillValid(this.drone.getInventory().func_70301_a(0) != null ? this.drone.getInventory().func_70301_a(0) : this.drone.getTank().getFluid()) && this.execute(this.curTask)) {
            return true;
        }
        this.curTask = null;
        return this.doLogistics();
    }

    public boolean execute(LogisticsManager.LogisticsTask task) {
        if (this.drone.getInventory().func_70301_a(0) != null) {
            if (!this.isPosPathfindable(task.requester.getPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryExport(this.drone, new FakeWidgetLogistics(task.requester.getPos(), task.transportingItem));
        } else if (this.drone.getTank().getFluidAmount() > 0) {
            if (!this.isPosPathfindable(task.requester.getPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidExport(this.drone, new FakeWidgetLogistics(task.requester.getPos(), task.transportingFluid.stack));
        } else if (task.transportingItem != null) {
            if (!this.isPosPathfindable(task.provider.getPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryImport(this.drone, new FakeWidgetLogistics(task.provider.getPos(), task.transportingItem));
        } else {
            if (!this.isPosPathfindable(task.provider.getPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidImport(this.drone, new FakeWidgetLogistics(task.provider.getPos(), task.transportingFluid.stack));
        }
        if (this.curAI.func_75250_a()) {
            task.informRequester();
            return true;
        }
        return false;
    }

    private boolean isPosPathfindable(ChunkPosition pos) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.drone.isBlockValidPathfindBlock(pos.field_151329_a + d.offsetX, pos.field_151327_b + d.offsetY, pos.field_151328_c + d.offsetZ)) continue;
            return true;
        }
        return false;
    }

    private static class FakeWidgetLogistics
    extends ProgWidgetAreaItemBase
    implements ISidedWidget,
    ICountWidget,
    ILiquidFiltered {
        private ItemStack stack;
        private FluidStack fluid;
        private final Set<ChunkPosition> area;

        public FakeWidgetLogistics(ChunkPosition pos, ItemStack stack) {
            this.stack = stack;
            this.area = new HashSet<ChunkPosition>();
            this.area.add(pos);
        }

        public FakeWidgetLogistics(ChunkPosition pos, FluidStack fluid) {
            this.fluid = fluid;
            this.area = new HashSet<ChunkPosition>();
            this.area.add(pos);
        }

        @Override
        public String getWidgetString() {
            return null;
        }

        @Override
        public int getCraftingColorIndex() {
            return 0;
        }

        @Override
        public void getArea(Set<ChunkPosition> area) {
            area.addAll(this.area);
        }

        @Override
        public void setSides(boolean[] sides) {
        }

        @Override
        public boolean[] getSides() {
            return new boolean[]{true, true, true, true, true, true};
        }

        @Override
        public boolean isItemValidForFilters(ItemStack item) {
            return item != null && item.func_77969_a(this.stack);
        }

        @Override
        protected ResourceLocation getTexture() {
            return null;
        }

        @Override
        public boolean useCount() {
            return true;
        }

        @Override
        public void setUseCount(boolean useCount) {
        }

        @Override
        public int getCount() {
            return this.stack != null ? this.stack.field_77994_a : this.fluid.amount;
        }

        @Override
        public void setCount(int count) {
        }

        @Override
        public boolean isFluidValid(Fluid fluid) {
            return fluid == this.fluid.getFluid();
        }
    }
}

