/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.item;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.ClientEventHandler;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.lib.Models;

public class RenderItemPneumaticHelmet
implements IItemRenderer {
    private IModelCustom helmetModel;
    private IModelCustom faceModel;
    private IModelCustom eyesModel;
    public static RenderItemPneumaticHelmet INSTANCE = new RenderItemPneumaticHelmet();

    public void render(EntityLivingBase entityLiving) {
        GL11.glPushMatrix();
        float rot1 = entityLiving.field_70758_at + (entityLiving.field_70759_as - entityLiving.field_70758_at) * ClientEventHandler.playerRenderPartialTick;
        float rot2 = entityLiving.field_70760_ar + (entityLiving.field_70761_aq - entityLiving.field_70760_ar) * ClientEventHandler.playerRenderPartialTick;
        GL11.glRotated((double)(rot1 - rot2), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(entityLiving.field_70127_C + (entityLiving.field_70125_A - entityLiving.field_70127_C) * ClientEventHandler.playerRenderPartialTick), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)-0.08, (double)0.1, (double)-0.4);
        double scale = 0.09375;
        GL11.glScaled((double)scale, (double)(-scale), (double)(-scale));
        this.render();
        GL11.glPopMatrix();
    }

    public void render() {
        if (this.helmetModel == null) {
            this.helmetModel = AdvancedModelLoader.loadModel((ResourceLocation)Models.PNEUMATIC_HELMET);
            this.eyesModel = AdvancedModelLoader.loadModel((ResourceLocation)Models.PNEUMATIC_HELMET_EYES);
            this.faceModel = AdvancedModelLoader.loadModel((ResourceLocation)Models.PNEUMATIC_HELMET_FACE);
            if (!Config.useHelmetModel) {
                PneumaticCraft.proxy.getPlayer().func_146105_b((IChatComponent)new ChatComponentTranslation("message.date.ironman", new Object[0]));
            }
        }
        GL11.glDisable((int)3553);
        GL11.glColor4d((double)1.0, (double)0.2, (double)0.2, (double)1.0);
        this.helmetModel.renderAll();
        GL11.glColor4d((double)1.0, (double)1.0, (double)0.7, (double)1.0);
        this.faceModel.renderAll();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glDisable((int)2884);
        this.eyesModel.renderAll();
        GL11.glEnable((int)3553);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                this.render(0.0f, 3.0f, 1.0f, 0.08f);
                return;
            }
            case EQUIPPED: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.render(-3.0f, 0.0f, 2.0f, 0.15f);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glRotatef((float)-150.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.render(0.0f, -7.0f, 5.0f, 0.2f);
                return;
            }
            case INVENTORY: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                this.render(2.8f, 7.0f, 0.0f, 0.15f);
                return;
            }
        }
    }

    private void render(float x, float y, float z, float scale) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.render();
        GL11.glPopMatrix();
    }
}

