/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.gui.widget;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import pneumaticCraft.client.gui.widget.GuiCheckBox;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;
import pneumaticCraft.client.render.pneumaticArmor.UpgradeRenderHandlerList;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketToggleHelmetFeature;
import pneumaticCraft.proxy.ClientProxy;

public class GuiKeybindCheckBox
extends GuiCheckBox {
    private boolean isAwaitingKey;
    private String oldCheckboxText;
    private KeyBinding keyBinding;
    public final String keyBindingName;
    public static final Map<String, GuiKeybindCheckBox> trackedCheckboxes = new HashMap<String, GuiKeybindCheckBox>();

    public GuiKeybindCheckBox(int id, int x, int y, int color, String text) {
        this(id, x, y, color, text, text);
    }

    public GuiKeybindCheckBox(int id, int x, int y, int color, String text, String keyBindingName) {
        super(id, x, y, color, text);
        this.keyBindingName = keyBindingName;
        this.keyBinding = GuiKeybindCheckBox.setOrAddKeybind(keyBindingName, -1);
        if (!trackedCheckboxes.containsKey(keyBindingName)) {
            this.checked = Config.config.get("pneumatic_helmet_widgetDefaults", keyBindingName, true).getBoolean();
            trackedCheckboxes.put(keyBindingName, this);
            FMLCommonHandler.instance().bus().register((Object)this);
        } else {
            this.checked = GuiKeybindCheckBox.trackedCheckboxes.get((Object)keyBindingName).checked;
        }
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            super.onMouseClicked(mouseX, mouseY, button);
            GuiKeybindCheckBox trackedBox = trackedCheckboxes.get(this.keyBindingName);
            if (trackedBox != this) {
                trackedBox.onMouseClicked(mouseX, mouseY, button);
            } else {
                int i;
                Config.config.get("pneumatic_helmet_widgetDefaults", this.keyBindingName, true).set(this.checked);
                Config.config.save();
                for (i = 0; i < UpgradeRenderHandlerList.instance().upgradeRenderers.size(); ++i) {
                    IUpgradeRenderHandler upgradeRenderHandler = UpgradeRenderHandlerList.instance().upgradeRenderers.get(i);
                    if (!("pneumaticHelmet.upgrade." + upgradeRenderHandler.getUpgradeName()).equals(this.keyBindingName)) continue;
                    NetworkHandler.sendToServer(new PacketToggleHelmetFeature((byte)i, GuiKeybindCheckBox.trackedCheckboxes.get((Object)"pneumaticHelmet.upgrade.coreComponents").checked && this.checked));
                }
                if (this.keyBindingName.equals("pneumaticHelmet.upgrade.coreComponents")) {
                    for (i = 0; i < UpgradeRenderHandlerList.instance().upgradeRenderers.size(); ++i) {
                        NetworkHandler.sendToServer(new PacketToggleHelmetFeature((byte)i, this.checked && GuiKeybindCheckBox.trackedCheckboxes.get((Object)new StringBuilder().append((String)"pneumaticHelmet.upgrade.").append((String)UpgradeRenderHandlerList.instance().upgradeRenderers.get((int)i).getUpgradeName()).toString()).checked));
                    }
                }
            }
        } else {
            boolean bl = this.isAwaitingKey = !this.isAwaitingKey;
            if (this.isAwaitingKey) {
                this.oldCheckboxText = this.text;
                this.text = "gui.setKeybind";
            } else {
                this.text = this.oldCheckboxText;
            }
        }
    }

    @Override
    public boolean onKey(char key, int keyCode) {
        if (this.isAwaitingKey) {
            this.isAwaitingKey = false;
            this.keyBinding = GuiKeybindCheckBox.setOrAddKeybind(this.keyBindingName, keyCode);
            this.text = this.oldCheckboxText;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71415_G && this.keyBinding != null && this.keyBinding.func_151468_f()) {
            this.onMouseClicked(0, 0, 0);
            HUDHandler.instance().addMessage(I18n.func_135052_a((String)("pneumaticHelmet.message." + (this.checked ? "enable" : "disable") + "Setting"), (Object[])new Object[]{I18n.func_135052_a((String)this.text, (Object[])new Object[0])}), new ArrayList<String>(), 60, 0x7000AA00);
        }
    }

    public static KeyBinding setOrAddKeybind(String keybindName, int keyCode) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
        for (KeyBinding keyBinding : gameSettings.field_74324_K) {
            if (keyBinding == null || !keyBinding.func_151464_g().equals(keybindName) || !keybindName.equals(keyBinding.func_151464_g())) continue;
            if (keyCode >= 0) {
                keyBinding.func_151462_b(keyCode);
                KeyBinding.func_74508_b();
                gameSettings.func_74303_b();
            }
            return keyBinding;
        }
        if (keyCode < 0) {
            if (((ClientProxy)PneumaticCraft.proxy).keybindToKeyCodes.containsKey(keybindName)) {
                keyCode = ((ClientProxy)PneumaticCraft.proxy).keybindToKeyCodes.get(keybindName);
            } else {
                return null;
            }
        }
        KeyBinding keyBinding = new KeyBinding(keybindName, keyCode, "key.pneumaticcraft.category");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        KeyBinding.func_74508_b();
        gameSettings.func_74303_b();
        return keyBinding;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTooltip, boolean shiftPressed) {
        if (this.keyBinding != null) {
            curTooltip.add(I18n.func_135052_a((String)"gui.keybindBoundKey", (Object[])new Object[]{Keyboard.getKeyName((int)this.keyBinding.func_151463_i())}));
        } else if (!this.isAwaitingKey) {
            curTooltip.add("gui.keybindRightClickToSet");
        }
    }
}

