/*
 * Decompiled with CFR 0.152.
 */
package com.tierzero.stacksonstacks.util;

import com.tierzero.stacksonstacks.pile.PileItem;
import com.tierzero.stacksonstacks.pile.PileItemRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ClientUtils {
    private static Tessellator tes = Tessellator.field_78398_a;

    @SideOnly(value=Side.CLIENT)
    private static String getIconName(ItemStack stack) {
        IIcon icon = stack.func_77973_b().func_77617_a(stack.func_77960_j());
        if (icon != null) {
            return icon.func_94215_i();
        }
        return null;
    }

    private static String[] splitString(String regex, String stringToSplit) {
        return stringToSplit.split(regex);
    }

    private static String buildPath(String[] seperatedName) {
        String iconName = "textures/items/";
        for (int i = 1; i < seperatedName.length - 1; ++i) {
            iconName = iconName + seperatedName[i] + "/";
        }
        iconName = iconName + seperatedName[seperatedName.length - 1] + ".png";
        return iconName;
    }

    @SideOnly(value=Side.CLIENT)
    public static IResource getIconResource(ItemStack stack) {
        IResource resource = ClientUtils.fromIconName(stack);
        if (resource == null) {
            PileItem pileItem = PileItemRegistry.getPileItem(stack);
            String registeredName = pileItem.getItemName();
            String unlocalizedName = pileItem.getName();
            resource = ClientUtils.fromNames(registeredName, unlocalizedName);
        }
        return resource;
    }

    private static IResource fromIconName(ItemStack stack) {
        String iconName = ClientUtils.getIconName(stack);
        if (iconName != null) {
            String[] seperatedIconName = ClientUtils.splitString("[:/]+", iconName);
            String domain = seperatedIconName[0].toLowerCase();
            if (domain.equals(seperatedIconName[seperatedIconName.length - 1])) {
                domain = "minecraft";
            }
            String path = ClientUtils.buildPath(seperatedIconName);
            return ClientUtils.getResource(domain, path);
        }
        return null;
    }

    private static IResource fromNames(String registeredName, String unlocalizedName) {
        String[] seperatedName;
        registeredName = registeredName.replaceAll("item.", "");
        unlocalizedName = unlocalizedName.replaceAll("item.", "");
        if (registeredName.contains(":")) {
            seperatedName = ClientUtils.splitString("[':']+", registeredName);
        } else if (unlocalizedName.contains(":")) {
            seperatedName = ClientUtils.splitString("[':']+", unlocalizedName);
        } else {
            unlocalizedName = unlocalizedName + "." + registeredName;
            seperatedName = ClientUtils.splitString("['.']+", unlocalizedName);
        }
        String domain = seperatedName[0];
        String path = ClientUtils.buildPath(seperatedName);
        return ClientUtils.getResource(domain, path);
    }

    private static IResource getResource(String domain, String path) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(domain, path));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void drawQuad(double Umin, double Vmin, double Umax, double Vmax, double scale) {
        tes.func_78374_a(0.0, 0.0, 1.0 * scale, Umax, Vmin);
        tes.func_78374_a(1.0 * scale, 0.0, 1.0 * scale, Umin, Vmin);
        tes.func_78374_a(1.0 * scale, 0.0, 0.0, Umin, Vmax);
        tes.func_78374_a(0.0, 0.0, 0.0, Umax, Vmax);
    }

    public static void drawItem(IIcon icon, double scale) {
        if (icon != null) {
            float Umin = icon.func_94209_e();
            float Vmax = icon.func_94210_h();
            float Vmin = icon.func_94206_g();
            float Umax = icon.func_94212_f();
            ClientUtils.drawQuad(Umin, Vmin, Umax, Vmax, scale);
        }
    }

    public static void drawRectangularPrism(double x, double y, double z, double x1, double y1, double z1, double slantX, double slantZ, double Umin, double Vmin, double Umax, double Vmax, Color color) {
        tes.func_78376_a(color.getRed(), color.getGreen(), color.getBlue());
        tes.func_78374_a(x1, y, z, Umin, Vmax);
        tes.func_78374_a(x1, y, z1, Umin, Vmin);
        tes.func_78374_a(x, y, z1, Umax, Vmin);
        tes.func_78374_a(x, y, z, Umax, Vmax);
        tes.func_78374_a(x1 - slantX, y1, z1 - slantZ, Umax, Vmax);
        tes.func_78374_a(x1 - slantX, y1, z + slantZ, Umax, Vmin);
        tes.func_78374_a(x + slantX, y1, z + slantZ, Umin, Vmin);
        tes.func_78374_a(x + slantX, y1, z1 - slantZ, Umin, Vmax);
        tes.func_78374_a(x, y, z, Umin, Vmin);
        tes.func_78374_a(x + slantX, y1, z + slantZ, Umin, Vmax);
        tes.func_78374_a(x1 - slantX, y1, z + slantZ, Umax, Vmax);
        tes.func_78374_a(x1, y, z, Umax, Vmin);
        tes.func_78374_a(x1, y, z1, Umax, Vmin);
        tes.func_78374_a(x1 - slantX, y1, z1 - slantZ, Umax, Vmax);
        tes.func_78374_a(x + slantX, y1, z1 - slantZ, Umin, Vmax);
        tes.func_78374_a(x, y, z1, Umin, Vmin);
        tes.func_78374_a(x, y, z, Umin, Vmax);
        tes.func_78374_a(x, y, z1, Umax, Vmax);
        tes.func_78374_a(x + slantX, y1, z1 - slantZ, Umax, Vmin);
        tes.func_78374_a(x + slantX, y1, z + slantZ, Umin, Vmin);
        tes.func_78374_a(x1, y, z, Umax, Vmin);
        tes.func_78374_a(x1 - slantX, y1, z + slantZ, Umax, Vmax);
        tes.func_78374_a(x1 - slantX, y1, z1 - slantZ, Umin, Vmax);
        tes.func_78374_a(x1, y, z1, Umin, Vmin);
    }

    public static void drawRectangularPrism(double width, double length, double height, double slantX, double slantZ, double Umin, double Vmin, double Umax, double Vmax, Color color) {
        ClientUtils.drawRectangularPrism(0.0, 0.0, 0.0, width, height, length, slantX, slantZ, Umin, Vmin, Umax, Vmax, color);
    }

    public static void enableTexture2D() {
        ClientUtils.enable(3553);
    }

    public static void disableTexture2D() {
        ClientUtils.disable(3553);
    }

    public static void pushAttrib() {
        GL11.glPushAttrib((int)8256);
    }

    public static void popAttrib() {
        GL11.glPopAttrib();
    }

    public static void loadIdentity() {
        GL11.glLoadIdentity();
    }

    private static void disable(int cap) {
        GL11.glDisable((int)cap);
    }

    private static void enable(int cap) {
        GL11.glEnable((int)cap);
    }

    public static void disableAlpha() {
        ClientUtils.disable(3008);
    }

    public static void enableAlpha() {
        ClientUtils.enable(3008);
    }

    public static void alphaFunc(int func, float ref) {
        GL11.glAlphaFunc((int)func, (float)ref);
    }

    public static void enableLighting() {
        ClientUtils.enable(2896);
    }

    public static void disableLighting() {
        ClientUtils.disable(2896);
    }

    public static void disableDepth() {
        ClientUtils.disable(6145);
    }

    public static void enableDepth() {
        ClientUtils.enable(6145);
    }

    public static void depthFunc(int func) {
        GL11.glDepthFunc((int)func);
    }

    public static void depthMask(boolean flag) {
        GL11.glDepthMask((boolean)flag);
    }

    public static void disableBlend() {
        ClientUtils.disable(3042);
    }

    public static void enableBlend() {
        ClientUtils.enable(3042);
    }

    public static void blendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public static void enableCull() {
        ClientUtils.enable(2884);
    }

    public static void disableCull() {
        ClientUtils.disable(2884);
    }

    public static void enableRescaleNormal() {
        ClientUtils.enable(32826);
    }

    public static void disableRescaleNormal() {
        ClientUtils.disable(32826);
    }

    public static void matrixMode(int mode) {
        GL11.glMatrixMode((int)mode);
    }

    public static void pushMatrix() {
        GL11.glPushMatrix();
    }

    public static void popMatrix() {
        GL11.glPopMatrix();
    }

    public static void rotate(double angle, double x, double y, double z) {
        GL11.glRotated((double)angle, (double)x, (double)y, (double)z);
    }

    public static void rotate(float angle, float x, float y, float z) {
        GL11.glRotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void scale(float x, float y, float z) {
        GL11.glScalef((float)x, (float)y, (float)z);
    }

    public static void scale(double x, double y, double z) {
        GL11.glScaled((double)x, (double)y, (double)z);
    }

    public static void translate(float x, float y, float z) {
        GL11.glTranslatef((float)x, (float)y, (float)z);
    }

    public static void translate(double x, double y, double z) {
        GL11.glTranslated((double)x, (double)y, (double)z);
    }

    public static void colorMask(boolean r, boolean g, boolean b, boolean a) {
        GL11.glColorMask((boolean)r, (boolean)g, (boolean)b, (boolean)a);
    }

    public static void colour(float r, float g, float b, float a) {
        System.out.println(r + "," + g + "," + b);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void colour(float r, float g, float b) {
        ClientUtils.colour(r, g, b, 1.0f);
    }

    public static void colourOpaque(int colour) {
        ClientUtils.colour(colour | 0xFF000000);
    }

    public static void colour(int colour) {
        float r = (float)(colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        int a = colour >> 24 & 0xFF;
        if (a <= 0) {
            a = 255;
        }
        ClientUtils.colour(r, g, b, (float)a / 255.0f);
    }

    public static void viewport(int x, int y, int x1, int height) {
        GL11.glViewport((int)x, (int)y, (int)x1, (int)height);
    }

    public static void normal(float x, float y, float z) {
        GL11.glNormal3f((float)x, (float)y, (float)z);
    }

    public static long getCoordinateRandom(int x, int y, int z) {
        long l = (long)(x * 3129871) ^ (long)z * 116129781L ^ (long)y;
        l = l * l * 42317861L + l * 11L;
        return l;
    }

    public static long getCoordinateRandom(double x, double y, double z) {
        return ClientUtils.getCoordinateRandom((int)x, (int)y, (int)z);
    }
}

