/*
 * Decompiled with CFR 0.152.
 */
package com.tierzero.stacksonstacks.pile;

import com.tierzero.stacksonstacks.pile.PileItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class PileItemRegistry {
    public static List<PileItemList> registeredPileItems = new ArrayList<PileItemList>();
    public static PileItemList registeredIngots = new PileItemList();
    public static PileItemList registeredGems = new PileItemList();
    public static PileItemList registeredDusts = new PileItemList();

    public static PileItem registerPileItem(ItemStack stack, int type) {
        if (PileItemRegistry.getPileItem(stack) == null) {
            PileItem item = new PileItem(stack, type);
            registeredPileItems.get(type).add(item);
            return item;
        }
        return null;
    }

    public static PileItem getPileItem(ItemStack stack) {
        for (PileItemList list : registeredPileItems) {
            for (PileItem item : list) {
                if (stack.func_77973_b() != item.getItem() || stack.func_77960_j() != item.getMeta()) continue;
                return item;
            }
        }
        return null;
    }

    public static int getPileType(ItemStack stack) {
        return PileItemRegistry.getPileItem(stack).getType();
    }

    public static boolean isValidPileItem(ItemStack stack) {
        return PileItemRegistry.getPileItem(stack) != null;
    }

    public static PileItem registerIngot(ItemStack stack) {
        return PileItemRegistry.registerPileItem(stack, 0);
    }

    public static PileItem registerGem(ItemStack stack) {
        return PileItemRegistry.registerPileItem(stack, 1);
    }

    public static PileItem registerDust(ItemStack stack) {
        return PileItemRegistry.registerPileItem(stack, 2);
    }

    public static class PileItemList
    extends ArrayList<PileItem> {
        public int index;

        public PileItemList() {
            registeredPileItems.add(this);
            this.index = registeredPileItems.size() - 1;
        }
    }
}

