/*
 * Decompiled with CFR 0.152.
 */
package com.tierzero.stacksonstacks.pile;

import com.google.common.collect.Lists;
import com.tierzero.stacksonstacks.pile.PileItemRegistry;
import com.tierzero.stacksonstacks.util.ConfigHandler;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class PileItemFinder {
    private static String[] invalidIngotNames = ConfigHandler.invalidIngots;
    private static String[] invalidGemNames = ConfigHandler.invalidGems;
    private static String[] invalidDustNames = ConfigHandler.invalidDusts;
    private static String[] validIngotNames = ConfigHandler.validIngots;
    private static String[] validGemNames = ConfigHandler.validGems;
    private static String[] validDustNames = ConfigHandler.validDusts;
    private static String[][] invalidNames = new String[][]{invalidIngotNames, invalidGemNames, invalidDustNames};
    private static String[][] validKeyWord = new String[][]{validIngotNames, validGemNames, validDustNames};

    public static void registerAllItems() {
        for (int type = 0; type < validKeyWord.length; ++type) {
            PileItemFinder.registerPileItem(type);
        }
    }

    public static void registerPileItem(int type) {
        FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
        Set registeredItemNames = itemRegistry.func_148742_b();
        List<String> validRegisteredNames = PileItemFinder.getValidNames(Lists.newArrayList((Iterable)registeredItemNames), type);
        List<String> validOredictNames = PileItemFinder.getValidNames(Lists.newArrayList((Object[])OreDictionary.getOreNames()), type);
        for (String validName : validOredictNames) {
            for (ItemStack stack : OreDictionary.getOres((String)validName)) {
                PileItemRegistry.registerPileItem(stack, type);
            }
        }
        for (String validName : validRegisteredNames) {
            ItemStack stack = new ItemStack((Item)itemRegistry.func_82594_a(validName));
            PileItemRegistry.registerPileItem(stack, type);
        }
    }

    private static List<String> getValidNames(List<String> names, int type) {
        ArrayList<String> validNames = new ArrayList<String>();
        for (String name : names) {
            String searcher = name.indexOf(58) != -1 ? name.substring(name.indexOf(58)) : name;
            for (String valid : validKeyWord[type]) {
                if (searcher.isEmpty() || !searcher.contains(valid)) continue;
                boolean invalid = false;
                for (String invalidName : invalidNames[type]) {
                    if (!searcher.contains(invalidName)) continue;
                    invalid = true;
                }
                if (invalid) continue;
                validNames.add(name);
            }
        }
        return validNames;
    }
}

