/*
 * Decompiled with CFR 0.152.
 */
package com.tierzero.stacksonstacks.pile;

import com.tierzero.stacksonstacks.SoS;
import com.tierzero.stacksonstacks.block.tile.TilePile;
import com.tierzero.stacksonstacks.pile.PileItemRegistry;
import com.tierzero.stacksonstacks.util.StackUtils;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PileHandler {
    private static Block[] blockedBlocks = new Block[]{Blocks.field_150462_ai, Blocks.field_150466_ao, Blocks.field_150415_aT, Blocks.field_150324_C, Blocks.field_150396_be};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleBlockPlacement(PlayerInteractEvent event) {
        ItemStack heldItemStack;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (heldItemStack = event.entityPlayer.func_71045_bC()) != null && PileItemRegistry.isValidPileItem(heldItemStack)) {
            int clickedX = event.x;
            int clickedY = event.y;
            int clickedZ = event.z;
            boolean playerSneaking = event.entityPlayer.func_70093_af();
            Block blockAtClickedPosition = event.world.func_147439_a(clickedX, clickedY, clickedZ);
            TileEntity tileAtClickedPosition = event.world.func_147438_o(clickedX, clickedY, clickedZ);
            if (tileAtClickedPosition != null) {
                if (tileAtClickedPosition instanceof TilePile) {
                    ((TilePile)tileAtClickedPosition).onRightClicked(event.entityPlayer, heldItemStack);
                    return;
                }
                return;
            }
            for (Block blockedBlock : blockedBlocks) {
                if (!blockAtClickedPosition.equals(blockedBlock)) continue;
                return;
            }
            int[] coords = PileHandler.getPlacementCoords(clickedX, clickedY, clickedZ, event.face);
            int placementX = coords[0];
            int placementY = coords[1];
            int placementZ = coords[2];
            Block blockAtPlacementPosition = event.world.func_147439_a(placementX, placementY, placementZ);
            TileEntity tileAtPlacementPosition = event.world.func_147438_o(placementX, placementY, placementZ);
            if (blockAtPlacementPosition.isAir((IBlockAccess)event.world, placementX, placementY, placementZ)) {
                Block blockBelowPlacementPosition = event.world.func_147439_a(placementX, placementY - 1, placementZ);
                if (blockBelowPlacementPosition.func_149688_o().func_76220_a() && blockBelowPlacementPosition != SoS.blockPile) {
                    if (heldItemStack.func_77973_b().equals(Items.field_151137_ax) && blockAtPlacementPosition != Blocks.field_150488_af) {
                        return;
                    }
                    if (heldItemStack.func_77973_b().equals(Items.field_151100_aR) && heldItemStack.func_77960_j() == 15 && blockAtPlacementPosition.equals(Blocks.field_150349_c)) {
                        return;
                    }
                    event.world.func_147449_b(placementX, placementY, placementZ, (Block)SoS.blockPile);
                    event.world.func_147439_a(placementX, placementY, placementZ).func_149689_a(event.world, placementX, placementY, placementZ, (EntityLivingBase)event.entityPlayer, heldItemStack);
                    if (playerSneaking) {
                        ItemStack comparatorFixer = StackUtils.getItemsFromStack(heldItemStack, 0);
                        event.world.func_147439_a(placementX, placementY, placementZ).func_149689_a(event.world, placementX, placementY, placementZ, (EntityLivingBase)event.entityPlayer, comparatorFixer);
                    }
                }
            } else if (tileAtPlacementPosition instanceof TilePile) {
                blockAtPlacementPosition.func_149727_a(event.world, placementX, placementY, placementZ, event.entityPlayer, 0, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    public static int[] getPlacementCoords(int x, int y, int z, int side) {
        int x1 = x;
        int y1 = y;
        int z1 = z;
        switch (ForgeDirection.getOrientation((int)side)) {
            case DOWN: {
                break;
            }
            case EAST: {
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                ++z1;
                break;
            }
            case UP: {
                ++y1;
                break;
            }
            case WEST: {
                --x1;
                break;
            }
        }
        return new int[]{++x1, --y1, --z1};
    }
}

