/*
 * Decompiled with CFR 0.152.
 */
package com.tierzero.stacksonstacks.pile;

import com.tierzero.stacksonstacks.pile.PileItem;
import com.tierzero.stacksonstacks.pile.PileItemRegistry;
import com.tierzero.stacksonstacks.util.ClientUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.item.ItemStack;

public class PileColorizer {
    @SideOnly(value=Side.CLIENT)
    public static void registerPileColors() {
        for (List list : PileItemRegistry.registeredPileItems) {
            for (PileItem pileitem : list) {
                pileitem.setColor(PileColorizer.getColor(pileitem.getPileStack()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getStackColour(ItemStack stack, int pass) {
        return stack.func_77973_b().func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public static Color getColor(ItemStack stack) {
        ArrayList<Color> colors = new ArrayList<Color>();
        try {
            colors.add(PileColorizer.getColorFromTexture(stack));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int pass = 0; pass < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++pass) {
            int stackColor = PileColorizer.getStackColour(stack, pass);
            if (stackColor == 0xFFFFFF) continue;
            colors.add(new Color(stackColor));
        }
        if (Loader.isModLoaded((String)"gregtech")) {
            try {
                Color gregColor = PileColorizer.getGregtechColor(stack);
                if (gregColor != null) {
                    colors.clear();
                    colors.add(gregColor);
                }
            }
            catch (Exception gregColor) {
                // empty catch block
            }
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        for (Color c : colors) {
            red += (float)c.getRed();
            green += (float)c.getGreen();
            blue += (float)c.getBlue();
        }
        float count = colors.size();
        Color pileitemColor = new Color((int)(red / count), (int)(green / count), (int)(blue / count));
        if (pileitemColor.getRed() == 0 && pileitemColor.getBlue() == 0 && pileitemColor.getRed() == 0) {
            pileitemColor = new Color(156, 156, 156);
        }
        return pileitemColor;
    }

    private static Color getColorFromTexture(ItemStack stack) throws IOException {
        BufferedImage texture = ImageIO.read(ClientUtils.getIconResource(stack).func_110527_b());
        return PileColorizer.getAverageColor(texture);
    }

    private static Color getGregtechColor(ItemStack stack) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> itemCls;
        Class<?> cls = Class.forName("gregtech.api.items.GT_MetaGenerated_Item");
        if (cls.isAssignableFrom(itemCls = stack.func_77973_b().getClass())) {
            Method m = itemCls.getMethod("getRGBa", ItemStack.class);
            short[] rgba = (short[])m.invoke((Object)stack.func_77973_b(), stack);
            return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static Color getAverageColor(BufferedImage image) {
        int offset;
        int red = 0;
        int green = 0;
        int blue = 0;
        int count = 0;
        for (int i = offset = 4; i < image.getWidth() - offset; ++i) {
            for (int j = offset; j < image.getHeight() - offset; ++j) {
                Color imageColor = new Color(image.getRGB(i, j));
                if (imageColor.getAlpha() != 255 || imageColor.getRed() <= 10 && imageColor.getBlue() <= 10 && imageColor.getGreen() <= 10) continue;
                red += imageColor.getRed();
                green += imageColor.getGreen();
                blue += imageColor.getBlue();
                ++count;
            }
        }
        return new Color(red / count, green / count, blue / count);
    }
}

