/*
 * Decompiled with CFR 0.152.
 */
package com.tierzero.stacksonstacks.pile;

import com.tierzero.stacksonstacks.pile.PileItemRegistry;
import com.tierzero.stacksonstacks.util.ConfigHandler;
import com.tierzero.stacksonstacks.util.StackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Pile {
    private static final String TAG_PILE_STACK = "inventory";
    private static final String TAG_PILE_STACKSIZE = "stacksize";
    private static final String TAG_TYPE = "pile_type";
    private ItemStack itemStack;
    private int type;

    public void onLeftClicked(World world, EntityPlayer player, int pilePosX, int pilePosY, int pilePosZ) {
        this.removeFromPile(world, player, pilePosX, pilePosY, pilePosZ);
    }

    public boolean onRightClicked(EntityPlayer player, ItemStack stack) {
        if (stack != null) {
            if (this.itemStack == null && this.getType() != -1 && PileItemRegistry.isValidPileItem(stack)) {
                this.createPile(player, stack);
                return true;
            }
            if (this.itemStack != null && this.itemStack.func_77973_b() != null && this.itemStack.func_77969_a(stack)) {
                this.addToPile(player, stack);
                return true;
            }
        }
        return false;
    }

    private void createPile(EntityPlayer player, ItemStack stack) {
        int initialAmount = this.shouldUseEntireStack(player) ? stack.field_77994_a : 1;
        this.itemStack = StackUtils.getItemsFromStack(stack, initialAmount);
        this.findType(stack);
        StackUtils.decrementStack(player, stack, initialAmount);
        this.playSoundPlaced(player);
    }

    private void addToPile(EntityPlayer player, ItemStack stack) {
        int remainingSpace = this.getMaxStored() - this.itemStack.field_77994_a;
        if (remainingSpace != 0) {
            int amountToAdd = this.shouldUseEntireStack(player) ? Math.min(remainingSpace, stack.field_77994_a) : 1;
            this.itemStack.field_77994_a += amountToAdd;
            StackUtils.decrementStack(player, stack, amountToAdd);
            this.playSoundPlaced(player);
        }
    }

    private void removeFromPile(World world, EntityPlayer player, int pilePosX, int pilePosY, int pilePosZ) {
        if (this.itemStack != null) {
            int amountToRemove = this.shouldUseEntireStack(player) ? this.itemStack.field_77994_a : 1;
            ItemStack stackToDrop = StackUtils.getItemsFromStack(this.itemStack, amountToRemove);
            StackUtils.decrementStack(this.itemStack, amountToRemove);
            boolean couldPlaceStackInPlayerInventory = player.field_71071_by.func_70441_a(stackToDrop);
            if (!couldPlaceStackInPlayerInventory) {
                StackUtils.spawnItemInWorld(world, pilePosX, pilePosY, pilePosZ, stackToDrop);
            }
            this.playSoundRemoved(player);
        }
    }

    private void playSoundPlaced(EntityPlayer player) {
        if (this.type == 2) {
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "dig.sand", 0.75f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else {
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "dig.stone", 0.75f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    private void playSoundRemoved(EntityPlayer player) {
        if (this.type == 2) {
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "dig.sand", 0.75f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else {
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "random.pop", 0.25f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    private boolean shouldUseEntireStack(EntityPlayer player) {
        return player.func_70093_af();
    }

    private void findType(ItemStack stack) {
        this.type = PileItemRegistry.getPileType(stack);
    }

    public int getMaxStored() {
        switch (this.type) {
            case 0: {
                return ConfigHandler.maxIngotStackSize;
            }
            case 1: {
                return ConfigHandler.maxGemStackSize;
            }
            case 2: {
                return ConfigHandler.maxDustStackSize;
            }
        }
        return 64;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound inventoryTag = tag.func_74775_l(TAG_PILE_STACK);
        this.type = tag.func_74762_e(TAG_TYPE);
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)inventoryTag);
        this.itemStack.field_77994_a = tag.func_74762_e(TAG_PILE_STACKSIZE);
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound inventoryTag = new NBTTagCompound();
        if (this.itemStack != null) {
            this.itemStack.func_77955_b(inventoryTag);
            tag.func_74768_a(TAG_PILE_STACKSIZE, this.itemStack.field_77994_a);
            tag.func_74782_a(TAG_PILE_STACK, (NBTBase)inventoryTag);
        }
        tag.func_74768_a(TAG_TYPE, this.type);
    }

    public void debugCreatePile(ItemStack stack) {
        this.findType(stack);
        this.itemStack = stack;
        this.itemStack.field_77994_a = this.getMaxStored() / 2;
    }

    public int getAmountStored() {
        if (this.itemStack != null) {
            return this.itemStack.field_77994_a;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

