/*
 * Decompiled with CFR 0.152.
 */
package com.tierzero.stacksonstacks.block;

import com.tierzero.stacksonstacks.block.tile.TilePile;
import com.tierzero.stacksonstacks.pile.Pile;
import com.tierzero.stacksonstacks.pile.PileItem;
import com.tierzero.stacksonstacks.util.ConfigHandler;
import com.tierzero.stacksonstacks.util.StackUtils;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPile
extends BlockContainer {
    public IIcon[][] icon;
    private int renderID;
    public static String[][] textureNames = new String[][]{{"VanillaGold", "VanillaIron", "ThermalFoundation", "Metallurgy4", "Mekanism"}, {"VanillaSand"}};

    public BlockPile(String name) {
        super(Material.field_151573_f);
        this.func_149663_c(name);
        GameRegistry.registerBlock((Block)this, (String)name);
        this.renderID = RenderingRegistry.getNextAvailableRenderId();
        this.func_149711_c(25.0f);
        this.icon = new IIcon[2][textureNames[0].length];
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TilePile tilePile;
            if (world.func_147437_c(x, y - 1, z)) {
                world.func_147468_f(x, y, z);
            } else if (world.func_147439_a(x, y - 1, z) instanceof BlockPile && (tilePile = (TilePile)world.func_147438_o(x, y - 1, z)) != null && tilePile.getPile().getAmountStored() < tilePile.getPile().getMaxStored()) {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            return ((TilePile)tile).getPile().getAmountStored() / 4;
        }
        return 0;
    }

    public IIcon func_149691_a(int side, int meta) {
        int index = meta == 0 ? ConfigHandler.ingotTextureToUse : ConfigHandler.dustTextureToUse;
        PileItem.setIcon(this.icon[meta][index], meta);
        return this.icon[meta][index];
    }

    public void func_149651_a(IIconRegister iconRegistry) {
        int i;
        for (i = 0; i < textureNames[0].length; ++i) {
            this.icon[0][i] = iconRegistry.func_94245_a("StacksOnStacks:" + textureNames[0][i]);
        }
        for (i = 0; i < textureNames[1].length; ++i) {
            this.icon[1][i] = iconRegistry.func_94245_a("StacksOnStacks:" + textureNames[1][i]);
        }
        PileItem.setIcon(this.icon[0][ConfigHandler.ingotTextureToUse], 0);
        PileItem.setIcon(this.icon[1][ConfigHandler.dustTextureToUse], 1);
        super.func_149651_a(iconRegistry);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventNum, int eventArg) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            return tile.func_145842_c(eventNum, eventArg);
        }
        return false;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            return ((TilePile)tile).getPile().getAmountStored() > 0;
        }
        return false;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TilePile tile = (TilePile)world.func_147438_o(x, y, z);
        if (tile != null) {
            Pile pile = tile.getPile();
            ItemStack pileStack = pile.getItemStack();
            int type = pile.getType();
            if (pileStack != null) {
                int amountStored = pile.getAmountStored();
                float height = 0.0f;
                float width = 1.0f;
                float length = 1.0f;
                if (type == 0) {
                    height = 1 + amountStored / (pile.getMaxStored() / 8);
                    if (amountStored % (pile.getMaxStored() / 8) == 0) {
                        height -= 1.0f;
                    }
                    height /= 8.0f;
                } else if (type == 1) {
                    width = 1.0f;
                    height = 1.0f;
                    length = 1.0f;
                } else {
                    height = 1.0f;
                }
                this.func_149676_a(0.0f, 0.0f, 0.0f, width, height, length);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            ItemStack pileStack = ((TilePile)tile).getPile().getItemStack();
            int stackSize = pileStack.field_77994_a;
            if (stackSize > 64) {
                stackSize = 64;
            }
            return StackUtils.getItemsFromStack(pileStack, stackSize);
        }
        return null;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        super.func_149743_a(world, x, y, z, mask, list, entity);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        ItemStack stackToDrop;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && (stackToDrop = ((TilePile)tile).getPile().getItemStack()) != null && stackToDrop.func_77973_b() != null) {
            this.func_149642_a(world, x, y, z, ((TilePile)tile).getPile().getItemStack());
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            ((TilePile)tile).onLeftClicked(player);
            world.func_147459_d(x, y, z, (Block)this);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            ((TilePile)tile).onRightClicked((EntityPlayer)player, stack);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Item item;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && ((TilePile)tile).getPile().getItemStack() != null && (item = ((TilePile)tile).getPile().getItemStack().func_77973_b()) != null && item == Items.field_151114_aO) {
            return 15;
        }
        return 0;
    }

    public void debugBlockPlaced(World world, int x, int y, int z, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            ((TilePile)tile).debugCreatePile(stack);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TilePile();
    }

    public int func_149645_b() {
        return this.renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }
}

