/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WarpPoint;
import com.google.gson.annotations.Expose;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.BlockEvent;

public class WorldPoint
extends Point {
    protected int dim;
    @Expose(serialize=false)
    protected World world;
    private static final Pattern fromStringPattern = Pattern.compile("\\s*\\[\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*dim\\s*=\\s*(-?\\d+)\\s*\\]\\s*");

    public WorldPoint(int dimension, int x, int y, int z) {
        super(x, y, z);
        this.dim = dimension;
    }

    public WorldPoint(int dimension, ChunkCoordinates location) {
        this(dimension, location.field_71574_a, location.field_71572_b, location.field_71573_c);
    }

    public WorldPoint(World world, int x, int y, int z) {
        super(x, y, z);
        this.dim = world.field_73011_w.field_76574_g;
        this.world = world;
    }

    public WorldPoint(World world, ChunkCoordinates location) {
        this(world, location.field_71574_a, location.field_71572_b, location.field_71573_c);
    }

    public WorldPoint(World world, ChunkPosition location) {
        this(world, location.field_151329_a, location.field_151327_b, location.field_151328_c);
    }

    public WorldPoint(Entity entity) {
        super(entity);
        this.dim = entity.field_71093_bK;
        this.world = entity.field_70170_p;
    }

    public WorldPoint(int dim, Vec3 vector) {
        super(vector);
        this.dim = dim;
    }

    public WorldPoint(WorldPoint other) {
        this(other.dim, other.x, other.y, other.z);
    }

    public WorldPoint(int dimension, Point point) {
        this(dimension, point.x, point.y, point.z);
    }

    public WorldPoint(WarpPoint other) {
        this(other.getDimension(), other.getBlockX(), other.getBlockY(), other.getBlockZ());
    }

    public WorldPoint(BlockEvent event) {
        this(event.world, event.x, event.y, event.z);
    }

    public static WorldPoint create(ICommandSender sender) {
        return new WorldPoint(sender.func_130014_f_(), sender.func_82114_b());
    }

    public int getDimension() {
        return this.dim;
    }

    public void setDimension(int dim) {
        this.dim = dim;
    }

    @Override
    public WorldPoint setX(int x) {
        this.x = x;
        return this;
    }

    @Override
    public WorldPoint setY(int y) {
        this.y = y;
        return this;
    }

    @Override
    public WorldPoint setZ(int z) {
        this.z = z;
        return this;
    }

    public World getWorld() {
        if (this.world != null && this.world.field_73011_w.field_76574_g != this.dim) {
            return this.world;
        }
        this.world = DimensionManager.getWorld((int)this.dim);
        return this.world;
    }

    public WarpPoint toWarpPoint(float rotationPitch, float rotationYaw) {
        return new WarpPoint(this, rotationPitch, rotationYaw);
    }

    public Block getBlock() {
        return this.getWorld().func_147439_a(this.x, this.y, this.z);
    }

    public int getBlockMeta() {
        return this.getWorld().func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity() {
        return this.getWorld().func_147438_o(this.x, this.y, this.z);
    }

    @Override
    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + ",dim=" + this.dim + "]";
    }

    public static WorldPoint fromString(String value) {
        Matcher m = fromStringPattern.matcher(value);
        if (m.matches()) {
            try {
                return new WorldPoint(Integer.parseInt(m.group(4)), Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof WorldPoint) {
            WorldPoint p = (WorldPoint)object;
            return this.dim == p.dim && this.x == p.x && this.y == p.y && this.z == p.z;
        }
        if (object instanceof WarpPoint) {
            WarpPoint p = (WarpPoint)object;
            return this.dim == p.dim && this.x == p.getBlockX() && this.y == p.getBlockY() && this.z == p.getBlockZ();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1 + this.x;
        h = h * 31 + this.y;
        h = h * 31 + this.z;
        h = h * 31 + this.dim;
        return h;
    }
}

