/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.selections.Point;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AreaBase {
    protected Point high;
    protected Point low;
    private static final Pattern pattern = Pattern.compile("\\s*\\{\\s*(\\[.*\\])\\s*,\\s*(\\[.*\\])\\s*\\}\\s*");

    public AreaBase(Point p1, Point p2) {
        this.low = AreaBase.getMinPoint(p1, p2);
        this.high = AreaBase.getMaxPoint(p1, p2);
    }

    public int getXLength() {
        return this.high.getX() - this.low.getX() + 1;
    }

    public int getYLength() {
        return this.high.getY() - this.low.getY() + 1;
    }

    public int getZLength() {
        return this.high.getZ() - this.low.getZ() + 1;
    }

    public Point getHighPoint() {
        return this.high;
    }

    public Point getLowPoint() {
        return this.low;
    }

    public Point getSize() {
        return new Point(this.high.x - this.low.x, this.high.y - this.low.y, this.high.z - this.low.z);
    }

    public static Point getMinPoint(Point p1, Point p2) {
        return new Point(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
    }

    public static Point getMaxPoint(Point p1, Point p2) {
        return new Point(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public boolean contains(Point p) {
        return this.high.isGreaterEqualThan(p) && this.low.isLessEqualThan(p);
    }

    public boolean contains(AreaBase area) {
        return this.contains(area.high) && this.contains(area.low);
    }

    public boolean intersectsWith(AreaBase area) {
        return this.getIntersection(area) != null;
    }

    public AreaBase getIntersection(AreaBase area) {
        if (area == null) {
            return null;
        }
        boolean hasIntersection = false;
        Point p = new Point(0, 0, 0);
        Point minp = new Point(0, 0, 0);
        Point maxp = new Point(0, 0, 0);
        int[] xs = new int[]{this.low.x, this.high.x, area.low.x, area.high.x};
        int[] ys = new int[]{this.low.y, this.high.y, area.low.y, area.high.y};
        int[] zs = new int[]{this.low.z, this.high.z, area.low.z, area.high.z};
        for (int x : xs) {
            p.setX(x);
            for (int y : ys) {
                p.setY(y);
                for (int z : zs) {
                    p.setZ(z);
                    if (!this.contains(p) || !area.contains(p)) continue;
                    if (!hasIntersection) {
                        hasIntersection = true;
                        minp = p;
                        maxp = p;
                        continue;
                    }
                    minp = AreaBase.getMinPoint(minp, p);
                    maxp = AreaBase.getMaxPoint(maxp, p);
                }
            }
        }
        if (!hasIntersection) {
            return null;
        }
        return new AreaBase(minp, maxp);
    }

    public boolean makesCuboidWith(AreaBase area) {
        boolean alignX = this.low.getX() == area.low.getX() && this.high.getX() == area.high.getX();
        boolean alignY = this.low.getY() == area.low.getY() && this.high.getY() == area.high.getY();
        boolean alignZ = this.low.getZ() == area.low.getZ() && this.high.getZ() == area.high.getZ();
        return alignX || alignY || alignZ;
    }

    public AreaBase getUnity(AreaBase area) {
        if (!this.makesCuboidWith(area)) {
            return null;
        }
        return new AreaBase(AreaBase.getMinPoint(this.low, area.low), AreaBase.getMaxPoint(this.high, area.high));
    }

    public void redefine(Point p1, Point p2) {
        this.low = AreaBase.getMinPoint(p1, p2);
        this.high = AreaBase.getMaxPoint(p1, p2);
    }

    public AreaBase copy() {
        return new AreaBase(this.low, this.high);
    }

    public String toString() {
        return "{" + this.high.toString() + " , " + this.low.toString() + " }";
    }

    public static AreaBase fromString(String value) {
        Matcher match = pattern.matcher(value);
        if (!match.matches()) {
            return null;
        }
        Point p1 = Point.fromString(match.group(1));
        Point p2 = Point.fromString(match.group(2));
        if (p1 == null || p2 == null) {
            return null;
        }
        return new AreaBase(p1, p2);
    }

    public Point getCenter() {
        return new Point((this.high.x + this.low.x) / 2, (this.high.y + this.low.y) / 2, (this.high.z + this.low.z) / 2);
    }
}

