/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class BuildInfo {
    private static final String BUILD_TYPE_NIGHTLY = "nightly";
    private static String buildHash = "N/A";
    private static int buildNumber = 0;
    private static int buildNumberLatest = 0;
    private static Thread checkVersionThread;
    private static Thread checkBuildTypesThread;
    private static Properties buildTypes;
    public static final String MC_BASE_VERSION = "1.7.10";
    public static final String BASE_VERSION = "1.4.4";

    public static void getBuildInfo(File jarFile) {
        block17: {
            try {
                if (jarFile != null) {
                    try (JarFile jar = new JarFile(jarFile);){
                        Manifest manifest = jar.getManifest();
                        buildHash = manifest.getMainAttributes().getValue("BuildID");
                        try {
                            buildNumber = Integer.parseInt(manifest.getMainAttributes().getValue("BuildNumber"));
                        }
                        catch (NumberFormatException e) {
                            buildNumber = 0;
                        }
                        break block17;
                    }
                }
                System.err.println(String.format("Unable to get FE version information (dev env / %s)", BASE_VERSION));
            }
            catch (IOException e1) {
                System.err.println(String.format("Unable to get FE version information (%s)", BASE_VERSION));
            }
        }
    }

    private static void doCheckLatestVersion() {
        try {
            URL buildInfoUrl = new URL("http://ci.forgeessentials.com/job/FE/lastSuccessfulBuild/api/json");
            URLConnection con = buildInfoUrl.openConnection();
            con.setConnectTimeout(6000);
            con.setReadTimeout(12000);
            con.connect();
            try (InputStreamReader is = new InputStreamReader(con.getInputStream());){
                JsonObject versionInfo = (JsonObject)new GsonBuilder().create().fromJson((Reader)is, JsonObject.class);
                buildNumberLatest = versionInfo.get("number").getAsInt();
            }
        }
        catch (JsonIOException | JsonSyntaxException e) {
            System.err.println("Unable to parse version info");
        }
        catch (IOException e) {
            System.err.println("Unable to retrieve version info");
        }
    }

    private static void joinVersionThread() {
        if (checkVersionThread == null) {
            return;
        }
        try {
            checkVersionThread.join();
            checkVersionThread = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void doCheckBuildTypes() {
        try {
            URL buildInfoUrl = new URL("http://files.forgeessentials.com/buildtypes_1.7.10.txt");
            URLConnection con = buildInfoUrl.openConnection();
            con.setConnectTimeout(6000);
            con.setReadTimeout(12000);
            con.connect();
            buildTypes.load(con.getInputStream());
        }
        catch (IOException e) {
            System.err.println("Unable to retrieve build types");
        }
    }

    private static void joinBuildTypeThread() {
        if (checkBuildTypesThread == null) {
            return;
        }
        try {
            checkBuildTypesThread.join();
            checkBuildTypesThread = null;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void cancelVersionCheck() {
        checkVersionThread = null;
    }

    public static String getFullVersion() {
        if (buildNumber == 0) {
            return BASE_VERSION;
        }
        return "1.4.4." + buildNumber;
    }

    public static String getBuildHash() {
        return buildHash;
    }

    public static int getBuildNumber() {
        return buildNumber;
    }

    public static int getBuildNumberLatest() {
        BuildInfo.joinVersionThread();
        return buildNumberLatest;
    }

    public static boolean isOutdated() {
        BuildInfo.joinVersionThread();
        return buildNumber > 0 && buildNumberLatest > buildNumber;
    }

    public static String getBuildType() {
        BuildInfo.joinBuildTypeThread();
        return buildTypes.getProperty(Integer.toString(buildNumber), BUILD_TYPE_NIGHTLY);
    }

    static {
        buildTypes = new Properties();
        checkVersionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BuildInfo.doCheckLatestVersion();
            }
        });
        checkVersionThread.start();
        checkBuildTypesThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BuildInfo.doCheckBuildTypes();
            }
        });
        checkBuildTypesThread.start();
    }
}

