/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.client.handler;

import com.forgeessentials.commons.network.Packet3PlayerPermissions;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class PermissionOverlay
extends Gui
implements IMessageHandler<Packet3PlayerPermissions, IMessage> {
    protected ResourceLocation deniedPlaceTexture;
    protected ResourceLocation deniedBreakTexture;
    protected Packet3PlayerPermissions permissions = new Packet3PlayerPermissions();

    public PermissionOverlay() {
        this.deniedPlaceTexture = new ResourceLocation("ForgeEssentialsClient".toLowerCase(), "textures/gui/denied_place.png");
        this.deniedBreakTexture = new ResourceLocation("ForgeEssentialsClient".toLowerCase(), "textures/gui/denied_break.png");
        this.field_73735_i = 100.0f;
    }

    public IMessage onMessage(Packet3PlayerPermissions message, MessageContext ctx) {
        if (message.reset) {
            this.permissions = message;
        } else {
            this.permissions.placeIds.addAll(message.placeIds);
            this.permissions.breakIds.addAll(message.breakIds);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stack = player.func_71045_bC();
            if (stack != null) {
                int itemId = GameData.getItemRegistry().getId((Object)stack.func_77973_b());
                for (int id : message.placeIds) {
                    if (itemId != id) continue;
                    player.func_71034_by();
                    break;
                }
            }
        }
        return null;
    }

    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGameOverlayEvent event) {
        if (!event.isCancelable() && event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.deniedPlaceTexture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            for (int i = 0; i < 9; ++i) {
                int id;
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a[i];
                if (stack == null || !this.permissions.placeIds.contains(id = GameData.getItemRegistry().getId((Object)stack.func_77973_b()))) continue;
                int x = width / 2 - 90 + i * 20 + 2;
                int y = height - 16 - 3;
                this.drawTexturedRect(x + 8, y + 1, 8.0, 8.0);
            }
        } else if (event.isCancelable() && event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                Block block = Minecraft.func_71410_x().field_71441_e.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                int blockId = GameData.getBlockRegistry().getId((Object)block);
                if (this.permissions.breakIds.contains(blockId)) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(this.deniedBreakTexture);
                    this.drawTexturedRect(width / 2 - 5, height / 2 - 5, 10.0, 10.0);
                    event.setCanceled(true);
                }
            }
        }
    }

    public void drawTexturedRect(double xPos, double yPos, double width, double height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(xPos, yPos + height, (double)this.field_73735_i, 0.0, 1.0);
        tessellator.func_78374_a(xPos + width, yPos + height, (double)this.field_73735_i, 1.0, 1.0);
        tessellator.func_78374_a(xPos + width, yPos, (double)this.field_73735_i, 1.0, 0.0);
        tessellator.func_78374_a(xPos, yPos, (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78381_a();
    }
}

