/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.client.core;

import com.forgeessentials.client.ForgeEssentialsClient;
import com.forgeessentials.client.auth.ClientAuthNetHandler;
import com.forgeessentials.client.core.CommonProxy;
import com.forgeessentials.client.core.FEClientCommand;
import com.forgeessentials.client.handler.CUIRenderrer;
import com.forgeessentials.client.handler.PermissionOverlay;
import com.forgeessentials.client.handler.QRRenderer;
import com.forgeessentials.client.handler.QuestionerKeyHandler;
import com.forgeessentials.client.handler.ReachDistanceHandler;
import com.forgeessentials.commons.BuildInfo;
import com.forgeessentials.commons.network.NetworkUtils;
import com.forgeessentials.commons.network.Packet0Handshake;
import com.forgeessentials.commons.network.Packet1SelectionUpdate;
import com.forgeessentials.commons.network.Packet2Reach;
import com.forgeessentials.commons.network.Packet3PlayerPermissions;
import com.forgeessentials.commons.network.Packet5Noclip;
import com.forgeessentials.commons.network.Packet6AuthLogin;
import com.forgeessentials.commons.network.Packet7Remote;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

public class ClientProxy
extends CommonProxy {
    public static final String CONFIG_CAT = "general";
    private static Configuration config;
    private static int clientTimeTicked;
    private static boolean sentHandshake;
    public static boolean allowCUI;
    public static boolean allowQRCodeRender;
    public static boolean allowPermissionRender;
    public static boolean allowQuestionerShortcuts;
    public static boolean allowAuthAutoLogin;
    public static float reachDistance;
    private static CUIRenderrer cuiRenderer;
    private static QRRenderer qrCodeRenderer;
    private static PermissionOverlay permissionOverlay;
    private ReachDistanceHandler reachDistanceHandler = new ReachDistanceHandler();

    public ClientProxy() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void doPreInit(FMLPreInitializationEvent event) {
        BuildInfo.getBuildInfo(event.getSourceFile());
        ForgeEssentialsClient.feclientlog.info(String.format("Running ForgeEssentials client %s (%s)", BuildInfo.getFullVersion(), BuildInfo.getBuildHash()));
        config = new Configuration(event.getSuggestedConfigurationFile());
        this.loadConfig();
        this.registerNetworkMessages();
    }

    @Override
    public void load(FMLInitializationEvent event) {
        super.load(event);
        ClientCommandHandler.instance.func_71560_a((ICommand)new FEClientCommand());
    }

    private void registerNetworkMessages() {
        NetworkUtils.registerMessageProxy(Packet0Handshake.class, 0, Side.SERVER, new NetworkUtils.NullMessageHandler<Packet0Handshake>(){});
        NetworkUtils.registerMessage(cuiRenderer, Packet1SelectionUpdate.class, 1, Side.CLIENT);
        NetworkUtils.registerMessage(this.reachDistanceHandler, Packet2Reach.class, 2, Side.CLIENT);
        NetworkUtils.registerMessage(permissionOverlay, Packet3PlayerPermissions.class, 3, Side.CLIENT);
        NetworkUtils.registerMessage(new IMessageHandler<Packet5Noclip, IMessage>(){

            public IMessage onMessage(Packet5Noclip message, MessageContext ctx) {
                FMLClientHandler.instance().getClientPlayerEntity().field_70145_X = message.getNoclip();
                return null;
            }
        }, Packet5Noclip.class, 5, Side.CLIENT);
        NetworkUtils.registerMessage(new ClientAuthNetHandler(), Packet6AuthLogin.class, 6, Side.CLIENT);
        NetworkUtils.registerMessage(qrCodeRenderer, Packet7Remote.class, 7, Side.CLIENT);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("ForgeEssentialsClient")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        config.load();
        config.addCustomCategoryComment(CONFIG_CAT, "Configure ForgeEssentials Client addon features.");
        allowCUI = config.getBoolean("allowCUI", CONFIG_CAT, true, "Set to false to disable graphical selections.");
        allowQRCodeRender = config.get(CONFIG_CAT, "allowQRCodeRender", true, "Set to false to disable QR code rendering when you enter /remote qr.").getBoolean(true);
        allowPermissionRender = config.get(CONFIG_CAT, "allowPermRender", true, "Set to false to disable visual indication of block/item permissions").getBoolean(true);
        allowQuestionerShortcuts = config.get(CONFIG_CAT, "allowQuestionerShortcuts", true, "Use shortcut buttons to answer questions. Defaults are F8 for yes and F9 for no, change in game options menu.").getBoolean(true);
        allowAuthAutoLogin = config.get(CONFIG_CAT, "allowAuthAutoLogin", true, "Save tokens to automatically log in to servers using FE's Authentication Module.").getBoolean(true);
        if (allowCUI) {
            MinecraftForge.EVENT_BUS.register((Object)cuiRenderer);
        }
        if (allowQRCodeRender) {
            MinecraftForge.EVENT_BUS.register((Object)qrCodeRenderer);
        }
        if (allowPermissionRender) {
            MinecraftForge.EVENT_BUS.register((Object)permissionOverlay);
        }
        if (allowQuestionerShortcuts) {
            new QuestionerKeyHandler();
        }
        config.save();
    }

    public static Configuration getConfig() {
        return config;
    }

    @SubscribeEvent
    public void connectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        clientTimeTicked = 0;
        sentHandshake = false;
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (!sentHandshake && ++clientTimeTicked > 20) {
            sentHandshake = true;
            this.sendClientHandshake();
        }
    }

    public void sendClientHandshake() {
        if (ForgeEssentialsClient.serverHasFE()) {
            NetworkUtils.netHandler.sendToServer((IMessage)new Packet0Handshake());
        }
    }

    public static void resendHandshake() {
        sentHandshake = false;
    }

    static {
        sentHandshake = true;
        cuiRenderer = new CUIRenderrer();
        qrCodeRenderer = new QRRenderer();
        permissionOverlay = new PermissionOverlay();
    }
}

