/*
 * Decompiled with CFR 0.152.
 */
package tehnut.redstonearmory.util.annot;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import tehnut.redstonearmory.util.LogHelper;
import tehnut.redstonearmory.util.annot.Register;

public class Registerer {
    public static void scan(Class<?> targetClass) {
        Side side = FMLCommonHandler.instance().getSide();
        for (Field field : targetClass.getFields()) {
            Register registerAnnotation = field.getAnnotation(Register.class);
            Class<?> clazz = field.getType();
            if (registerAnnotation == null || !registerAnnotation.dependency().isEmpty() && !Loader.isModLoaded((String)registerAnnotation.dependency())) continue;
            if (Modifier.isStatic(field.getModifiers())) {
                if (Item.class.isAssignableFrom(clazz)) {
                    Registerer.registerItem(side, field, registerAnnotation, clazz);
                    continue;
                }
                if (Block.class.isAssignableFrom(clazz)) {
                    Registerer.registerBlock(side, field, registerAnnotation, clazz);
                    continue;
                }
                LogHelper.warn("Can only register Blocks and Items - " + field.getName() + " unrecognised");
                continue;
            }
            LogHelper.warn("Can't register non-static field " + field.getName());
        }
    }

    private static void registerItem(Side side, Field field, Register registerAnnotation, Class<? extends Item> clazz) {
        try {
            Item item = (Item)field.get(null);
            if (item == null) {
                item = (Item)Registerer.getConstructed(clazz);
                field.set(null, item);
            }
            if (!registerAnnotation.unlocalizedName().isEmpty()) {
                item.func_77655_b(registerAnnotation.unlocalizedName());
            }
            GameRegistry.registerItem((Item)item, (String)Registerer.getName(registerAnnotation, item));
            if (side == Side.CLIENT && registerAnnotation.IItemRenderer() != IItemRenderer.class) {
                MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)registerAnnotation.IItemRenderer().newInstance());
            }
        }
        catch (IllegalAccessException e) {
            LogHelper.warn("Failed to register item " + registerAnnotation.name());
        }
        catch (InstantiationException e) {
            LogHelper.warn("Failed to register item " + registerAnnotation.name());
        }
    }

    private static void registerBlock(Side side, Field field, Register registerAnnotation, Class<? extends Block> clazz) {
        try {
            Block block = (Block)field.get(null);
            if (block == null) {
                block = (Block)Registerer.getConstructed(clazz);
                field.set(null, block);
            }
            if (!registerAnnotation.unlocalizedName().isEmpty()) {
                block.func_149663_c(registerAnnotation.unlocalizedName());
            }
            GameRegistry.registerBlock((Block)block, registerAnnotation.itemBlock(), (String)Registerer.getName(registerAnnotation, block));
            if (registerAnnotation.tileEntity() != TileEntity.class) {
                GameRegistry.registerTileEntity(registerAnnotation.tileEntity(), (String)Registerer.getName(registerAnnotation, block));
            }
            if (side == Side.CLIENT) {
                if (registerAnnotation.SBRH() != ISimpleBlockRenderingHandler.class) {
                    RenderingRegistry.registerBlockHandler((int)block.func_149645_b(), (ISimpleBlockRenderingHandler)registerAnnotation.SBRH().newInstance());
                } else if (registerAnnotation.tileEntity() != TileEntity.class && registerAnnotation.TESR() != TileEntitySpecialRenderer.class) {
                    ClientRegistry.bindTileEntitySpecialRenderer(registerAnnotation.tileEntity(), (TileEntitySpecialRenderer)registerAnnotation.TESR().newInstance());
                }
                if (registerAnnotation.IItemRenderer() != IItemRenderer.class) {
                    MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)registerAnnotation.IItemRenderer().newInstance());
                }
            }
        }
        catch (IllegalAccessException e) {
            LogHelper.warn("Failed to register item " + registerAnnotation.name());
        }
        catch (InstantiationException e) {
            LogHelper.warn("Failed to register item " + registerAnnotation.name());
        }
    }

    private static String getName(Register registerAnnotation, Item item) {
        return registerAnnotation.name().isEmpty() ? item.getClass().getSimpleName() : registerAnnotation.name();
    }

    private static String getName(Register registerAnnotation, Block block) {
        return registerAnnotation.name().isEmpty() ? block.getClass().getSimpleName() : registerAnnotation.name();
    }

    private static <T> T getConstructed(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

