/*
 * Decompiled with CFR 0.152.
 */
package tehnut.redstonearmory.util;

import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import tehnut.redstonearmory.enums.EnergyType;
import tehnut.redstonearmory.util.Utils;

public class TooltipHelper {
    public static void doEnergyTip(ItemStack stack, List list, int maxEnergy, int currentEnergy, int energyPerUse, int energyPerUseCharged) {
        list.add(Utils.localizeFormatted("info.RArm.tooltip.getenergy", currentEnergy, maxEnergy));
        if (TooltipHelper.isEmpowered(stack)) {
            list.add(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + Utils.localizeFormatted("info.RArm.tooltip.extinguish", Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey())));
            list.add(EnumChatFormatting.GOLD + Utils.localizeFormatted("info.RArm.tooltip.peruse", TooltipHelper.getEnergyPerUse(stack, energyPerUse, energyPerUseCharged)));
        } else {
            list.add(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + Utils.localizeFormatted("info.RArm.tooltip.empower", Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey())));
            list.add(EnumChatFormatting.GOLD + Utils.localizeFormatted("info.RArm.tooltip.peruse", TooltipHelper.getEnergyPerUse(stack, energyPerUse, energyPerUseCharged)));
        }
    }

    public static void doCapacitorTip(ItemStack stack, List list) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        if (StringHelper.isShiftKeyDown()) {
            if (stack.func_77960_j() == EnergyType.CREATIVE.ordinal()) {
                list.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
                list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + EnergyType.CREATIVE.send + " RF/t");
            } else {
                list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)stack.field_77990_d.func_74762_e("Energy")) + " / " + StringHelper.getScaledNumber((long)EnergyType.values()[stack.func_77960_j()].capacity) + " RF");
                list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + EnergyType.values()[stack.func_77960_j()].send + "/" + EnergyType.values()[stack.func_77960_j()].recieve + " RF/t");
            }
            if (TooltipHelper.isActive(stack)) {
                list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.2"));
                list.add(StringHelper.getInfoText((String)"info.RArm.capacitor.armor.charging"));
                list.add(StringHelper.getInfoText((String)"info.RArm.capacitor.slot"));
                list.add(StringHelper.getDeactivationText((String)"info.thermalexpansion.capacitor.3"));
            } else {
                list.add(StringHelper.getInfoText((String)"info.thermalexpansion.capacitor.0"));
                list.add(StringHelper.getInfoText((String)"info.RArm.capacitor.armor"));
                list.add(StringHelper.getInfoText((String)"info.RArm.capacitor.slot"));
                list.add(StringHelper.getActivationText((String)"info.thermalexpansion.capacitor.1"));
            }
        }
    }

    public static void doDamageTip(ItemStack stack, List list, int energyPerUse, int damage, int damageCharged) {
        list.add("");
        if (stack.field_77990_d.func_74762_e("Energy") >= energyPerUse) {
            list.add(EnumChatFormatting.BLUE + Utils.localizeFormatted("info.RArm.tooltip.damage", damage));
            if (TooltipHelper.isEmpowered(stack)) {
                list.add(EnumChatFormatting.GREEN + Utils.localizeFormatted("info.RArm.tooltip.damage.flux", damageCharged));
            }
        } else {
            list.add(EnumChatFormatting.BLUE + Utils.localizeFormatted("info.RArm.tooltip.damage", "0"));
        }
    }

    private static boolean isEmpowered(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("Empowered");
    }

    private static boolean isActive(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("Active");
    }

    private static int getEnergyPerUse(ItemStack stack, int energyPerUse, int energyPerUseCharged) {
        int unbreakingLevel = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack), (int)0, (int)4);
        return (TooltipHelper.isEmpowered(stack) ? energyPerUseCharged : energyPerUse) * (5 - unbreakingLevel) / 5;
    }
}

