/*
 * Decompiled with CFR 0.152.
 */
package tehnut.redstonearmory.items.tools.gelidenderium;

import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.tool.ItemAxeRF;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import tehnut.redstonearmory.ConfigHandler;
import tehnut.redstonearmory.RedstoneArmory;
import tehnut.redstonearmory.util.KeyboardHelper;
import tehnut.redstonearmory.util.TooltipHelper;

public class ItemAxeGelidEnderium
extends ItemAxeRF {
    public int damage = 8;
    public int damageCharged = 1;
    IIcon activeIcon;
    IIcon drainedIcon;
    Random random = new Random();

    public ItemAxeGelidEnderium(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.func_77637_a(RedstoneArmory.tabRArm);
        this.func_77655_b("RArm.tool.enderium.gelid.axe");
        this.setNoRepair();
        this.func_77656_e(0);
        this.maxEnergy = 320000;
        this.energyPerUse = 350;
        this.energyPerUseCharged = 600;
        this.effectiveMaterials.add((Object)Material.field_151575_d);
        this.effectiveMaterials.add((Object)Material.field_151585_k);
        this.effectiveMaterials.add((Object)Material.field_151584_j);
        this.effectiveMaterials.add((Object)Material.field_151582_l);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.isEmpowered(stack) ? this.activeIcon : (this.getEnergyStored(stack) <= 0 ? this.drainedIcon : this.field_77791_bV);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("RArm:tools/gelidEnderiumAxe");
        this.activeIcon = iconRegister.func_94245_a("RArm:tools/gelidEnderiumAxe_active");
        this.drainedIcon = iconRegister.func_94245_a("RArm:tools/gelidEnderiumAxe_drained");
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        if ((double)block.func_149712_f(world, x, y, z) == 0.0) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (ConfigHandler.enableAxeMultiBreak && block.func_149688_o() == Material.field_151575_d && this.isEmpowered(stack)) {
            for (int i = x - 2; i <= x + 2; ++i) {
                for (int k = z - 2; k <= z + 2; ++k) {
                    for (int j = y - 2; j <= y + 2; ++j) {
                        if (world.func_147439_a(i, j, k).func_149688_o() != Material.field_151575_d) continue;
                        this.harvestBlock(world, i, j, k, player);
                    }
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (ConfigHandler.enableAxeWeatherClear) {
            if (!world.field_72995_K && this.isEmpowered(stack) && (world.func_72896_J() || world.func_72911_I())) {
                WorldServer worldserver = MinecraftServer.func_71276_C().field_71305_c[0];
                WorldInfo worldinfo = worldserver.func_72912_H();
                int i = (300 + new Random().nextInt(600)) * 20;
                worldinfo.func_76084_b(false);
                worldinfo.func_76069_a(false);
                worldinfo.func_76080_g(i);
                if (this.random.nextInt(50) == 0) {
                    world.func_72838_d((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v));
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    this.useEnergy(stack, false);
                }
            }
            player.func_71038_i();
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int hitSide, float hitX, float hitY, float hitZ) {
        if (ConfigHandler.enableAxeLightning && this.getEnergyStored(stack) >= this.getEnergyPerUse(stack)) {
            if (!this.isEmpowered(stack)) {
                world.func_72838_d((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
            } else if (this.isEmpowered(stack) && this.getEnergyStored(stack) >= this.energyPerUseCharged) {
                for (int i = 0; i <= 10; ++i) {
                    world.func_72838_d((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
                    if (this.random.nextInt(50) != 0) continue;
                    world.func_72838_d((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v));
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !KeyboardHelper.isShiftDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        TooltipHelper.doEnergyTip(stack, list, this.getMaxEnergyStored(stack), this.getEnergyStored(stack), this.getEnergyPerUse(stack), this.energyPerUseCharged);
        TooltipHelper.doDamageTip(stack, list, this.getEnergyPerUse(stack), this.damage, this.damageCharged);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }
}

