/*
 * Decompiled with CFR 0.152.
 */
package tehnut.redstonearmory.items.powersuit;

import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.armor.ItemArmorRF;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import tehnut.redstonearmory.RedstoneArmory;
import tehnut.redstonearmory.items.powersuit.upgrades.FallPreventionUpgrade;
import tehnut.redstonearmory.util.KeyboardHelper;
import tehnut.redstonearmory.util.Utils;

public class ItemPowersuit
extends ItemArmorRF {
    public ItemPowersuit(int type) {
        super(ItemArmor.ArmorMaterial.CHAIN, type);
        this.setNoRepair();
        this.func_77637_a(RedstoneArmory.tabRArm);
        this.func_77656_e(0);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.maxEnergy = 10000000;
        this.energyPerDamage = 1;
        this.absorbRatio = 1.0;
        this.maxTransfer = 4500;
        switch (type) {
            case 0: {
                this.func_111206_d("RArm:armor/powersuitHelm");
                this.func_77655_b("RArm.armor.powersuit.helm");
                break;
            }
            case 1: {
                this.func_111206_d("RArm:armor/powersuitChestplate");
                this.func_77655_b("RArm.armor.powersuit.chestplate");
                break;
            }
            case 2: {
                this.func_111206_d("RArm:armor/powersuitLeggings");
                this.func_77655_b("RArm.armor.powersuit.leggings");
                break;
            }
            case 3: {
                this.func_111206_d("RArm:armor/powersuitBoots");
                this.func_77655_b("RArm.armor.powersuit.boots");
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer entity = (EntityPlayer)event.entity;
            if (entity.field_71071_by.field_70460_b[0] != null && entity.field_71071_by.field_70460_b[0].func_77973_b() == this) {
                int fallDamage;
                int realCost;
                FallPreventionUpgrade upgrade = new FallPreventionUpgrade();
                ItemStack stack = entity.field_71071_by.field_70460_b[0];
                if (this.isInstalled("FallPrevention", stack) && (realCost = upgrade.energyUsed * (fallDamage = (int)event.distance - 3)) <= this.getEnergyStored(stack)) {
                    this.extractEnergy(stack, realCost, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    public boolean isInstalled(String upgrade, ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74767_n(upgrade);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int Slot, String type) {
        switch (Slot) {
            case 0: {
                return "RArm:textures/models/armor/powersuit_1.png";
            }
            case 1: {
                return "RArm:textures/models/armor/powersuit_1.png";
            }
            case 2: {
                return "RArm:textures/models/armor/powersuit_2.png";
            }
            case 3: {
                return "RArm:textures/models/armor/powersuit_1.png";
            }
        }
        return type;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
        ItemStack stack = new ItemStack(item, 1, 0);
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)this.maxEnergy);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Energy", 3 * this.maxEnergy / 4);
        tag.func_74757_a("FlightMk1", true);
        tag.func_74757_a("FlightMk2", true);
        tag.func_74757_a("FlightMk3", true);
        tag.func_74757_a("FlightMk4", true);
        tag.func_74757_a("FlightMk5", true);
        tag.func_74757_a("FallPrevention", true);
        tag.func_74757_a("SpeedMk1", true);
        tag.func_74757_a("SpeedMk2", true);
        tag.func_74757_a("SpeedMk3", true);
        tag.func_74757_a("SpeedMk4", true);
        tag.func_74757_a("StepAssist", true);
        tag.func_74757_a("WaterBreathing", true);
        tag.func_74757_a("PotionNullification", true);
        stack.func_77982_d(tag);
        list.add(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown() && !KeyboardHelper.isControlDown()) {
            list.add(StringHelper.shiftForDetails());
            list.add(Utils.localize("info.cofh.hold") + " " + EnumChatFormatting.YELLOW + EnumChatFormatting.ITALIC + Utils.localize("info.RArm.tooltip.control") + EnumChatFormatting.GRAY + " " + Utils.localize("info.RArm.tooltip.forModules"));
            list.add("\u00a74" + StringHelper.localize((String)"info.RArm.tooltip.armor.powersuit.ignore"));
        }
        if (KeyboardHelper.isControlDown()) {
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.flight.t1") + ": " + this.isInstalled("FlightMk1", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.flight.t2") + ": " + this.isInstalled("FlightMk2", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.flight.t3") + ": " + this.isInstalled("FlightMk3", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.flight.t4") + ": " + this.isInstalled("FlightMk4", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.flight.t5") + ": " + this.isInstalled("FlightMk5", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.fall.prevention") + ": " + this.isInstalled("FallPrevention", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.speed.t1") + ": " + this.isInstalled("SpeedMk1", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.speed.t2") + ": " + this.isInstalled("SpeedMk2", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.speed.t3") + ": " + this.isInstalled("SpeedMk3", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.speed.t4") + ": " + this.isInstalled("SpeedMk4", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.step.assist") + ": " + this.isInstalled("StepAssist", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.water.breathing") + ": " + this.isInstalled("WaterBreathing", stack));
            list.add(Utils.localize("info.RArm.tooltip.armor.powersuit.potion.nullification") + ": " + this.isInstalled("PotionNullification", stack));
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + stack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
    }

    protected int getAbsorptionRatio() {
        switch (this.field_77881_a) {
            case 0: {
                return 15;
            }
            case 1: {
                return 45;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 10;
            }
        }
        return 0;
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1 + this.maxEnergy - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.maxEnergy;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != Short.MAX_VALUE;
    }

    protected int getBaseAbsorption() {
        return 20;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }
}

