/*
 * Decompiled with CFR 0.152.
 */
package tehnut.redstonearmory.items.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import cofh.api.energy.IEnergyContainerItem;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.EnergyHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tehnut.redstonearmory.compat.CompatibilityBaubles;
import tehnut.redstonearmory.enums.EnergyType;
import tehnut.redstonearmory.items.baubles.ItemBaubleBase;
import tehnut.redstonearmory.util.TooltipHelper;

public class ItemCapacitorAmulet
extends ItemBaubleBase
implements IEnergyContainerItem {
    private IIcon[] icon = new IIcon[EnergyType.values().length + 1];

    public ItemCapacitorAmulet() {
        super("capacitor.", BaubleType.AMULET);
    }

    public static ItemStack getStackItem(EnergyType type) {
        return new ItemStack(CompatibilityBaubles.capacitorBauble, 1, type.ordinal());
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (CoreUtils.isFakePlayer((EntityPlayer)player)) {
            return stack;
        }
        if (player.func_70093_af() && this.setActiveState(stack, !this.isActive(stack))) {
            if (this.isActive(stack)) {
                world.func_72956_a((Entity)player, "random.orb", 0.2f, 0.8f);
            } else {
                world.func_72956_a((Entity)player, "random.orb", 0.2f, 0.5f);
            }
            player.func_71038_i();
        }
        return stack;
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        return this.isActive(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77960_j() != EnergyType.CREATIVE.ordinal();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        int currentEnergy = stack.field_77990_d.func_74762_e("Energy");
        return 1.0 - (double)currentEnergy / (double)EnergyType.values()[stack.func_77960_j()].capacity;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, EnergyType.CREATIVE.ordinal()), (int)EnergyType.CREATIVE.capacity));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, EnergyType.TUBEROUS.ordinal()), (int)EnergyType.TUBEROUS.capacity));
        for (int i = 2; i < EnergyType.values().length; ++i) {
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, i), (int)0));
            list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, i), (int)EnergyType.values()[i].capacity));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + EnergyType.values()[stack.func_77960_j()].toString();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77960_j() == EnergyType.CREATIVE.ordinal()) {
            return EnumRarity.epic;
        }
        if (stack.func_77960_j() == EnergyType.REINFORCED.ordinal()) {
            return EnumRarity.uncommon;
        }
        if (stack.func_77960_j() == EnergyType.RESONANT.ordinal()) {
            return EnumRarity.rare;
        }
        return EnumRarity.common;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean held) {
        TooltipHelper.doCapacitorTip(stack, list);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        if (pass == 1) {
            return this.icon[meta];
        }
        return this.icon[6];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon[0] = ir.func_94245_a("ThermalExpansion:capacitor/CapacitorCreative");
        this.icon[1] = ir.func_94245_a("ThermalExpansion:capacitor/CapacitorPotato");
        this.icon[2] = ir.func_94245_a("ThermalExpansion:capacitor/CapacitorBasic");
        this.icon[3] = ir.func_94245_a("ThermalExpansion:capacitor/CapacitorHardened");
        this.icon[4] = ir.func_94245_a("ThermalExpansion:capacitor/CapacitorReinforced");
        this.icon[5] = ir.func_94245_a("ThermalExpansion:capacitor/CapacitorResonant");
        this.icon[6] = ir.func_94245_a("RArm:capacitorNecklace");
    }

    public int getRenderPasses(int metadata) {
        return this.func_77623_v() ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public boolean isActive(ItemStack stack) {
        return stack.field_77990_d != null && stack.field_77990_d.func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack stack, boolean active) {
        if (this.getEnergyStored(stack) > 0) {
            stack.field_77990_d.func_74757_a("Active", active);
            return true;
        }
        stack.field_77990_d.func_74757_a("Active", false);
        return false;
    }

    public int receiveEnergy(ItemStack stack, int i, boolean simulate) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        int energy = stack.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(i, Math.min(EnergyType.values()[stack.func_77960_j()].capacity - energy, EnergyType.values()[stack.func_77960_j()].recieve));
        if (!simulate) {
            stack.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack stack, int extract, boolean simulate) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        int energy = stack.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(extract, Math.min(energy, EnergyType.values()[stack.func_77960_j()].send));
        if (!simulate) {
            stack.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return EnergyType.values()[stack.func_77960_j()].capacity;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entityLivingBase) {
        if (this.isActive(stack) && !entityLivingBase.field_70170_p.field_72995_K) {
            InventoryPlayer inventory = ((EntityPlayer)entityLivingBase).field_71071_by;
            int toSend = Math.min(this.getEnergyStored(stack), EnergyType.values()[stack.func_77960_j()].send);
            ItemStack currentItem = inventory.func_70448_g();
            if (EnergyHelper.isEnergyContainerItem((ItemStack)currentItem)) {
                IEnergyContainerItem containerItem = (IEnergyContainerItem)currentItem.func_77973_b();
                this.extractEnergy(stack, containerItem.receiveEnergy(currentItem, toSend, false), false);
            }
            for (int i = 0; i <= 3; ++i) {
                ItemStack check = inventory.func_70440_f(i);
                if (!EnergyHelper.isEnergyContainerItem((ItemStack)check)) continue;
                IEnergyContainerItem containerItem = (IEnergyContainerItem)check.func_77973_b();
                this.extractEnergy(stack, containerItem.receiveEnergy(check, toSend, false), false);
            }
            if (stack.func_77960_j() == EnergyType.TUBEROUS.ordinal() && this.getEnergyStored(stack) <= 0) {
                BaublesApi.getBaubles((EntityPlayer)((EntityPlayer)entityLivingBase)).func_70298_a(0, 1);
                ((EntityPlayer)entityLivingBase).field_71071_by.func_70441_a(new ItemStack(Items.field_151168_bH, 1, 0));
            }
        }
    }
}

