/*
 * Decompiled with CFR 0.152.
 */
package tehnut.redstonearmory.items.armor;

import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.RAItems;
import cofh.redstonearsenal.item.armor.ItemArmorRF;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.ISpecialArmor;
import tehnut.redstonearmory.RedstoneArmory;
import tehnut.redstonearmory.util.Utils;

public class ItemEnderiumArmor
extends ItemArmorRF {
    public static final ISpecialArmor.ArmorProperties UNBLOCKABLE = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    public static final ISpecialArmor.ArmorProperties FLUX = new ISpecialArmor.ArmorProperties(0, 0.5, Integer.MAX_VALUE);

    public ItemEnderiumArmor(int type) {
        super(RAItems.ARMOR_MATERIAL_FLUX, type);
        this.setNoRepair();
        this.func_77637_a(RedstoneArmory.tabRArm);
        this.func_77656_e(5);
        this.maxEnergy = 1000000;
        this.energyPerDamage = 200;
        this.absorbRatio = 1.2;
        this.maxTransfer = 4500;
        switch (type) {
            case 0: {
                this.func_111206_d("RArm:armor/enderiumHelm");
                this.func_77655_b("RArm.armor.enderium.helm");
                break;
            }
            case 1: {
                this.func_111206_d("RArm:armor/enderiumChestplate");
                this.func_77655_b("RArm.armor.enderium.chestplate");
                break;
            }
            case 2: {
                this.func_111206_d("RArm:armor/enderiumLeggings");
                this.func_77655_b("RArm.armor.enderium.leggings");
                break;
            }
            case 3: {
                this.func_111206_d("RArm:armor/enderiumBoots");
                this.func_77655_b("RArm.armor.enderium.boots");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack Stack, Entity entity, int Slot, String type) {
        if (Slot == 2) {
            return "RArm:textures/models/armor/enderiumArmor_2.png";
        }
        return "RArm:textures/models/armor/enderiumArmor_1.png";
    }

    protected int getAbsorptionRatio() {
        switch (this.field_77881_a) {
            case 0: {
                return 15;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 10;
            }
        }
        return 0;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.getMaxEnergyStored(new ItemStack(item))));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        list.add(Utils.localizeFormatted("info.RArm.tooltip.getenergy", this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
        list.add(EnumChatFormatting.GOLD + Utils.localizeFormatted("info.RArm.tooltip.perdamage", this.energyPerDamage));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    protected int getBaseAbsorption() {
        return 20;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }
}

